/*
 * Decompiled with CFR 0.152.
 */
package com.scglab.common.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.scglab.common.widget.NetworkImageView;
import com.scglab.common.widget.R;

public class RoundImageView
extends NetworkImageView {
    private float[] cornerSize;
    private NetworkImageView.Retouch retouch = new NetworkImageView.Retouch(){

        @Override
        public Bitmap run(Bitmap bitmap) {
            Path clipPath = new Path();
            RectF rect = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
            clipPath.addRoundRect(rect, RoundImageView.this.cornerSize, Path.Direction.CW);
            Bitmap image = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(image);
            canvas.save();
            canvas.clipPath(clipPath);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            canvas.restore();
            return image;
        }
    };

    public RoundImageView(Context context) {
        super(context);
        this.initEmptyImage();
    }

    public RoundImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initEmptyImage();
    }

    public RoundImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initEmptyImage();
    }

    public RoundImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initEmptyImage();
    }

    protected float[] getCornerSize() {
        return this.cornerSize;
    }

    @Override
    protected int[] getStyleable() {
        return R.styleable.RoundImageView;
    }

    @Override
    protected void initStyle(TypedArray typedArray) {
        super.initStyle(typedArray);
        float density = this.getResources().getDisplayMetrics().density;
        this.cornerSize = new float[8];
        float base = typedArray.getFloat(R.styleable.RoundImageView_cornerSize, 0.0f);
        this.cornerSize[0] = this.cornerSize[1] = typedArray.getFloat(R.styleable.RoundImageView_cornerSizeTopLeft, base) * density;
        this.cornerSize[2] = this.cornerSize[3] = typedArray.getFloat(R.styleable.RoundImageView_cornerSizeTopRight, base) * density;
        this.cornerSize[4] = this.cornerSize[5] = typedArray.getFloat(R.styleable.RoundImageView_cornerSizeBottomRight, base) * density;
        this.cornerSize[6] = this.cornerSize[7] = typedArray.getFloat(R.styleable.RoundImageView_cornerSizeBottomLeft, base) * density;
    }

    @Override
    protected void retouchDrawImage(Point point) {
        super.retouchDrawImage(point);
        this.drawImage = this.retouch.run(this.drawImage);
    }

    private void initEmptyImage() {
        if (this.getEmptyImage().hasImage()) {
            this.getEmptyImage().retouch(this.retouch);
        }
    }
}

