/*
 * Decompiled with CFR 0.152.
 */
package com.scglab.common.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.util.AttributeSet;
import com.scglab.common.widget.NetworkImageView;
import com.scglab.common.widget.R;

public class CircleImageView
extends NetworkImageView {
    private int frameColor;
    private int frameStroke;
    private int circleSize;

    public CircleImageView(Context context) {
        super(context);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.circleSize, this.circleSize);
    }

    @Override
    protected int[] getStyleable() {
        return R.styleable.CircleImageView;
    }

    @Override
    protected void initStyle(TypedArray typedArray) {
        super.initStyle(typedArray);
        float density = this.getResources().getDisplayMetrics().density;
        this.frameColor = typedArray.getColor(R.styleable.CircleImageView_frameColor, -1);
        this.frameStroke = typedArray.getInt(R.styleable.CircleImageView_frameStroke, 0);
        this.frameStroke = (int)(density * (float)this.frameStroke);
        this.circleSize = typedArray.getInt(R.styleable.CircleImageView_circleSize, 100);
        this.circleSize = (int)(density * (float)this.circleSize);
        Point point = this.getResultSize();
        this.emptyImage = Bitmap.createScaledBitmap((Bitmap)this.emptyImage, (int)point.x, (int)point.y, (boolean)true);
    }

    @Override
    protected Point getResultSize() {
        float tempHeight;
        float tempWidth;
        if (null != this.drawImage) {
            tempWidth = this.drawImage.getWidth();
            tempHeight = this.drawImage.getHeight();
        } else {
            tempWidth = this.emptyImage.getWidth();
            tempHeight = this.emptyImage.getHeight();
        }
        float rate = tempWidth > tempHeight ? tempHeight / (float)this.circleSize : tempWidth / (float)this.circleSize;
        return new Point((int)(tempWidth /= rate), (int)(tempHeight /= rate));
    }

    @Override
    protected void retouchDrawImage(Point point) {
        super.retouchDrawImage(point);
    }
}

