/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

public final class CvType {
    public static final int CV_8U = 0;
    public static final int CV_8S = 1;
    public static final int CV_16U = 2;
    public static final int CV_16S = 3;
    public static final int CV_32S = 4;
    public static final int CV_32F = 5;
    public static final int CV_64F = 6;
    public static final int CV_USRTYPE1 = 7;
    public static final int CV_8UC1 = CvType.CV_8UC(1);

    public static final int makeType(int n2, int n3) {
        if (n3 > 0 && n3 < 512) {
            if (n2 >= 0 && n2 < 8) {
                return (n2 & 7) + (n3 - 1 << 3);
            }
            throw new UnsupportedOperationException("Data type depth should be 0..7");
        }
        throw new UnsupportedOperationException("Channels count should be 1..511");
    }

    public static final int CV_8UC(int n2) {
        return CvType.makeType(0, n2);
    }

    public static final int CV_8SC(int n2) {
        return CvType.makeType(1, n2);
    }

    public static final int CV_32SC(int n2) {
        return CvType.makeType(4, n2);
    }

    public static final int CV_32FC(int n2) {
        return CvType.makeType(5, n2);
    }

    public static final int CV_64FC(int n2) {
        return CvType.makeType(6, n2);
    }

    public static final int channels(int n2) {
        return (n2 >> 3) + 1;
    }

    public static final int depth(int n2) {
        return n2 & 7;
    }

    public static final String typeToString(int n2) {
        String string2;
        switch (CvType.depth(n2)) {
            default: {
                throw new UnsupportedOperationException("Unsupported CvType value: " + n2);
            }
            case 7: {
                string2 = "CV_USRTYPE1";
                break;
            }
            case 6: {
                string2 = "CV_64F";
                break;
            }
            case 5: {
                string2 = "CV_32F";
                break;
            }
            case 4: {
                string2 = "CV_32S";
                break;
            }
            case 3: {
                string2 = "CV_16S";
                break;
            }
            case 2: {
                string2 = "CV_16U";
                break;
            }
            case 1: {
                string2 = "CV_8S";
                break;
            }
            case 0: {
                string2 = "CV_8U";
            }
        }
        n2 = CvType.channels(n2);
        if (n2 <= 4) {
            return string2 + "C" + n2;
        }
        return string2 + "C(" + n2 + ")";
    }
}

