package com.scansolutions.mrzscannerlib;

import android.app.Activity;
import android.content.Context;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;

import org.opencv.android.OpenCVLoader;

abstract class BaseCameraImpl implements SurfaceHolder.Callback {

    protected static final String TAG = BaseCameraImpl.class.getSimpleName();
    protected boolean hasSurface;
    protected Context mContext;
    MRZCore mrzCore;
    protected int mSensorOrientation;
    protected CameraInitListener cameraInitListener;
    protected ImageButton btnFlash;
    protected SurfaceView mSurfaceView;

    BaseCameraImpl(Context context,
                   MRZScannerListener scannerListener,
                   SurfaceView surfaceView,
                   ImageButton btnFlash,
                   CameraInitListener cameraInitListener,
                   MRZOverlay mrzOverlay,
                   ImageView debugPreview,
                   ScannerType scannerType) {
        OpenCVLoader.initDebug();
        mContext = context;
        mrzCore = new MRZCore(mrzOverlay, debugPreview, scannerListener, context, scannerType);
        mSurfaceView = surfaceView;
        this.btnFlash = btnFlash;
        this.cameraInitListener = cameraInitListener;
        hasSurface = false;

        this.btnFlash.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                switchFlash(!mrzCore.isTorchOn);
            }
        });
    }

    abstract void stopScanner();

    abstract void pauseScanner();

    abstract void release();

    abstract void resumeScanner();

    abstract void switchFlash(Boolean on);

    abstract void initCamera();

    void resume(boolean forceResume) {
        if (hasSurface || forceResume) {
            initCamera();
        } else {
            // Install the callback and wait for surfaceCreated() to resume the
            // camera.
            mSurfaceView.getHolder().addCallback(this);
        }

        switchFlash(mrzCore.isTorchOn);
    }

    @Override
    public void surfaceCreated(SurfaceHolder holder) {
        CameraLogger.addLog("surfaceCreated");

        hasSurface = true;
    }

    @Override
    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        CameraLogger.addLog("surfaceChanged " + width + " x " + height);

        if (!((Activity) mContext).isFinishing())
            initCamera();
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder holder) {
        CameraLogger.addLog("surfaceDestroyed");

        hasSurface = false;
    }

    void setScannerType(ScannerType scannerType) {
        if (mrzCore != null) {
            mrzCore.setScannerType(scannerType);
        }
    }

}
