package com.scansolutions.mrzscannerlib;

import android.graphics.Point;

class MRZPercentageRect {

    MRZPercentageRect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        validateSizes();
    }

    int x;
    int y;
    int width;
    int height;

    private void validateSizes() {
        x = Math.max(0, x);
        x = Math.min(100, x);
        y = Math.max(0, y);
        y = Math.min(100, y);
        width = Math.max(0, width);
        width = Math.min(100, width);
        height = Math.max(0, height);
        height = Math.min(100, height);
    }

    Point getTopCenter() {
        return new Point(x + width / 2, y);
    }
}
