/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

public final class CvType {
    public static final int CV_8U = 0;
    public static final int CV_8S = 1;
    public static final int CV_16U = 2;
    public static final int CV_16S = 3;
    public static final int CV_32S = 4;
    public static final int CV_32F = 5;
    public static final int CV_64F = 6;
    public static final int CV_USRTYPE1 = 7;
    public static final int CV_8UC1 = CvType.CV_8UC(1);

    public static final int makeType(int n, int n2) {
        if (n2 > 0 && n2 < 512) {
            if (n >= 0 && n < 8) {
                return (n & 7) + (n2 - 1 << 3);
            }
            throw new UnsupportedOperationException("Data type depth should be 0..7");
        }
        throw new UnsupportedOperationException("Channels count should be 1..511");
    }

    public static final int CV_8UC(int n) {
        return CvType.makeType(0, n);
    }

    public static final int CV_8SC(int n) {
        return CvType.makeType(1, n);
    }

    public static final int CV_32SC(int n) {
        return CvType.makeType(4, n);
    }

    public static final int CV_32FC(int n) {
        return CvType.makeType(5, n);
    }

    public static final int CV_64FC(int n) {
        return CvType.makeType(6, n);
    }

    public static final int channels(int n) {
        return (n >> 3) + 1;
    }

    public static final int depth(int n) {
        return n & 7;
    }

    public static final String typeToString(int n) {
        String string2;
        switch (CvType.depth(n)) {
            default: {
                throw new UnsupportedOperationException("Unsupported CvType value: " + n);
            }
            case 7: {
                string2 = "CV_USRTYPE1";
                break;
            }
            case 6: {
                string2 = "CV_64F";
                break;
            }
            case 5: {
                string2 = "CV_32F";
                break;
            }
            case 4: {
                string2 = "CV_32S";
                break;
            }
            case 3: {
                string2 = "CV_16S";
                break;
            }
            case 2: {
                string2 = "CV_16U";
                break;
            }
            case 1: {
                string2 = "CV_8S";
                break;
            }
            case 0: {
                string2 = "CV_8U";
            }
        }
        n = CvType.channels(n);
        if (n <= 4) {
            return string2 + "C" + n;
        }
        return string2 + "C(" + n + ")";
    }
}

