/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.graphics.Bitmap;
import com.scansolutions.mrzscannerlib.MRZScanner;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class MRZResultModel {
    public String rawResult;
    public String documentTypeRaw;
    public String documentTypeReadable;
    public String issuingCountry;
    public String[] surnames;
    public String[] givenNames;
    public String documentNumber;
    public String documentNumberWithCheckDigit;
    public String nationality;
    public String dobRaw;
    public String dobWithCheckDigit;
    public String dobReadable;
    public String sex;
    public String expirationDateRaw;
    public String expirationDateWithCheckDigit;
    public String expirationDateReadable;
    public String estIssuingDateRaw;
    public String estIssuingDateReadable;
    public String masterCheckDigit;
    public String[] optionals;
    public long dateScanned;
    public Bitmap portrait;
    public Bitmap signature;
    public Bitmap fullImage;

    public MRZResultModel() {
        this.rawResult = "N/A";
        this.documentTypeRaw = "N/A";
        this.documentTypeReadable = "N/A";
        this.issuingCountry = "N/A";
        this.documentNumber = "N/A";
        this.documentNumberWithCheckDigit = "N/A";
        this.nationality = "N/A";
        this.dobRaw = "N/A";
        this.dobWithCheckDigit = "N/A";
        this.dobReadable = "N/A";
        this.sex = "N/A";
        this.expirationDateRaw = "N/A";
        this.expirationDateWithCheckDigit = "N/A";
        this.expirationDateReadable = "N/A";
        this.estIssuingDateRaw = "N/A";
        this.estIssuingDateReadable = "N/A";
        this.masterCheckDigit = "N/A";
    }

    public MRZResultModel(String string, String string2, String[] stringArray, String[] stringArray2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String[] stringArray3, long l2, Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3) {
        MRZResultModel mRZResultModel = this;
        mRZResultModel.rawResult = "N/A";
        mRZResultModel.documentTypeRaw = "N/A";
        mRZResultModel.documentTypeReadable = "N/A";
        mRZResultModel.issuingCountry = "N/A";
        mRZResultModel.documentNumber = "N/A";
        mRZResultModel.documentNumberWithCheckDigit = "N/A";
        mRZResultModel.nationality = "N/A";
        mRZResultModel.dobRaw = "N/A";
        mRZResultModel.dobWithCheckDigit = "N/A";
        mRZResultModel.dobReadable = "N/A";
        mRZResultModel.sex = "N/A";
        mRZResultModel.expirationDateRaw = "N/A";
        mRZResultModel.expirationDateWithCheckDigit = "N/A";
        mRZResultModel.expirationDateReadable = "N/A";
        mRZResultModel.estIssuingDateRaw = "N/A";
        mRZResultModel.estIssuingDateReadable = "N/A";
        mRZResultModel.masterCheckDigit = "N/A";
        mRZResultModel.documentTypeRaw = string;
        mRZResultModel.issuingCountry = string2;
        mRZResultModel.surnames = stringArray;
        mRZResultModel.givenNames = stringArray2;
        mRZResultModel.documentNumber = string3;
        mRZResultModel.documentNumberWithCheckDigit = string4;
        mRZResultModel.nationality = string5;
        mRZResultModel.dobRaw = string6;
        mRZResultModel.dobWithCheckDigit = string7;
        mRZResultModel.sex = string8;
        mRZResultModel.expirationDateRaw = string10;
        mRZResultModel.estIssuingDateRaw = string9;
        mRZResultModel.expirationDateWithCheckDigit = string11;
        mRZResultModel.masterCheckDigit = string12;
        mRZResultModel.optionals = stringArray3;
        mRZResultModel.dateScanned = l2;
        mRZResultModel.portrait = bitmap;
        mRZResultModel.signature = bitmap2;
        mRZResultModel.fullImage = bitmap3;
        mRZResultModel.parseRawToReadable();
    }

    MRZResultModel(String string, long l2) {
        block27: {
            JSONObject jSONObject;
            block26: {
                int n;
                block25: {
                    JSONObject jSONObject2;
                    ((MRZResultModel)((Object)string2)).rawResult = "N/A";
                    ((MRZResultModel)((Object)string2)).documentTypeRaw = "N/A";
                    ((MRZResultModel)((Object)string2)).documentTypeReadable = "N/A";
                    ((MRZResultModel)((Object)string2)).issuingCountry = "N/A";
                    ((MRZResultModel)((Object)string2)).documentNumber = "N/A";
                    ((MRZResultModel)((Object)string2)).documentNumberWithCheckDigit = "N/A";
                    ((MRZResultModel)((Object)string2)).nationality = "N/A";
                    ((MRZResultModel)((Object)string2)).dobRaw = "N/A";
                    ((MRZResultModel)((Object)string2)).dobWithCheckDigit = "N/A";
                    ((MRZResultModel)((Object)string2)).dobReadable = "N/A";
                    ((MRZResultModel)((Object)string2)).sex = "N/A";
                    ((MRZResultModel)((Object)string2)).expirationDateRaw = "N/A";
                    ((MRZResultModel)((Object)string2)).expirationDateWithCheckDigit = "N/A";
                    ((MRZResultModel)((Object)string2)).expirationDateReadable = "N/A";
                    ((MRZResultModel)((Object)string2)).estIssuingDateRaw = "N/A";
                    ((MRZResultModel)((Object)string2)).estIssuingDateReadable = "N/A";
                    ((MRZResultModel)((Object)string2)).masterCheckDigit = "N/A";
                    ((MRZResultModel)((Object)string2)).dateScanned = l2;
                    jSONObject = jSONObject2;
                    JSONObject jSONObject3 = jSONObject;
                    jSONObject3(string);
                    ((MRZResultModel)((Object)string2)).rawResult = jSONObject3.getString("raw_result");
                    ((MRZResultModel)((Object)string2)).documentTypeRaw = jSONObject.getString("document_type_raw");
                    ((MRZResultModel)((Object)string2)).documentTypeReadable = jSONObject.getString("document_type_readable");
                    ((MRZResultModel)((Object)string2)).issuingCountry = jSONObject.getString("issuing_country");
                    ((MRZResultModel)((Object)string2)).documentNumber = jSONObject.getString("document_number");
                    ((MRZResultModel)((Object)string2)).documentNumberWithCheckDigit = jSONObject.getString("document_number_with_check_digit");
                    ((MRZResultModel)((Object)string2)).nationality = jSONObject.getString("nationality");
                    ((MRZResultModel)((Object)string2)).dobRaw = jSONObject.getString("dob_raw");
                    ((MRZResultModel)((Object)string2)).dobReadable = jSONObject.getString("dob_readable");
                    ((MRZResultModel)((Object)string2)).dobWithCheckDigit = jSONObject.getString("dob_with_check_digit");
                    ((MRZResultModel)((Object)string2)).sex = jSONObject.getString("sex");
                    ((MRZResultModel)((Object)string2)).expirationDateRaw = jSONObject.getString("expiration_date_raw");
                    ((MRZResultModel)((Object)string2)).expirationDateWithCheckDigit = jSONObject.getString("expiration_date_with_check_digit");
                    ((MRZResultModel)((Object)string2)).expirationDateReadable = jSONObject.getString("expiration_date_readable");
                    ((MRZResultModel)((Object)string2)).masterCheckDigit = jSONObject.getString("master_check_digit");
                    string = jSONObject2.getJSONArray("given_names");
                    if (string.length() <= 0) break block25;
                    ((MRZResultModel)((Object)string2)).givenNames = new String[string.length()];
                    n = 0;
                    while (true) {
                        if (n >= string.length()) break;
                        ((MRZResultModel)((Object)string2)).givenNames[n] = string.getString(n);
                        ++n;
                        continue;
                        break;
                    }
                }
                string = jSONObject.getJSONArray("surnames");
                if (string.length() <= 0) break block26;
                ((MRZResultModel)((Object)string2)).surnames = new String[string.length()];
                n = 0;
                while (true) {
                    if (n >= string.length()) break;
                    ((MRZResultModel)((Object)string2)).surnames[n] = string.getString(n);
                    ++n;
                    continue;
                    break;
                }
            }
            string = jSONObject.getJSONArray("optionals");
            if (string.length() <= 0) break block27;
            ((MRZResultModel)((Object)string2)).optionals = new String[string.length()];
            int n = 0;
            while (true) {
                if (n >= string.length()) break;
                ((MRZResultModel)((Object)string2)).optionals[n] = string.getString(n);
                ++n;
                continue;
                break;
            }
        }
        MRZResultModel mRZResultModel = string2;
        MRZResultModel mRZResultModel2 = mRZResultModel;
        MRZResultModel mRZResultModel3 = mRZResultModel;
        MRZResultModel mRZResultModel4 = mRZResultModel;
        MRZResultModel mRZResultModel5 = mRZResultModel;
        MRZResultModel mRZResultModel6 = mRZResultModel;
        MRZResultModel mRZResultModel7 = mRZResultModel;
        String string2 = mRZResultModel.documentTypeRaw;
        string = mRZResultModel5.issuingCountry;
        String string3 = mRZResultModel6.dobRaw;
        String string4 = mRZResultModel7.expirationDateRaw;
        try {
            mRZResultModel4.estIssuingDateRaw = mRZResultModel3.calculateEstIssuingDate(string2, string, string3, string4);
            mRZResultModel2.parseRawToReadable();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private String b(String string) {
        if (string != null && string.length() == 6) {
            int n;
            String string2;
            try {
                string2 = string;
                n = Calendar.getInstance().get(1) % 100;
            }
            catch (NumberFormatException numberFormatException) {
                return "Unknown";
            }
            int n2 = Integer.parseInt(string2.substring(0, 2));
            n = n2 > n ? n2 + 1900 : n2 + 2000;
            return this.a(string, n);
        }
        return "Unknown";
    }

    private String c(String string) {
        if (string != null && string.length() == 6) {
            int n;
            block5: {
                try {
                    n = Integer.parseInt(string.substring(0, 2));
                    if (n < 70) {
                        n += 2000;
                        break block5;
                    }
                    n += 1900;
                }
                catch (NumberFormatException numberFormatException) {
                    return "Unknown";
                }
            }
            return this.a(string, n);
        }
        return "Unknown";
    }

    private String a(String string, int n) {
        Calendar calendar = Calendar.getInstance();
        String string2 = string;
        int n2 = Integer.parseInt(string2.substring(2, 4)) - 1;
        calendar.set(n, n2, Integer.parseInt(string2.substring(4, 6)));
        return new SimpleDateFormat(MRZScanner.getDateFormat(), Locale.getDefault()).format(calendar.getTime());
    }

    private boolean a(String string) {
        return string != null && !string.isEmpty() && !string.equals("N/A");
    }

    static {
        System.loadLibrary("mrz-native-lib");
    }

    public native String parseReadableDocumentType(String var1);

    public native String calculateEstIssuingDate(String var1, String var2, String var3, String var4);

    public native String parseDate(String var1);

    public String getFullName() {
        return this.givenNamesReadable() + " " + this.surnamesReadable();
    }

    public void parseRawToReadable() {
        MRZResultModel mRZResultModel = this;
        mRZResultModel.documentTypeReadable = mRZResultModel.parseReadableDocumentType(mRZResultModel.documentTypeRaw);
        mRZResultModel.dobReadable = mRZResultModel.b(mRZResultModel.dobRaw);
        mRZResultModel.expirationDateReadable = mRZResultModel.c(mRZResultModel.expirationDateRaw);
        mRZResultModel.estIssuingDateReadable = mRZResultModel.c(mRZResultModel.estIssuingDateRaw);
    }

    public String givenNamesReadable() {
        StringBuilder stringBuilder;
        if (((MRZResultModel)((Object)stringBuilder2)).givenNames == null) {
            return "";
        }
        MRZResultModel mRZResultModel = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String[] stringArray = mRZResultModel.givenNames;
        int n = mRZResultModel.givenNames.length;
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuilder2.append(stringArray[i2]).append(" ");
        }
        return stringBuilder2.toString().trim();
    }

    public String surnamesReadable() {
        StringBuilder stringBuilder;
        if (((MRZResultModel)((Object)stringBuilder2)).surnames == null) {
            return "";
        }
        MRZResultModel mRZResultModel = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String[] stringArray = mRZResultModel.surnames;
        int n = mRZResultModel.surnames.length;
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuilder2.append(stringArray[i2]).append(" ");
        }
        return stringBuilder2.toString().trim();
    }

    public String optionalsReadable() {
        StringBuilder stringBuilder;
        MRZResultModel mRZResultModel = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String[] stringArray = mRZResultModel.optionals;
        if (mRZResultModel.optionals != null) {
            int n = stringArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                stringBuilder2.append(stringArray[i2]).append(" ");
            }
        }
        return stringBuilder2.toString().trim();
    }

    public String dob_check_digit() {
        MRZResultModel mRZResultModel = this;
        if (mRZResultModel.a(mRZResultModel.dobWithCheckDigit)) {
            String string = this.dobWithCheckDigit;
            return string.substring(string.length() - 1);
        }
        return null;
    }

    public String expiration_date_check_digit() {
        MRZResultModel mRZResultModel = this;
        if (mRZResultModel.a(mRZResultModel.expirationDateWithCheckDigit)) {
            String string = this.expirationDateWithCheckDigit;
            return string.substring(string.length() - 1);
        }
        return null;
    }

    public String document_number_check_digit() {
        MRZResultModel mRZResultModel = this;
        if (mRZResultModel.a(mRZResultModel.documentNumberWithCheckDigit)) {
            String string = this.documentNumberWithCheckDigit;
            return string.substring(string.length() - 1);
        }
        return null;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject2.put("document_type_raw", (Object)this.documentTypeRaw);
        jSONObject2.put("document_type_readable", (Object)this.documentTypeReadable);
        jSONObject2.put("issuing_country", (Object)this.issuingCountry);
        jSONObject2.put("surname", (Object)this.surnamesReadable());
        jSONObject2.put("document_number", (Object)this.documentNumber);
        jSONObject2.put("document_number_with_check_digit", (Object)this.documentNumberWithCheckDigit);
        jSONObject2.put("document_number_check_digit", (Object)this.document_number_check_digit());
        jSONObject2.put("nationality", (Object)this.nationality);
        jSONObject2.put("dob_raw", (Object)this.dobRaw);
        jSONObject2.put("dob_with_check_digit", (Object)this.dobWithCheckDigit);
        jSONObject2.put("dob_check_digit", (Object)this.dob_check_digit());
        jSONObject2.put("dob_readable", (Object)this.dobReadable);
        jSONObject2.put("sex", (Object)this.sex);
        jSONObject2.put("est_issuing_date_raw", (Object)this.estIssuingDateRaw);
        jSONObject2.put("est_issuing_date_readable", (Object)this.estIssuingDateReadable);
        jSONObject2.put("expiration_date_raw", (Object)this.expirationDateRaw);
        jSONObject2.put("expiration_date_with_check_digit", (Object)this.expirationDateWithCheckDigit);
        jSONObject2.put("expiration_date_check_digit", (Object)this.expiration_date_check_digit());
        jSONObject2.put("expiration_date_readable", (Object)this.expirationDateReadable);
        jSONObject2.put("master_check_digit", (Object)this.masterCheckDigit);
        jSONObject2.put("given_names_readable", (Object)this.givenNamesReadable());
        jSONObject.put("optionals", (Object)this.optionalsReadable());
        return jSONObject;
    }

    public boolean isExpired() {
        if (this.expirationDateRaw.length() == 6 && !this.expirationDateRaw.contains("*")) {
            int n = Integer.parseInt(this.expirationDateRaw.substring(0, 2));
            n = n < 70 ? (n += 2000) : (n += 1900);
            Calendar calendar = Calendar.getInstance();
            MRZResultModel mRZResultModel = this;
            int n2 = Integer.parseInt(mRZResultModel.expirationDateRaw.substring(2, 4)) - 1;
            calendar.set(n, n2, Integer.parseInt(mRZResultModel.expirationDateRaw.substring(4, 6)));
            return calendar.before(Calendar.getInstance());
        }
        return false;
    }

    public String toCSV() {
        return this.documentTypeRaw + "," + this.documentTypeReadable + "," + this.issuingCountry + "," + this.surnamesReadable() + "," + this.givenNamesReadable() + "," + this.documentNumber + "," + this.documentNumberWithCheckDigit + "," + this.document_number_check_digit() + "," + this.nationality + "," + this.dobRaw + "," + this.dobWithCheckDigit + "," + this.dob_check_digit() + "," + this.dobReadable + "," + this.sex + "," + this.estIssuingDateRaw + "," + this.estIssuingDateReadable + "," + this.expirationDateRaw + "," + this.expirationDateWithCheckDigit + "," + this.expiration_date_check_digit() + "," + this.expirationDateReadable + "," + this.masterCheckDigit + "," + this.optionalsReadable() + "," + this.dateScanned;
    }

    public String toReadableString() {
        return "Document number:  " + this.documentNumber + "\nFull name:  " + this.getFullName() + "\nNationality:  " + this.nationality + "\nIssuing country:  " + this.issuingCountry + "\nSex:  " + this.sex + "\nDate of birth:  " + this.dobReadable + "\nDate of birth (raw):  " + this.dobRaw + "\nExpiration date:  " + this.expirationDateReadable + "\nExpiration date (raw):  " + this.expirationDateRaw + "\nEstimated issuing date:  " + this.estIssuingDateReadable + "\nEstimated issuing date (raw):  " + this.estIssuingDateRaw + "\nOptional value:  " + this.optionalsReadable();
    }
}

