package com.scansolutions.mrzscannerlib;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

import static com.scansolutions.mrzscannerlib.MRZCore.decryptCommunication;
import static com.scansolutions.mrzscannerlib.MRZCore.encryptCommunication;
import static com.scansolutions.mrzscannerlib.MRZCore.getAndroidID;
import static com.scansolutions.mrzscannerlib.MRZCore.getLid;
import static com.scansolutions.mrzscannerlib.MRZCore.shouldCallBack;

class HttpsConnectionHelper {

    private static final String LICENCE_REPORTING_URL = "https://tracking.mrzscanner.com/";
    private static final String MRZ_CACHE_KEY = "MRZ_CACHE";

    static void reportRegistration(Context context, String bundleID, String licenceKey) {
        String lid = getLid(licenceKey);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        String cachedKey = sp.getString(MRZ_CACHE_KEY, "");
        if (shouldCallBack(cachedKey) <= 0 || lid == "-2")
            return;

        try {
            String urlString = LICENCE_REPORTING_URL;
            String paramsString = "lid=" + lid
                    + "&aid=" + bundleID
                    + "&did=" + getAndroidID(context)
                    + "&t=" + System.currentTimeMillis() / 1000
                    + "&sdkVer=" + MRZScanner.sdkVersion()
                    + "&devMan=" + Build.MANUFACTURER
                    + "&devMod=" + Build.MODEL
                    + "&platform=ANDROID"
                    + "&os=" + Build.VERSION.SDK;

            urlString += encryptCommunication(paramsString);

            URL url = new URL(urlString);
            HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(17 * 1000);
            conn.connect();

            if (conn.getResponseCode() == 200) {
                InputStream input = conn.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                String line;
                StringBuilder responseOutput = new StringBuilder();

                while ((line = reader.readLine()) != null) {
                    responseOutput.append(line);
                }

                String result = responseOutput.toString();
                String decrypted = decryptCommunication(result);

                if (decrypted.startsWith("MRZ001")) {
                    decrypted = decrypted.replace("dmask:", "");
                    decrypted = decrypted.replace("callback:", "");
                    decrypted = decrypted.replace("expires:", "");
                    decrypted = decrypted.replace("timestamp:", "");

                    sp.edit().putString(MRZ_CACHE_KEY, encryptCommunication(decrypted)).commit();

                    MRZCore.registerWithLicenseKey(context, licenceKey, bundleID, Build.MODEL, Build.MANUFACTURER);
                }
            }
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
