package com.scansolutions.mrzscannerlib;

import android.graphics.Bitmap;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.ScrollView;

public class ViewCreator {

    static ImageButton initGalleryButton(View v, View.OnClickListener clickListener) {
        if (v == null) return null;

        ImageButton btnGallery = new ImageButton(v.getContext());

        int galleryButtonSize = MRZUtils.convertDpToPixel(44, v.getContext());
        int marginSize = MRZUtils.convertDpToPixel(30, v.getContext());

        FrameLayout.LayoutParams lpGalleryButton = new FrameLayout.LayoutParams(galleryButtonSize, galleryButtonSize);
        lpGalleryButton.setMargins(marginSize, 0, 0, marginSize);
        lpGalleryButton.gravity = Gravity.BOTTOM | Gravity.LEFT;
        btnGallery.setLayoutParams(lpGalleryButton);

        btnGallery.setImageResource(R.drawable.mrz_ic_gallery);
        btnGallery.setBackgroundColor(android.R.color.transparent);
        btnGallery.setOnClickListener(clickListener);

        ((ViewGroup) v).addView(btnGallery);
        return btnGallery;
    }

    static void initCaptureButton(View v, View.OnClickListener clickListener) {
        Button btnCapture = new Button(v.getContext());

        int btnCaptureSize = MRZUtils.convertDpToPixel(56, v.getContext());
        FrameLayout.LayoutParams lpCapture = new FrameLayout.LayoutParams(btnCaptureSize, btnCaptureSize);
        lpCapture.gravity = Gravity.BOTTOM | Gravity.CENTER_HORIZONTAL;
        lpCapture.bottomMargin = MRZUtils.convertDpToPixel(18, v.getContext());
        btnCapture.setLayoutParams(lpCapture);

        btnCapture.setBackgroundResource(R.drawable.mrz_circle_btn_bg);

        btnCapture.setOnClickListener(clickListener);
        btnCapture.setId(R.id.capture_button_id);
        ((ViewGroup) v).addView(btnCapture);
    }

    static ImageView initCustomImageView(View v, RelativeLayout rlScrollContent, Bitmap customImage, int customImageResId) {
        ImageView customImageView = new ImageView(v.getContext());

        RelativeLayout.LayoutParams lpCustomImageParams = new RelativeLayout.LayoutParams(v.getWidth(), v.getHeight());
        lpCustomImageParams.addRule(RelativeLayout.CENTER_IN_PARENT, RelativeLayout.TRUE);
        customImageView.setLayoutParams(lpCustomImageParams);

        customImageView.setBackgroundColor(android.R.color.transparent);

        if (customImage != null) {
            customImageView.setImageBitmap(customImage);
        } else if (customImageResId != -1) {
            customImageView.setImageResource(customImageResId);
        }

        rlScrollContent.addView(customImageView);
        return customImageView;
    }

    static ScrollView initScrollView(View v) {
        final ScrollView scrollView = v.findViewById(R.id.mrz_scroll_view);
        scrollView.setVerticalScrollBarEnabled(false);
        scrollView.setOnTouchListener(new View.OnTouchListener() {

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        return scrollView;
    }

}
