/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.graphics.Bitmap;
import com.scansolutions.mrzscannerlib.MRZScanner;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MRZResultModel {
    public String document_type_raw = "N/A";
    public String document_type_readable = "N/A";
    public String issuing_country = "N/A";
    public String[] surnames;
    public String[] given_names;
    public String document_number = "N/A";
    public String nationality = "N/A";
    public String dob_raw = "N/A";
    public String dob_readable = "N/A";
    public String sex = "N/A";
    public String expiration_date_raw = "N/A";
    public String expiration_date_readable = "N/A";
    public String est_issuing_date_raw = "N/A";
    public String est_issuing_date_readable = "N/A";
    public String[] optionals;
    public long dateScanned;
    public Bitmap portrait;
    public Bitmap signature;

    public MRZResultModel() {
    }

    public native String parseReadableDocumentType(String var1);

    public native String calculateEstIssuingDate(String var1, String var2, String var3, String var4);

    public native String parseDate(String var1);

    public MRZResultModel(String document_type_raw, String issuing_country, String[] surnames, String[] given_names, String document_number, String nationality, String dob_raw, String sex, String est_issuing_date_raw, String expiration_date_raw, String[] optionals, long dateScanned, Bitmap portrait, Bitmap signature) {
        this.document_type_raw = document_type_raw;
        this.issuing_country = issuing_country;
        this.surnames = surnames;
        this.given_names = given_names;
        this.document_number = document_number;
        this.nationality = nationality;
        this.dob_raw = dob_raw;
        this.sex = sex;
        this.expiration_date_raw = expiration_date_raw;
        this.est_issuing_date_raw = est_issuing_date_raw;
        this.optionals = optionals;
        this.dateScanned = dateScanned;
        this.portrait = portrait;
        this.signature = signature;
        this.parseRawToReadable();
    }

    MRZResultModel(String jsonText, long dateScanned) {
        this.dateScanned = dateScanned;
        try {
            JSONArray optionalsArr;
            JSONArray surnamesArr;
            JSONObject jsonResult = new JSONObject(jsonText);
            this.document_type_raw = jsonResult.getString("document_type_raw");
            this.document_type_readable = jsonResult.getString("document_type_readable");
            this.issuing_country = jsonResult.getString("issuing_country");
            this.document_number = jsonResult.getString("document_number");
            this.nationality = jsonResult.getString("nationality");
            this.dob_raw = jsonResult.getString("dob_raw");
            this.dob_readable = jsonResult.getString("dob_readable");
            this.sex = jsonResult.getString("sex");
            this.expiration_date_raw = jsonResult.getString("expiration_date_raw");
            this.expiration_date_readable = jsonResult.getString("expiration_date_readable");
            JSONArray givenNamesArr = jsonResult.getJSONArray("given_names");
            if (givenNamesArr.length() > 0) {
                this.given_names = new String[givenNamesArr.length()];
                for (int i = 0; i < givenNamesArr.length(); ++i) {
                    this.given_names[i] = givenNamesArr.getString(i);
                }
            }
            if ((surnamesArr = jsonResult.getJSONArray("surnames")).length() > 0) {
                this.surnames = new String[surnamesArr.length()];
                for (int i = 0; i < surnamesArr.length(); ++i) {
                    this.surnames[i] = surnamesArr.getString(i);
                }
            }
            if ((optionalsArr = jsonResult.getJSONArray("optionals")).length() > 0) {
                this.optionals = new String[optionalsArr.length()];
                for (int i = 0; i < optionalsArr.length(); ++i) {
                    this.optionals[i] = optionalsArr.getString(i);
                }
            }
            this.est_issuing_date_raw = this.calculateEstIssuingDate(this.document_type_raw, this.issuing_country, this.dob_raw, this.expiration_date_raw);
            this.parseRawToReadable();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getFullName() {
        return this.givenNamesReadable() + " " + this.surnamesReadable();
    }

    protected void parseRawToReadable() {
        this.document_type_readable = this.parseReadableDocumentType(this.document_type_raw);
        this.dob_readable = this.parseDOBToReadable(this.dob_raw);
        this.expiration_date_readable = this.parseExpirationDateToReadable(this.expiration_date_raw);
        this.est_issuing_date_readable = this.parseExpirationDateToReadable(this.est_issuing_date_raw);
    }

    private String parseDOBToReadable(String dateRaw) {
        if (dateRaw == null || dateRaw.length() != 6) {
            return "Unknown";
        }
        try {
            Calendar calendar = Calendar.getInstance();
            int currentYear = calendar.get(1);
            int dobYear = Integer.valueOf(dateRaw.substring(0, 2));
            dobYear = dobYear > (currentYear %= 100) ? dobYear + 1900 : dobYear + 2000;
            return this.parseDateToReadable(dateRaw, dobYear);
        }
        catch (NumberFormatException numberFormatException) {
            return "Unknown";
        }
    }

    private String parseExpirationDateToReadable(String dateRaw) {
        if (dateRaw == null || dateRaw.length() != 6) {
            return "Unknown";
        }
        try {
            int expYear = Integer.valueOf(dateRaw.substring(0, 2));
            expYear = expYear < 70 ? expYear + 2000 : expYear + 1900;
            return this.parseDateToReadable(dateRaw, expYear);
        }
        catch (NumberFormatException numberFormatException) {
            return "Unknown";
        }
    }

    private String parseDateToReadable(String dateRaw, int year) throws NumberFormatException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, Integer.valueOf(dateRaw.substring(2, 4)) - 1, Integer.valueOf(dateRaw.substring(4, 6)));
        SimpleDateFormat sdf = new SimpleDateFormat(MRZScanner.getDateFormat(), Locale.getDefault());
        return sdf.format(calendar.getTime());
    }

    public String givenNamesReadable() {
        if (this.given_names == null) {
            return "";
        }
        StringBuilder fullName = new StringBuilder();
        for (String s : this.given_names) {
            fullName.append(s).append(" ");
        }
        return fullName.toString().trim();
    }

    public String surnamesReadable() {
        if (this.surnames == null) {
            return "";
        }
        StringBuilder fullName = new StringBuilder();
        for (String s : this.surnames) {
            fullName.append(s).append(" ");
        }
        return fullName.toString().trim();
    }

    public String optionalsReadable() {
        StringBuilder optionalsReadable = new StringBuilder();
        if (this.optionals != null) {
            for (String s : this.optionals) {
                optionalsReadable.append(s).append(" ");
            }
        }
        return optionalsReadable.toString().trim();
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("document_type_raw", (Object)this.document_type_raw);
        jsonObject.put("document_type_readable", (Object)this.document_type_readable);
        jsonObject.put("issuing_country", (Object)this.issuing_country);
        jsonObject.put("surname", (Object)this.surnamesReadable());
        jsonObject.put("document_number", (Object)this.document_number);
        jsonObject.put("nationality", (Object)this.nationality);
        jsonObject.put("dob_raw", (Object)this.dob_raw);
        jsonObject.put("dob_readable", (Object)this.dob_readable);
        jsonObject.put("sex", (Object)this.sex);
        jsonObject.put("est_issuing_date_raw", (Object)this.est_issuing_date_raw);
        jsonObject.put("est_issuing_date_readable", (Object)this.est_issuing_date_readable);
        jsonObject.put("expiration_date_raw", (Object)this.expiration_date_raw);
        jsonObject.put("expiration_date_readable", (Object)this.expiration_date_readable);
        jsonObject.put("given_names_readable", (Object)this.givenNamesReadable());
        jsonObject.put("optionals", (Object)this.optionalsReadable());
        return jsonObject;
    }

    public String toCSV() {
        return this.document_type_raw + "," + this.document_type_readable + "," + this.issuing_country + "," + this.surnamesReadable() + "," + this.givenNamesReadable() + "," + this.document_number + "," + this.nationality + "," + this.dob_raw + "," + this.dob_readable + "," + this.sex + "," + this.est_issuing_date_raw + "," + this.est_issuing_date_readable + "," + this.expiration_date_raw + "," + this.expiration_date_readable + "," + this.optionalsReadable() + "," + this.dateScanned;
    }

    static {
        System.loadLibrary("native-lib");
    }
}

