/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ImageFormat;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.media.Image;
import android.support.v4.content.ContextCompat;
import java.nio.ByteBuffer;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

class ImageUtils {
    ImageUtils() {
    }

    static Mat imageToMat(Image image) {
        if (image == null) {
            return new Mat(0, 0, 0);
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int offset = 0;
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[image.getWidth() * image.getHeight() * ImageFormat.getBitsPerPixel((int)35) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        for (int i = 0; i < planes.length; ++i) {
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int w = i == 0 ? width : width / 2;
            int h = i == 0 ? height : height / 2;
            for (int row = 0; row < h; ++row) {
                int bytesPerPixel = ImageFormat.getBitsPerPixel((int)35) / 8;
                if (pixelStride == bytesPerPixel) {
                    int length = w * bytesPerPixel;
                    buffer.get(data, offset, length);
                    if (h - row != 1) {
                        buffer.position(buffer.position() + rowStride - length);
                    }
                    offset += length;
                    continue;
                }
                if (h - row == 1) {
                    buffer.get(rowData, 0, width - pixelStride + 1);
                } else {
                    buffer.get(rowData, 0, rowStride);
                }
                for (int col = 0; col < w; ++col) {
                    data[offset++] = rowData[col * pixelStride];
                }
            }
        }
        Mat mat = new Mat(height + height / 2, width, CvType.CV_8UC1);
        mat.put(0, 0, data);
        Mat mat_out_rgb = new Mat();
        Imgproc.cvtColor(mat, mat_out_rgb, 104);
        return mat_out_rgb;
    }

    private static Bitmap getBitmap(VectorDrawable vectorDrawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    static Bitmap getBitmap(Context context, int drawableId) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableId);
        if (drawable2 instanceof BitmapDrawable) {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawableId);
        }
        if (drawable2 instanceof VectorDrawable) {
            return ImageUtils.getBitmap((VectorDrawable)drawable2);
        }
        throw new IllegalArgumentException("unsupported drawable type");
    }
}

