/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import com.scansolutions.mrzscannerlib.AutoFocusManager;
import com.scansolutions.mrzscannerlib.CameraConfigurationManager;
import com.scansolutions.mrzscannerlib.PreviewCallback;
import com.scansolutions.mrzscannerlib.open.OpenCamera;
import com.scansolutions.mrzscannerlib.open.OpenCameraInterface;
import java.io.IOException;
import java.util.List;

final class CameraManager {
    private static final String TAG = CameraManager.class.getSimpleName();
    private final CameraConfigurationManager configManager;
    private OpenCamera camera;
    private AutoFocusManager autoFocusManager;
    private boolean initialized;
    private boolean previewing;
    private int requestedCameraId = -1;
    private final PreviewCallback previewCallback;

    CameraManager(Context context) {
        this.configManager = new CameraConfigurationManager(context);
        this.previewCallback = new PreviewCallback(this.configManager);
    }

    void openDriver(SurfaceHolder holder) throws IOException {
        Camera cameraObject;
        block7: {
            Camera.Parameters parameters;
            OpenCamera theCamera = this.camera;
            if (theCamera == null) {
                theCamera = OpenCameraInterface.open(this.requestedCameraId);
                if (theCamera == null) {
                    throw new IOException("Camera.open() failed to return object from driver");
                }
                this.camera = theCamera;
            }
            if (!this.initialized) {
                this.initialized = true;
                this.configManager.initFromCameraParameters(theCamera);
            }
            String parametersFlattened = (parameters = (cameraObject = theCamera.getCamera()).getParameters()) == null ? null : parameters.flatten();
            try {
                this.configManager.setDesiredCameraParameters(theCamera, false);
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Camera rejected parameters. Setting only minimal safe-mode parameters");
                Log.i((String)TAG, (String)("Resetting to saved camera params: " + parametersFlattened));
                if (parametersFlattened == null) break block7;
                parameters = cameraObject.getParameters();
                parameters.unflatten(parametersFlattened);
                try {
                    cameraObject.setParameters(parameters);
                    this.configManager.setDesiredCameraParameters(theCamera, true);
                }
                catch (RuntimeException re2) {
                    Log.w((String)TAG, (String)"Camera rejected even safe-mode parameters! No configuration");
                }
            }
        }
        cameraObject.setPreviewDisplay(holder);
    }

    public boolean isOpen() {
        return this.camera != null;
    }

    public void closeDriver() {
        if (this.camera != null) {
            this.camera.getCamera().release();
            this.camera = null;
        }
    }

    public void startPreview() {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && !this.previewing) {
            theCamera.getCamera().startPreview();
            this.previewing = true;
            this.autoFocusManager = new AutoFocusManager(theCamera.getCamera());
        }
    }

    public void stopPreview() {
        if (this.autoFocusManager != null) {
            this.autoFocusManager.stop();
            this.autoFocusManager = null;
        }
        if (this.camera != null && this.previewing) {
            this.camera.getCamera().setPreviewCallbackWithBuffer(null);
            this.camera.getCamera().setPreviewCallback(null);
            this.camera.getCamera().stopPreview();
            this.previewCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public void setTorch(boolean newSetting) {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && newSetting != this.configManager.getTorchState(theCamera.getCamera())) {
            boolean wasAutoFocusManager;
            boolean bl = wasAutoFocusManager = this.autoFocusManager != null;
            if (wasAutoFocusManager) {
                this.autoFocusManager.stop();
                this.autoFocusManager = null;
            }
            this.configManager.setTorch(theCamera.getCamera(), newSetting);
            if (wasAutoFocusManager) {
                this.autoFocusManager = new AutoFocusManager(theCamera.getCamera());
                this.autoFocusManager.start();
            }
        }
    }

    public void requestPreviewFrame(Handler handler, int message) {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && this.previewing) {
            this.previewCallback.setHandler(handler, message);
            theCamera.getCamera().setPreviewCallback((Camera.PreviewCallback)this.previewCallback);
        }
    }

    public void setManualCameraId(int cameraId) {
        this.requestedCameraId = cameraId;
    }

    boolean doesCameraMeetMinimum() {
        Camera.Parameters parameters = this.camera.getCamera().getParameters();
        List supportedFocusModes = parameters.getSupportedFocusModes();
        boolean hasAutoFocus = supportedFocusModes != null && supportedFocusModes.contains("auto");
        List sizes = parameters.getSupportedPictureSizes();
        boolean isResSupported = false;
        for (Camera.Size size : sizes) {
            if (size.height * size.height <= 4500000) continue;
            isResSupported = true;
            break;
        }
        return hasAutoFocus && isResSupported;
    }
}

