/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.scansolutions.mrzscannerlib.Camera2Impl;
import com.scansolutions.mrzscannerlib.CameraManager;
import com.scansolutions.mrzscannerlib.MRZCore;
import com.scansolutions.mrzscannerlib.MRZOverlay;
import com.scansolutions.mrzscannerlib.MRZScanner;
import com.scansolutions.mrzscannerlib.MRZScannerListener;
import com.scansolutions.mrzscannerlib.R;
import java.io.IOException;
import org.opencv.android.Utils;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

class Camera1Impl
implements SurfaceHolder.Callback {
    private boolean hasSurface;
    private CameraManager cameraManager;
    private Handler handler;
    private SurfaceHolder surfaceHolder;
    private MRZCore mrzCore;
    private Context mContext;
    private int mSensorRotation;
    private Camera2Impl.CameraInitListener cameraInitListener;

    Camera1Impl(Context context, SurfaceView surfaceView, ImageButton btnFlash, MRZOverlay mrzOverlay, ImageView debugPreview, MRZScannerListener scannerListener, Camera2Impl.CameraInitListener cameraInitListener) {
        this.cameraInitListener = cameraInitListener;
        this.mContext = context;
        this.mrzCore = new MRZCore(mrzOverlay, debugPreview, scannerListener);
        this.surfaceHolder = surfaceView.getHolder();
        this.hasSurface = false;
        this.cameraManager = new CameraManager(context);
        this.handler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (msg.what == R.id.decode) {
                    Camera1Impl.this.decode((byte[])msg.obj, msg.arg1, msg.arg2);
                }
                return false;
            }
        });
        btnFlash.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((Camera1Impl)Camera1Impl.this).mrzCore.isTorchOn = !((Camera1Impl)Camera1Impl.this).mrzCore.isTorchOn;
                Camera1Impl.this.cameraManager.setTorch(((Camera1Impl)Camera1Impl.this).mrzCore.isTorchOn);
                if (((Camera1Impl)Camera1Impl.this).mrzCore.isTorchOn) {
                    ((ImageButton)v).setImageResource(R.drawable.amrz_ic_flash_on);
                } else {
                    ((ImageButton)v).setImageResource(R.drawable.amrz_ic_ico_flash_off);
                }
            }
        });
    }

    void resume() {
        if (this.hasSurface) {
            this.initCamera();
        } else {
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            this.surfaceHolder.setType(3);
        }
        if (!this.mrzCore.isTorchOn) {
            this.cameraManager.setTorch(false);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.initCamera();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    private void initCamera() {
        if (!MRZScanner.hasPermissions(this.mContext, "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA")) {
            this.cameraInitListener.shouldRequestCameraPermission();
            return;
        }
        try {
            this.cameraManager.openDriver(this.surfaceHolder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
        this.mSensorRotation = cameraInfo.orientation;
        this.cameraManager.startPreview();
        this.restartPreviewAndDecode();
        if (!this.cameraManager.doesCameraMeetMinimum()) {
            this.cameraInitListener.warnIncompatibleCamera();
        }
    }

    void stopScanner() {
        MRZCore.scanningState = 1;
        this.cameraManager.stopPreview();
        this.cameraManager.closeDriver();
    }

    private void restartPreviewAndDecode() {
        if (MRZCore.scanningState == 1) {
            MRZCore.scanningState = 0;
            this.cameraManager.requestPreviewFrame(this.handler, R.id.decode);
        }
    }

    private void decode(final byte[] data, final int width, final int height) {
        if (MRZCore.activeThreads >= MRZCore.maxThreads || MRZCore.scanningState == 1) {
            return;
        }
        ++MRZCore.activeThreads;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Mat mYuv = new Mat(height + height / 2, width, CvType.CV_8UC1);
                mYuv.put(0, 0, data);
                Mat mRgba = new Mat();
                Imgproc.cvtColor(mYuv, mRgba, 95, 4);
                Bitmap bitmap = Bitmap.createBitmap((int)mRgba.cols(), (int)mRgba.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Utils.matToBitmap(mRgba, bitmap);
                mRgba = Camera1Impl.this.mrzCore.rotateMat(mRgba, Camera1Impl.this.mContext, Camera1Impl.this.mSensorRotation);
                Camera1Impl.this.mrzCore.scan(mRgba);
                --MRZCore.activeThreads;
            }
        }).start();
    }
}

