/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.support.annotation.IntRange;
import com.googlecode.leptonica.android.Pix;

public class Rotate {
    public static final boolean ROTATE_QUALITY = true;

    public static Pix rotate(Pix pixs, float degrees) {
        return Rotate.rotate(pixs, degrees, false);
    }

    public static Pix rotate(Pix pixs, float degrees, boolean quality) {
        return Rotate.rotate(pixs, degrees, quality, true);
    }

    public static Pix rotate(Pix pixs, float degrees, boolean quality, boolean resize) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        long nativePix = Rotate.nativeRotate(pixs.getNativePix(), degrees, quality, resize);
        if (nativePix == 0L) {
            return null;
        }
        return new Pix(nativePix);
    }

    public static Pix rotateOrth(Pix pixs, @IntRange(from=0L, to=3L) int quads) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (quads < 0 || quads > 3) {
            throw new IllegalArgumentException("quads not in {0,1,2,3}");
        }
        long nativePix = Rotate.nativeRotateOrth(pixs.getNativePix(), quads);
        if (nativePix == 0L) {
            return null;
        }
        return new Pix(nativePix);
    }

    private static native long nativeRotateOrth(long var0, int var2);

    private static native long nativeRotate(long var0, float var2, boolean var3, boolean var4);

    static {
        System.loadLibrary("jpgt");
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
    }
}

