/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.extensions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.WindowManager;
import androidx.annotation.DrawableRes;
import com.scandit.datacapture.core.internal.sdk.extensions.DrawableExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0013\u001a\u00020\u0014*\u00020\u00022\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0000\u001a\u0014\u0010\u0016\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0018H\u0000\u001a\u0016\u0010\u001c\u001a\u00020\u001d*\u00020\u00022\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001b\u0010\r\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\f\"\u0015\u0010\u0011\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001e"}, d2={"displayDensity", "", "Landroid/content/Context;", "getDisplayDensity", "(Landroid/content/Context;)F", "isDeviceAtLeastLarge", "", "(Landroid/content/Context;)Z", "isDeviceSmall", "orientation", "", "getOrientation", "(Landroid/content/Context;)I", "rotation", "getRotation$annotations", "(Landroid/content/Context;)V", "getRotation", "screenLayout", "getScreenLayout", "getBitmap", "Landroid/graphics/Bitmap;", "resourceId", "getResourceByName", "resName", "", "openAssetFd", "Landroid/content/res/AssetFileDescriptor;", "assetName", "requireDrawable", "Landroid/graphics/drawable/Drawable;", "scandit-capture-core"})
public final class ContextExtensionsKt {
    public static final float getDisplayDensity(@NotNull Context $this$displayDensity) {
        Context context = $this$displayDensity;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        return context.getResources().getDisplayMetrics().density;
    }

    public static final int getRotation(@NotNull Context $this$rotation) {
        Context context = $this$rotation;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        return ((WindowManager)object).getDefaultDisplay().getRotation();
    }

    public static /* synthetic */ void getRotation$annotations(Context context) {
    }

    public static final int getOrientation(@NotNull Context $this$orientation) {
        Context context = $this$orientation;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        return context.getResources().getConfiguration().orientation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AssetFileDescriptor openAssetFd(@NotNull Context $this$openAssetFd, @NotNull String assetName) {
        void var1_1;
        Context context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"assetName");
        AssetFileDescriptor assetFileDescriptor = $this$openAssetFd.getAssets().openFd((String)var1_1);
        Intrinsics.checkNotNullExpressionValue((Object)assetFileDescriptor, (String)"openFd(...)");
        return assetFileDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"DiscouragedApi"})
    public static final int getResourceByName(@NotNull Context $this$getResourceByName, @NotNull String resName) {
        void var1_1;
        Context context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"resName");
        return $this$getResourceByName.getResources().getIdentifier((String)var1_1, "raw", context.getPackageName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Drawable requireDrawable(@NotNull Context $this$requireDrawable, @DrawableRes int resourceId) {
        void var1_1;
        Context context = $this$requireDrawable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        Context context2 = context.getDrawable((int)var1_1);
        if (context2 != null) {
            return context2;
        }
        throw new IllegalStateException(("Cannot retrieve drawable for resource " + (int)var1_1).toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Bitmap getBitmap(@NotNull Context $this$getBitmap, @DrawableRes int resourceId) {
        void var1_1;
        Context context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        return DrawableExtensionsKt.toBitmap(ContextExtensionsKt.requireDrawable($this$getBitmap, (int)var1_1));
    }

    public static final int getScreenLayout(@NotNull Context $this$screenLayout) {
        Context context = $this$screenLayout;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        return context.getResources().getConfiguration().screenLayout;
    }

    public static final boolean isDeviceAtLeastLarge(@NotNull Context $this$isDeviceAtLeastLarge) {
        Context context = $this$isDeviceAtLeastLarge;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        int n2 = ContextExtensionsKt.getScreenLayout(context) & 0xF;
        return n2 == 3 || n2 == 4;
    }

    public static final boolean isDeviceSmall(@NotNull Context $this$isDeviceSmall) {
        Context context = $this$isDeviceSmall;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        return (ContextExtensionsKt.getScreenLayout(context) & 0xF) == 1;
    }
}

