/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.module.ui.hint;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.Typeface;
import android.graphics.drawable.Animatable2;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scandit.datacapture.core.R;
import com.scandit.datacapture.core.common.geometry.MarginsF;
import com.scandit.datacapture.core.common.geometry.Rect;
import com.scandit.datacapture.core.internal.module.ui.NativeHintAlignment;
import com.scandit.datacapture.core.internal.module.ui.NativeHintAnchor;
import com.scandit.datacapture.core.internal.module.ui.NativeHintIcon;
import com.scandit.datacapture.core.internal.module.ui.NativeHintStyle;
import com.scandit.datacapture.core.internal.module.ui.hint.A;
import com.scandit.datacapture.core.internal.module.ui.hint.B;
import com.scandit.datacapture.core.internal.module.ui.hint.C;
import com.scandit.datacapture.core.internal.sdk.common.graphics.NativeColor;
import com.scandit.datacapture.core.internal.sdk.extensions.PointFExtensionKt;
import com.scandit.datacapture.core.internal.sdk.ui.hint.GuidanceHint;
import com.scandit.datacapture.core.internal.sdk.ui.hint.HintHolderV2Impl;
import com.scandit.datacapture.core.internal.sdk.utils.PixelExtensionsKt;
import com.scandit.datacapture.core.ui.icon.ScanditIcon;
import com.scandit.datacapture.core.ui.icon.ScanditIconDeserializer;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;

public final class HintView
extends RelativeLayout {
    private final TextView a;
    private final ImageView b;
    private Function0 c;
    private boolean d;
    private final PointF e;
    private final PointF f;
    private boolean g;
    private final float h;

    public final void a(Function0 function0) {
        this.c = function0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        Intrinsics.checkNotNullParameter((Object)motionEvent2, (String)"event");
        switch (motionEvent2.getAction()) {
            default: {
                return super.onTouchEvent(motionEvent);
            }
            case 2: {
                if (!this.g) return super.onTouchEvent(motionEvent);
                this.f.x = motionEvent.getRawX();
                this.f.y = motionEvent.getRawY();
                this.setAlpha(1.0f - RangesKt.coerceIn((float)(PointFExtensionKt.distance(this.f, this.e) / this.h), (float)0.0f, (float)1.0f));
                return true;
            }
            case 1: 
            case 3: {
                if (!this.g) return super.onTouchEvent(motionEvent);
                this.g = false;
                this.f.x = motionEvent.getRawX();
                this.f.y = motionEvent.getRawY();
                if (RangesKt.coerceIn((float)(PointFExtensionKt.distance(this.f, this.e) / this.h), (float)0.0f, (float)1.0f) > 0.5f) {
                    this.a();
                    return true;
                } else {
                    this.animate().alpha(1.0f).setDuration(200L).start();
                }
                return true;
            }
            case 0: 
        }
        if (!this.d) {
            return false;
        }
        this.e.x = motionEvent.getRawX();
        this.e.y = motionEvent.getRawY();
        this.g = true;
        return true;
    }

    public final void a(String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"text");
        this.a.setText((CharSequence)string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void c(NativeHintStyle nativeHintStyle, Rect rect, boolean bl) {
        void var3_48;
        void var3_39;
        void var3_33;
        void var3_24;
        RelativeLayout.LayoutParams layoutParams;
        Intrinsics.checkNotNullParameter((Object)nativeHintStyle, (String)"hintStyle");
        int n2 = -2;
        int n3 = nativeHintStyle.getFitToText() ? -2 : -1;
        ViewParent viewParent = this.getParent();
        Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        int n4 = Math.min(((View)viewParent).getWidth(), Math.min(displayMetrics.heightPixels, displayMetrics.widthPixels));
        ViewParent viewParent2 = this.getParent();
        Intrinsics.checkNotNull((Object)viewParent2, (String)"null cannot be cast to non-null type android.view.View");
        int n5 = MathKt.roundToInt((float)(PixelExtensionsKt.pxFromDp$default(nativeHintStyle.getHorizontalMargin(), null, 1, null) + ((float)((View)viewParent2).getWidth() - nativeHintStyle.getMaxWidthFraction() * (float)n4) / 2.0f));
        RelativeLayout.LayoutParams layoutParams2 = layoutParams;
        new RelativeLayout.LayoutParams(n3, n2).addRule(14);
        this.a(layoutParams2, nativeHintStyle, rect, (boolean)var3_24, n5);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        MarginsF marginsF = nativeHintStyle.getPadding();
        Intrinsics.checkNotNullExpressionValue((Object)marginsF, (String)"getPadding(...)");
        int n6 = MathKt.roundToInt((float)PixelExtensionsKt.pxFromDp$default(marginsF.getLeft(), null, 1, null));
        int n7 = MathKt.roundToInt((float)PixelExtensionsKt.pxFromDp$default(marginsF.getTop(), null, 1, null));
        n2 = MathKt.roundToInt((float)PixelExtensionsKt.pxFromDp$default(marginsF.getRight(), null, 1, null));
        n3 = MathKt.roundToInt((float)PixelExtensionsKt.pxFromDp$default(marginsF.getBottom(), null, 1, null));
        this.setPadding(n6, n7, n2, n3);
        TextView textView = this.a;
        textView.setTextSize(2, nativeHintStyle.getTextSize());
        NativeColor nativeColor = nativeHintStyle.getTextColor();
        Intrinsics.checkNotNullExpressionValue((Object)nativeColor, (String)"getTextColor(...)");
        NativeColor nativeColor2 = nativeColor;
        int n8 = (int)(nativeColor2.getG() * 255.0f + 0.5f);
        textView.setTextColor(Color.argb((int)((int)(nativeColor.getA() * 255.0f + 0.5f)), (int)((int)(nativeColor.getR() * 255.0f + 0.5f)), (int)n8, (int)((int)(nativeColor2.getB() * 255.0f + 0.5f))));
        NativeHintAlignment nativeHintAlignment = nativeHintStyle.getTextAlignment();
        Intrinsics.checkNotNull((Object)((Object)nativeHintAlignment));
        int n9 = A.a[nativeHintAlignment.ordinal()];
        if (n9 != 1) {
            if (n9 != 2) {
                if (n9 != 3) throw new NoWhenBranchMatchedException();
                int n10 = 8388629;
            } else {
                int n11 = 17;
            }
        } else {
            int n12 = 8388627;
        }
        TextView textView2 = textView;
        textView2.setGravity((int)var3_33);
        textView2.setMaxLines(nativeHintStyle.getMaxLines());
        float f2 = nativeHintStyle.getLineHeight() >= 0.0f ? nativeHintStyle.getLineHeight() : nativeHintStyle.getTextSize();
        textView.setLineSpacing(PixelExtensionsKt.pxFromSp$default(f2 - nativeHintStyle.getTextSize(), null, 1, null), 1.0f);
        int n13 = nativeHintStyle.getTextWeight();
        if (Build.VERSION.SDK_INT >= 28) {
            Typeface typeface = Typeface.create(null, (int)n13, (boolean)false);
        } else if (n13 >= 600) {
            Typeface typeface = Typeface.DEFAULT_BOLD;
        } else {
            Typeface typeface = Typeface.DEFAULT;
        }
        textView.setTypeface((Typeface)var3_39);
        float f3 = nativeHintStyle.getCornerRadius();
        NativeColor nativeColor3 = nativeHintStyle.getBackgroundColor();
        Intrinsics.checkNotNullExpressionValue((Object)nativeColor3, (String)"getBackgroundColor(...)");
        Drawable drawable2 = this.getBackground();
        Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
        GradientDrawable gradientDrawable = (GradientDrawable)drawable2;
        gradientDrawable.setCornerRadius(PixelExtensionsKt.pxFromDp$default(f3, null, 1, null));
        NativeColor nativeColor4 = nativeColor3;
        int n14 = (int)(nativeColor4.getG() * 255.0f + 0.5f);
        gradientDrawable.setTint(Color.argb((int)((int)(nativeColor3.getA() * 255.0f + 0.5f)), (int)((int)(nativeColor3.getR() * 255.0f + 0.5f)), (int)n14, (int)((int)(nativeColor4.getB() * 255.0f + 0.5f))));
        String string2 = nativeHintStyle.getScanditIcon();
        if (string2 != null) {
            ScanditIcon scanditIcon = ScanditIconDeserializer.fromJson(string2);
            this.b.setVisibility(0);
            this.b.setImageTintList(null);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            this.b.setImageDrawable(scanditIcon.getDrawable$scandit_capture_core(context));
        } else {
            void var2_11;
            NativeHintIcon nativeHintIcon = nativeHintStyle.getHintIcon();
            if (nativeHintIcon == null) {
                int n15 = -1;
            } else {
                int n16 = A.b[nativeHintIcon.ordinal()];
            }
            if (var2_11 != true) {
                if (var2_11 != 2) {
                    void var2_16;
                    this.b.setVisibility(0);
                    NativeHintIcon nativeHintIcon2 = nativeHintStyle.getHintIcon();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)nativeHintIcon2), (String)"getHintIcon(...)");
                    switch (C.a[nativeHintIcon2.ordinal()]) {
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                        case 1: 
                        case 4: {
                            boolean bl2 = false;
                            break;
                        }
                        case 3: {
                            int n17 = R.drawable.sc_ic_hint_exclamation_mark;
                            break;
                        }
                        case 2: {
                            int n18 = R.drawable.sc_ic_hint_check;
                        }
                    }
                    this.b.setImageResource((int)var2_16);
                    NativeColor nativeColor5 = nativeHintStyle.getIconColor();
                    Intrinsics.checkNotNullExpressionValue((Object)nativeColor5, (String)"getIconColor(...)");
                    NativeColor nativeColor6 = nativeColor5;
                    int n19 = (int)(nativeColor6.getG() * 255.0f + 0.5f);
                    this.b.setImageTintList(ColorStateList.valueOf((int)Color.argb((int)((int)(nativeColor5.getA() * 255.0f + 0.5f)), (int)((int)(nativeColor5.getR() * 255.0f + 0.5f)), (int)n19, (int)((int)(nativeColor6.getB() * 255.0f + 0.5f)))));
                } else if (Intrinsics.areEqual((Object)nativeHintStyle.getIconResource(), (Object)"user-swipe")) {
                    ImageView imageView = this.b;
                    Intrinsics.checkNotNullParameter((Object)imageView, (String)"iconView");
                    Context context = imageView.getContext();
                    int n20 = R.drawable.sc_ic_user_swipe;
                    Drawable drawable3 = context.getResources().getDrawable(n20, context.getTheme());
                    Intrinsics.checkNotNull((Object)drawable3, (String)"null cannot be cast to non-null type android.graphics.drawable.AnimatedVectorDrawable");
                    AnimatedVectorDrawable animatedVectorDrawable = (AnimatedVectorDrawable)drawable3;
                    ImageView imageView2 = imageView;
                    imageView2.setImageDrawable((Drawable)animatedVectorDrawable);
                    imageView2.setImageTintList(null);
                    animatedVectorDrawable.registerAnimationCallback((Animatable2.AnimationCallback)new B(imageView, animatedVectorDrawable));
                    animatedVectorDrawable.start();
                } else {
                    this.b.setVisibility(8);
                }
            } else {
                this.b.setVisibility(8);
            }
        }
        NativeHintIcon nativeHintIcon = nativeHintStyle.getHintIcon();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)nativeHintIcon), (String)"getHintIcon(...)");
        if (A.b[nativeHintIcon.ordinal()] == 1) {
            boolean bl3 = false;
        } else {
            this.a.onPreDraw();
            int n21 = RangesKt.coerceAtLeast((int)(this.a.getLayout().getTopPadding() + (PixelExtensionsKt.pxFromDp$default(24, null, 1, null) - this.a.getLayout().getLineBaseline(0)) / 2), (int)0);
        }
        ViewGroup.LayoutParams layoutParams3 = this.a.getLayoutParams();
        if (layoutParams3 instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams3;
        } else {
            Object var3_47 = null;
        }
        if (var3_48 != null) {
            void var2_23;
            var3_48.topMargin = var2_23;
            var3_48.bottomMargin = var2_23;
            this.a.setLayoutParams((ViewGroup.LayoutParams)var3_48);
        }
        this.d = nativeHintStyle.getCanBeDismissed();
    }

    public final void b(NativeHintStyle nativeHintStyle, Rect rect, boolean bl) {
        HintView hintView = hintView2;
        Intrinsics.checkNotNullParameter((Object)nativeHintStyle, (String)"hintStyle");
        ViewGroup.LayoutParams layoutParams = hintView.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
        HintView hintView2 = (RelativeLayout.LayoutParams)layoutParams;
        int n2 = ((RelativeLayout.LayoutParams)hintView2).leftMargin;
        hintView.a((RelativeLayout.LayoutParams)hintView2, nativeHintStyle, rect, bl, n2);
        hintView.setLayoutParams((ViewGroup.LayoutParams)hintView2);
    }

    public final void a(GuidanceHint guidanceHint, Rect rect) {
        Intrinsics.checkNotNullParameter((Object)guidanceHint, (String)"guidance");
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
        RelativeLayout.LayoutParams layoutParams2 = (RelativeLayout.LayoutParams)layoutParams;
        if (layoutParams2.getRule(10) != -1) {
            return;
        }
        int n2 = this.a(guidanceHint.getHintStyle(), rect, true);
        int n3 = layoutParams2.topMargin;
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{n3, n2});
        valueAnimator.addUpdateListener(arg_0 -> HintView.a(layoutParams2, this, arg_0));
        valueAnimator.setDuration(100L);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.start();
    }

    public HintView(Context context) {
        HintView hintView = this;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        View.inflate((Context)context, (int)R.layout.sc_hint_view_v2, (ViewGroup)this);
        View view = hintView.findViewById(R.id.textView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        hintView.a = (TextView)view;
        View view2 = hintView.findViewById(R.id.iconView);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        hintView.b = (ImageView)view2;
        hintView.setBackgroundResource(R.drawable.sc_hint_view_background);
        hintView.setAlpha(0.0f);
        hintView.setFocusable(true);
        if (Build.VERSION.SDK_INT >= 28) {
            this.setScreenReaderFocusable(true);
        }
        HintView hintView2 = this;
        hintView2.e = new PointF(0.0f, 0.0f);
        hintView2.f = new PointF(0.0f, 0.0f);
        hintView2.h = PixelExtensionsKt.pxFromDp(200.0f, context);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void a(RelativeLayout.LayoutParams layoutParams, NativeHintStyle nativeHintStyle, Rect rect, boolean bl, int n2) {
        void var5_7;
        int n3;
        NativeHintStyle nativeHintStyle2 = nativeHintStyle;
        RelativeLayout.LayoutParams layoutParams2 = layoutParams;
        layoutParams2.removeRule(10);
        layoutParams2.removeRule(12);
        int n4 = this.a(nativeHintStyle, rect, bl);
        int n5 = MathKt.roundToInt((float)PixelExtensionsKt.pxFromDp$default(nativeHintStyle2.getHintAnchorOffset(), null, 1, null));
        if (nativeHintStyle2.getHintAnchor() != NativeHintAnchor.TOP && rect != null) {
            if (nativeHintStyle.getHintAnchor() == NativeHintAnchor.ABOVE_VIEW_FINDER) {
                ViewParent viewParent = this.getParent();
                Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
                n3 = ((View)viewParent).getHeight() - MathKt.roundToInt((float)PixelExtensionsKt.pxFromDp$default(rect.getOrigin().getY(), null, 1, null)) + n5;
                layoutParams.addRule(12);
            } else {
                if (nativeHintStyle.getHintAnchor() != NativeHintAnchor.BELOW_VIEW_FINDER) throw new UnsupportedOperationException("Unsupported anchor " + (Object)((Object)nativeHintStyle.getHintAnchor()));
                n3 = 0;
                layoutParams.addRule(10);
            }
        } else {
            n3 = 0;
            layoutParams.addRule(10);
        }
        layoutParams.setMargins((int)var5_7, n4, (int)var5_7, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int a(NativeHintStyle nativeHintStyle, Rect rect, boolean bl) {
        int n2;
        RelativeLayout relativeLayout = (relativeLayout = relativeLayout.getParent()) instanceof HintHolderV2Impl ? (HintHolderV2Impl)relativeLayout : null;
        relativeLayout = relativeLayout != null ? relativeLayout.anyToastView$scandit_capture_core() : null;
        int n3 = MathKt.roundToInt((float)PixelExtensionsKt.pxFromDp$default(nativeHintStyle.getHintAnchorOffset(), null, 1, null));
        int n4 = bl && relativeLayout != null ? (int)(relativeLayout.getY() + (float)relativeLayout.getHeight()) + n3 : 0;
        if (nativeHintStyle.getHintAnchor() != NativeHintAnchor.TOP && rect != null) {
            if (nativeHintStyle.getHintAnchor() == NativeHintAnchor.ABOVE_VIEW_FINDER) {
                return 0;
            }
            if (nativeHintStyle.getHintAnchor() != NativeHintAnchor.BELOW_VIEW_FINDER) throw new UnsupportedOperationException("Unsupported anchor " + (Object)((Object)nativeHintStyle.getHintAnchor()));
            Rect rect2 = rect;
            float f2 = rect2.getOrigin().getY();
            n2 = Math.max(MathKt.roundToInt((float)PixelExtensionsKt.pxFromDp$default(rect2.getSize().getHeight() + f2, null, 1, null)) + n3, n4);
            return n2;
        } else {
            n2 = Math.max(n3, n4);
        }
        return n2;
    }

    private static final void a(HintView hintView) {
        HintView hintView2 = hintView;
        Intrinsics.checkNotNullParameter((Object)((Object)hintView2), (String)"this$0");
        hintView = hintView2.c;
        if (hintView != null) {
            hintView.invoke();
        }
    }

    private static final void a(RelativeLayout.LayoutParams layoutParams, HintView hintView, ValueAnimator valueAnimator) {
        RelativeLayout.LayoutParams layoutParams2 = layoutParams;
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"$params");
        Intrinsics.checkNotNullParameter((Object)((Object)hintView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator, (String)"it");
        int n2 = layoutParams.leftMargin;
        Object object = valueAnimator.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int n3 = (Integer)object;
        int n4 = layoutParams2.rightMargin;
        int n5 = layoutParams2.bottomMargin;
        layoutParams2.setMargins(n2, n3, n4, n5);
        hintView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
    }

    private final void a() {
        this.animate().alpha(0.0f).setDuration(200L).withEndAction(() -> HintView.a(this)).start();
    }
}

