/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.transport.ble;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.util.Log;
import com.scandit.datacapture.core.internal.sdk.data.NativeDataTransportError;
import com.scandit.datacapture.core.internal.sdk.transport.DataTransportListener;
import com.scandit.datacapture.core.internal.sdk.transport.ble.BleUuids;
import java.io.ByteArrayOutputStream;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0001\u0018\u0000 *2\u00020\u0001:\u0001*B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0015J'\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010 \u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b \u0010!J\u001f\u0010\"\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001eH\u0017\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010&\u001a\u00020\f2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\f\u00a2\u0006\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/scandit/datacapture/core/internal/sdk/transport/ble/BluetoothClient;", "Landroid/bluetooth/BluetoothGattCallback;", "Landroid/content/Context;", "context", "Lcom/scandit/datacapture/core/internal/sdk/transport/DataTransportListener;", "listener", "Lcom/scandit/datacapture/core/internal/sdk/transport/ble/BleUuids;", "uuids", "<init>", "(Landroid/content/Context;Lcom/scandit/datacapture/core/internal/sdk/transport/DataTransportListener;Lcom/scandit/datacapture/core/internal/sdk/transport/ble/BleUuids;)V", "Landroid/bluetooth/BluetoothDevice;", "device", "", "connect", "(Landroid/bluetooth/BluetoothDevice;)V", "Landroid/bluetooth/BluetoothGatt;", "gatt", "", "status", "newState", "onConnectionStateChange", "(Landroid/bluetooth/BluetoothGatt;II)V", "onServicesDiscovered", "(Landroid/bluetooth/BluetoothGatt;I)V", "mtu", "onMtuChanged", "Landroid/bluetooth/BluetoothGattDescriptor;", "descriptor", "onDescriptorWrite", "(Landroid/bluetooth/BluetoothGatt;Landroid/bluetooth/BluetoothGattDescriptor;I)V", "Landroid/bluetooth/BluetoothGattCharacteristic;", "characteristic", "onCharacteristicWrite", "(Landroid/bluetooth/BluetoothGatt;Landroid/bluetooth/BluetoothGattCharacteristic;I)V", "onCharacteristicChanged", "(Landroid/bluetooth/BluetoothGatt;Landroid/bluetooth/BluetoothGattCharacteristic;)V", "", "data", "sendMessage", "([B)V", "disconnect", "()V", "Companion", "scandit-capture-core"})
@SuppressLint(value={"MissingPermission"})
public final class BluetoothClient
extends BluetoothGattCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Context a;
    private final DataTransportListener b;
    private final BleUuids c;
    private BluetoothGatt d;
    private BluetoothGattCharacteristic e;
    private BluetoothGattCharacteristic f;
    private BluetoothGattCharacteristic g;
    private final Queue h;
    private final ByteArrayOutputStream i;
    private int j;

    /*
     * WARNING - void declaration
     */
    public BluetoothClient(@NotNull Context context, @NotNull DataTransportListener listener, @NotNull BleUuids uuids) {
        ByteArrayOutputStream byteArrayOutputStream;
        ArrayDeque arrayDeque;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"uuids");
        this_.a = var1_1;
        this_.b = var2_2;
        this_.c = var3_3;
        Object this_ = arrayDeque;
        arrayDeque = new ArrayDeque();
        v1.h = this_;
        this_ = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.i = this_;
    }

    private final void a() {
        block7: {
            byte[] byArray = (byte[])((ArrayDeque)this.h).poll();
            if (byArray == null) {
                return;
            }
            if (byArray.length == 0 ^ true) {
                BluetoothGattCharacteristic bluetoothGattCharacteristic = this.f;
                if (bluetoothGattCharacteristic != null) {
                    bluetoothGattCharacteristic.setValue(byArray);
                }
                BluetoothGatt bluetoothGatt = this.d;
                Intrinsics.checkNotNull((Object)bluetoothGatt);
                if (bluetoothGatt.writeCharacteristic(this.f)) break block7;
                try {
                    this.a(NativeDataTransportError.WRITE_FAILED);
                    return;
                }
                catch (SecurityException securityException) {
                    this.a(NativeDataTransportError.WRITE_FAILED);
                }
            }
        }
    }

    private final void a(NativeDataTransportError nativeDataTransportError) {
        Log.e((String)"BluetoothClient", (String)((Object)((Object)nativeDataTransportError)).toString());
        this.b.onError(nativeDataTransportError);
    }

    /*
     * WARNING - void declaration
     */
    public final void connect(@NotNull BluetoothDevice device) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"device");
        Context context = this.a;
        try {
            this.d = var1_1.connectGatt(context, false, (BluetoothGattCallback)this, 2);
        }
        catch (Exception exception) {
            this.a(NativeDataTransportError.CONNECTION_FAILED);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onConnectionStateChange(@NotNull BluetoothGatt gatt, int status, int newState) {
        block4: {
            block3: {
                void v1;
                void var3_3;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"gatt");
                if (newState == 0) break block3;
                if (var3_3 != 2) break block4;
                try {
                    void v02 = var1_1;
                    v1 = v02;
                    v02.requestConnectionPriority(1);
                }
                catch (SecurityException securityException) {
                    this.a(NativeDataTransportError.CONNECTION_FAILED);
                }
                v1.discoverServices();
                break block4;
                break block4;
            }
            this.b.onDisconnected();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onServicesDiscovered(@NotNull BluetoothGatt gatt, int status) {
        block8: {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"gatt");
            if (status != 0) return;
            BluetoothGattService bluetoothGattService = var1_1.getService(this.c.getService());
            if (bluetoothGattService != null) {
                this.e = bluetoothGattService.getCharacteristic(this.c.getStateCharacteristic());
                if (this.e == null) {
                    this.a(NativeDataTransportError.CONNECTION_FAILED);
                    return;
                }
                this.f = bluetoothGattService.getCharacteristic(this.c.getClientToServerCharacteristic());
                if (this.f == null) {
                    this.a(NativeDataTransportError.CONNECTION_FAILED);
                    return;
                }
                this.g = bluetoothGattService.getCharacteristic(this.c.getServerToClientCharacteristic());
                if (this.g == null) {
                    this.a(NativeDataTransportError.CONNECTION_FAILED);
                    return;
                }
            }
            try {
                if (var1_1.requestMtu(515)) {
                    this.d = var1_1;
                    return;
                }
            }
            catch (SecurityException securityException) {
                break block8;
            }
            {
                this.a(NativeDataTransportError.CONNECTION_FAILED);
                return;
            }
        }
        this.a(NativeDataTransportError.CONNECTION_FAILED);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMtuChanged(@NotNull BluetoothGatt gatt, int mtu, int status) {
        block9: {
            BluetoothGattCharacteristic bluetoothGattCharacteristic;
            void v1;
            Object object;
            void var3_4;
            int n2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"gatt");
            if (mtu == 0) {
                n2 = 23;
            }
            n2 = n2 > 515 ? 512 : (n2 -= 3);
            this.j = n2;
            if (var3_4 != false) {
                this.a(NativeDataTransportError.CONNECTION_FAILED);
            }
            try {
                if (!var1_1.setCharacteristicNotification(this.g, true)) {
                    this.a(NativeDataTransportError.CONNECTION_FAILED);
                    return;
                }
            }
            catch (SecurityException securityException) {
                break block9;
            }
            {
                object = this.g;
                object = object != null ? object.getDescriptor(this.c.getClientCharacteristicConfiguration()) : null;
            }
            {
                if (object == null) {
                    this.a(NativeDataTransportError.CONNECTION_FAILED);
                    return;
                }
                v1 = var1_1;
                BluetoothGattCharacteristic bluetoothGattCharacteristic2 = object;
                bluetoothGattCharacteristic = bluetoothGattCharacteristic2;
                bluetoothGattCharacteristic2.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            }
            {
                if (v1.writeDescriptor((BluetoothGattDescriptor)bluetoothGattCharacteristic)) return;
                this.a(NativeDataTransportError.CONNECTION_FAILED);
                return;
            }
        }
        this.a(NativeDataTransportError.CONNECTION_FAILED);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDescriptorWrite(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattDescriptor descriptor, int status) {
        block10: {
            v0 = descriptor;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"gatt");
            Intrinsics.checkNotNullParameter((Object)v0, (String)"descriptor");
            try {
                var3_4 = v0.getCharacteristic().getUuid();
            }
            catch (SecurityException v1) {
                break block10;
            }
            {
                if (!Intrinsics.areEqual((Object)var3_4, (Object)this.c.getServerToClientCharacteristic()) || !Intrinsics.areEqual((Object)var2_2 /* !! */ .getUuid(), (Object)this.c.getClientCharacteristicConfiguration())) ** GOTO lbl25
                if (var1_1.setCharacteristicNotification(this.e, true)) ** GOTO lbl-1000
                this.a(NativeDataTransportError.WRITE_FAILED);
                return;
            }
lbl-1000:
            // 1 sources

            {
                var2_2 /* !! */  = this.e;
                if (var2_2 /* !! */  == null) return;
            }
            {
                var2_2 /* !! */  = var2_2 /* !! */ .getDescriptor(this.c.getClientCharacteristicConfiguration());
                if (var2_2 /* !! */  == null) return;
            }
            {
                v2 = var1_1;
                v3 /* !! */  = var2_2 /* !! */ ;
                v4 /* !! */  = v3 /* !! */ ;
                v3 /* !! */ .setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            }
            {
                if (v2.writeDescriptor((BluetoothGattDescriptor)v4 /* !! */ ) != false) return;
                this.a(NativeDataTransportError.WRITE_FAILED);
                return;
lbl25:
                // 1 sources

                if (!Intrinsics.areEqual((Object)var3_4, (Object)this.c.getStateCharacteristic()) || !Intrinsics.areEqual((Object)var2_2 /* !! */ .getUuid(), (Object)this.c.getClientCharacteristicConfiguration())) ** GOTO lbl37
                var2_2 /* !! */  = this.e;
                if (var2_2 /* !! */  == null) ** GOTO lbl-1000
            }
            {
                v5 = var2_2 /* !! */ ;
                v6 = new byte[1];
            }
            var2_2 /* !! */  = (BluetoothGattCharacteristic)v6;
            {
                v6[0] = 1;
                v5.setValue((byte[])var2_2 /* !! */ );
            }
lbl-1000:
            // 2 sources

            {
                if (var1_1.writeCharacteristic(this.e) != false) return;
                this.a(NativeDataTransportError.WRITE_FAILED);
                return;
lbl37:
                // 1 sources

                this.a(NativeDataTransportError.WRITE_FAILED);
                return;
            }
        }
        this.a(NativeDataTransportError.WRITE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    public void onCharacteristicWrite(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        void var3_3;
        UUID uUID;
        BluetoothGattCharacteristic bluetoothGattCharacteristic = characteristic;
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"gatt");
        Intrinsics.checkNotNullParameter((Object)bluetoothGattCharacteristic, (String)"characteristic");
        uUID = bluetoothGattCharacteristic.getUuid();
        if (Intrinsics.areEqual((Object)uUID, (Object)this.c.getStateCharacteristic())) {
            if (var3_3 == false) {
                this.b.onConnected();
            } else {
                this.a(NativeDataTransportError.WRITE_FAILED);
            }
        } else if (Intrinsics.areEqual((Object)uUID, (Object)this.c.getClientToServerCharacteristic())) {
            if (var3_3 == false) {
                this.a();
            } else {
                this.a(NativeDataTransportError.WRITE_FAILED);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated in API 33 but still working for newer APIs")
    public void onCharacteristicChanged(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic) {
        byte[] byArray;
        BluetoothGattCharacteristic bluetoothGattCharacteristic = characteristic;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"gatt");
        Intrinsics.checkNotNullParameter((Object)bluetoothGattCharacteristic, (String)"characteristic");
        if (Intrinsics.areEqual((Object)bluetoothGattCharacteristic.getUuid(), (Object)object.c.getServerToClientCharacteristic())) {
            void var2_2;
            byArray = var2_2.getValue();
            Intrinsics.checkNotNull((Object)byArray);
            if (byArray.length == 0 ^ true) {
                object.i.write(byArray, 1, byArray.length - 1);
                if (byArray[0] == 0) {
                    BluetoothClient bluetoothClient = object;
                    Object object = bluetoothClient.i.toByteArray();
                    bluetoothClient.i.reset();
                    bluetoothClient.b.onDataReceived((byte[])object);
                } else {
                    object.a(NativeDataTransportError.READ_FAILED);
                }
            } else {
                object.a(NativeDataTransportError.READ_FAILED);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendMessage(@NotNull byte[] data) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"data");
        boolean bl = ((ArrayDeque)this.h).isEmpty();
        if (data.length == 0) {
            ((ArrayDeque)this.h).add(var1_1);
        } else {
            int n2;
            int n3 = this.j - 1;
            int n4 = 0;
            do {
                byte by = n4 + n3 < ((void)var1_1).length ? (byte)1 : 0;
                n2 = ((void)var1_1).length - n4;
                if (n2 > n3) {
                    n2 = n3;
                }
                byte[] byArray = new byte[n2 + 1];
                byte[] byArray2 = byArray;
                byArray[0] = by;
                System.arraycopy(var1_1, n4, byArray2, 1, n2);
                ((ArrayDeque)this.h).add(byArray2);
            } while ((n4 += n2) < ((void)var1_1).length);
        }
        if (bl) {
            this.a();
        }
    }

    public final void disconnect() {
        BluetoothGatt bluetoothGatt = this.d;
        if (bluetoothGatt != null) {
            bluetoothGatt.disconnect();
        }
        if ((bluetoothGatt = this.d) != null) {
            bluetoothGatt.close();
        }
        this.d = null;
    }

    @Metadata(mv={1, 9, 0}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/core/internal/sdk/transport/ble/BluetoothClient$Companion;", "", "", "MTU_SIZE", "I", "scandit-capture-core"})
    public static final class Companion {
        public Companion(DefaultConstructorMarker $constructor_marker) {
        }
    }
}

