/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.transport.ble;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.ParcelUuid;
import com.scandit.datacapture.core.internal.sdk.data.NativeDataTransportConnectionOptions;
import com.scandit.datacapture.core.internal.sdk.data.NativeDataTransportError;
import com.scandit.datacapture.core.internal.sdk.data.NativeDataTransportType;
import com.scandit.datacapture.core.internal.sdk.transport.DataTransport;
import com.scandit.datacapture.core.internal.sdk.transport.DataTransportListener;
import com.scandit.datacapture.core.internal.sdk.transport.ble.BleUuids;
import com.scandit.datacapture.core.internal.sdk.transport.ble.BluetoothClient;
import com.scandit.datacapture.core.internal.sdk.transport.ble.BluetoothDataTransport;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/scandit/datacapture/core/internal/sdk/transport/ble/BluetoothDataTransport;", "Lcom/scandit/datacapture/core/internal/sdk/transport/DataTransport;", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "", "isAvailable", "()Z", "Lcom/scandit/datacapture/core/internal/sdk/data/NativeDataTransportConnectionOptions;", "options", "", "connect", "(Lcom/scandit/datacapture/core/internal/sdk/data/NativeDataTransportConnectionOptions;)V", "disconnect", "()V", "", "data", "write", "([B)V", "Companion", "scandit-capture-core"})
@SuppressLint(value={"MissingPermission"})
@SourceDebugExtension(value={"SMAP\nBluetoothDataTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BluetoothDataTransport.kt\ncom/scandit/datacapture/core/internal/sdk/transport/ble/BluetoothDataTransport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1726#2,3:123\n*S KotlinDebug\n*F\n+ 1 BluetoothDataTransport.kt\ncom/scandit/datacapture/core/internal/sdk/transport/ble/BluetoothDataTransport\n*L\n41#1:123,3\n*E\n"})
public final class BluetoothDataTransport
extends DataTransport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final List f = Build.VERSION.SDK_INT >= 31 ? CollectionsKt.listOf((Object[])new String[]{"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_CONNECT"}) : CollectionsKt.listOf((Object)"android.permission.ACCESS_FINE_LOCATION");
    private final Context b;
    private final BluetoothManager c;
    private BluetoothClient d;
    private final AtomicBoolean e;

    /*
     * WARNING - void declaration
     */
    public BluetoothDataTransport(@NotNull Context context) {
        void var1_1;
        BluetoothDataTransport bluetoothDataTransport = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        super(NativeDataTransportType.BLUETOOTH);
        this.b = var1_1;
        Object object = var1_1.getSystemService("bluetooth");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        bluetoothDataTransport.c = (BluetoothManager)object;
        bluetoothDataTransport.e = new AtomicBoolean(false);
    }

    public static final /* synthetic */ AtomicBoolean access$isConnecting$p(BluetoothDataTransport $this) {
        return $this.e;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setClient$p(BluetoothDataTransport $this, BluetoothClient bluetoothClient) {
        void var1_1;
        $this.d = var1_1;
    }

    public static final /* synthetic */ Context access$getContext$p(BluetoothDataTransport $this) {
        return $this.b;
    }

    public static final /* synthetic */ DataTransportListener access$getListener(BluetoothDataTransport $this) {
        return $this.getListener();
    }

    public static final void access$reportConnectionFailure(BluetoothDataTransport $this) {
        $this.getListener().onError(NativeDataTransportError.CONNECTION_FAILED);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isAvailable() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block4: {
            block3: {
                BluetoothDataTransport bluetoothDataTransport = this;
                bl3 = bluetoothDataTransport.b.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
                BluetoothAdapter bluetoothAdapter = bluetoothDataTransport.c.getAdapter();
                bl2 = bluetoothAdapter != null && bluetoothAdapter.isEnabled();
                Object object = f;
                if (!(object instanceof Collection) || !object.isEmpty()) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        if (this.b.checkSelfPermission(string2) == 0) {
                            continue;
                        }
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (!bl3) return false;
        if (!bl2) return false;
        if (!bl) return false;
        return true;
    }

    @Override
    public void connect(@NotNull NativeDataTransportConnectionOptions options) {
        ScanCallback scanCallback2;
        ScanFilter scanFilter;
        Intrinsics.checkNotNullParameter((Object)scanFilter, (String)"options");
        Object object = this.c.getAdapter();
        object = object != null ? object.getBluetoothLeScanner() : null;
        if (object == null) {
            this.getListener().onError(NativeDataTransportError.CONNECTION_FAILED);
            return;
        }
        BluetoothAdapter bluetoothAdapter = object;
        object = UUID.fromString(scanFilter.getPeripheralServerModeUuid());
        ScanCallback scanCallback3 = scanCallback2;
        scanCallback2 = new ScanCallback(this, (NativeDataTransportConnectionOptions)scanFilter){
            final /* synthetic */ BluetoothDataTransport a;
            final /* synthetic */ NativeDataTransportConnectionOptions b;
            {
                this.a = bluetoothDataTransport;
                this.b = nativeDataTransportConnectionOptions;
            }

            /*
             * WARNING - void declaration
             */
            public void onScanResult(int callbackType, @NotNull ScanResult result) {
                void var1_1;
                void var2_2;
                connect.scanCallback.1 v02 = this;
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"result");
                super.onScanResult((int)var1_1, (ScanResult)var2_2);
                if (!BluetoothDataTransport.access$isConnecting$p(v02.a).get()) {
                    connect.scanCallback.1 v1 = this;
                    BluetoothDataTransport.access$isConnecting$p(v1.a).set(true);
                    BluetoothDataTransport bluetoothDataTransport = v1.a;
                    BluetoothClient bluetoothClient = new BluetoothClient(BluetoothDataTransport.access$getContext$p(this.a), BluetoothDataTransport.access$getListener(this.a), new BleUuids(this.b));
                    BluetoothDevice bluetoothDevice = var2_2.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"getDevice(...)");
                    bluetoothClient.connect(bluetoothDevice);
                    BluetoothDataTransport.access$setClient$p(bluetoothDataTransport, bluetoothClient);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onScanFailed(int errorCode) {
                void var1_1;
                connect.scanCallback.1 v02 = this;
                super.onScanFailed((int)var1_1);
                BluetoothDataTransport.access$reportConnectionFailure(v02.a);
            }
        };
        scanFilter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid((UUID)object)).build();
        try {
            bluetoothAdapter.startScan(CollectionsKt.mutableListOf((Object[])new ScanFilter[]{scanFilter}), new ScanSettings.Builder().setCallbackType(1).setScanMode(2).build(), scanCallback3);
        }
        catch (Exception exception) {
            this.getListener().onError(NativeDataTransportError.CONNECTION_FAILED);
        }
    }

    @Override
    public void disconnect() {
        this.e.set(false);
        this.d = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull byte[] data) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"data");
        BluetoothClient this_ = ((BluetoothDataTransport)((Object)this_)).d;
        if (this_ != null) {
            this_.sendMessage((byte[])var1_1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/scandit/datacapture/core/internal/sdk/transport/ble/BluetoothDataTransport$Companion;", "", "", "", "REQUIRED_PERMISSIONS", "Ljava/util/List;", "scandit-capture-core"})
    public static final class Companion {
        public Companion(DefaultConstructorMarker $constructor_marker) {
        }
    }
}

