/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.ui.animation;

import com.scandit.datacapture.core.ui.animation.DynamicAnimation;

public final class SpringForce {
    public static final float STIFFNESS_HIGH = 10000.0f;
    public static final float STIFFNESS_MEDIUM = 1500.0f;
    public static final float STIFFNESS_LOW = 200.0f;
    public static final float STIFFNESS_VERY_LOW = 50.0f;
    public static final float DAMPING_RATIO_HIGH_BOUNCY = 0.2f;
    public static final float DAMPING_RATIO_MEDIUM_BOUNCY = 0.5f;
    public static final float DAMPING_RATIO_LOW_BOUNCY = 0.75f;
    public static final float DAMPING_RATIO_NO_BOUNCY = 1.0f;
    private double b = Math.sqrt(1500.0);
    double a = 1.0;
    private boolean c = false;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;
    private double i = Double.MAX_VALUE;
    private final DynamicAnimation.a j = new DynamicAnimation.a();

    public SpringForce() {
    }

    /*
     * WARNING - void declaration
     */
    public SpringForce(float finalPosition) {
        void var1_1;
        this.i = (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final SpringForce setStiffness(float stiffness) {
        void var1_1;
        if (stiffness <= 0.0f) {
            throw new IllegalArgumentException("Spring stiffness constant must be positive.");
        }
        this.b = Math.sqrt((double)var1_1);
        this.c = false;
        return this;
    }

    public final float getStiffness() {
        return (float)(this.b * this.b);
    }

    /*
     * WARNING - void declaration
     */
    public final SpringForce setDampingRatio(float dampingRatio) {
        void var1_1;
        if (dampingRatio < 0.0f) {
            throw new IllegalArgumentException("Damping ratio must be non-negative");
        }
        this.a = (double)var1_1;
        this.c = false;
        return this;
    }

    public final float getDampingRatio() {
        return (float)this.a;
    }

    /*
     * WARNING - void declaration
     */
    public final SpringForce setFinalPosition(float finalPosition) {
        void var1_1;
        this.i = (double)var1_1;
        return this;
    }

    public final float getFinalPosition() {
        return (float)this.i;
    }

    /*
     * WARNING - void declaration
     */
    public final float getAcceleration(float lastDisplacement, float lastVelocity) {
        void var2_2;
        void var1_1;
        lastDisplacement -= this.getFinalPosition();
        double d2 = this.b * this.b;
        double d3 = 2.0 * this.b * this.a;
        return (float)(-d2 * (double)var1_1 - d3 * (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAtEquilibrium(float value, float velocity) {
        void var1_1;
        return (double)Math.abs(velocity) < this.e && (double)Math.abs((float)(var1_1 - this.getFinalPosition())) < this.d;
    }

    final DynamicAnimation.a a(double d2, double d3, long l2) {
        double d4;
        double d5;
        SpringForce springForce = this;
        if (!springForce.c) {
            if (springForce.i == Double.MAX_VALUE) {
                throw new IllegalStateException("Error: Final position of the spring must be set before the animation starts");
            }
            if (springForce.a > 1.0) {
                springForce.f = -springForce.a * springForce.b + springForce.b * Math.sqrt(springForce.a * springForce.a - 1.0);
                springForce.g = -springForce.a * springForce.b - springForce.b * Math.sqrt(springForce.a * springForce.a - 1.0);
            } else if (springForce.a >= 0.0 && springForce.a < 1.0) {
                springForce.h = springForce.b * Math.sqrt(1.0 - springForce.a * springForce.a);
            }
            springForce.c = true;
        }
        double d6 = (double)l2 / 1000.0;
        d2 -= this.i;
        if (this.a > 1.0) {
            double d7 = d2 - (this.g * d2 - d3) / (this.g - this.f);
            double d8 = (this.g * d2 - d3) / (this.g - this.f);
            d5 = d7 * Math.pow(Math.E, this.g * d6) + d8 * Math.pow(Math.E, this.f * d6);
            d4 = d7 * this.g * Math.pow(Math.E, this.g * d6) + d8 * this.f * Math.pow(Math.E, this.f * d6);
        } else if (this.a == 1.0) {
            double d9 = d2;
            double d10 = d3 + this.b * d2;
            d5 = (d9 + d10 * d6) * Math.pow(Math.E, -this.b * d6);
            d4 = (d9 + d10 * d6) * Math.pow(Math.E, -this.b * d6) * -this.b + d10 * Math.pow(Math.E, -this.b * d6);
        } else {
            double d11 = d2;
            double d12 = 1.0 / this.h * (this.a * this.b * d2 + d3);
            d5 = Math.pow(Math.E, -this.a * this.b * d6) * (d11 * Math.cos(this.h * d6) + d12 * Math.sin(this.h * d6));
            d4 = d5 * -this.b * this.a + Math.pow(Math.E, -this.a * this.b * d6) * (-this.h * d11 * Math.sin(this.h * d6) + this.h * d12 * Math.cos(this.h * d6));
        }
        this.j.a = (float)(d5 + this.i);
        this.j.b = (float)d4;
        return this.j;
    }

    final void a(double d2) {
        this.d = Math.abs(d2);
        this.e = this.d * 62.5;
    }
}

