/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.extensions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import com.scandit.datacapture.core.internal.sdk.AppAndroidEnvironment;
import com.scandit.datacapture.core.internal.sdk.extensions.ContextExtensionsKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0001\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0001\u00a8\u0006\t"}, d2={"bitmapFromBase64", "Landroid/graphics/Bitmap;", "", "bitmapFromResource", "", "bitmapFromResourceName", "toBase64", "toJpeg", "", "scandit-capture-core"})
public final class BitmapExtensionsKt {
    @NotNull
    public static final Bitmap bitmapFromResource(int $this$bitmapFromResource) {
        int n9;
        return ContextExtensionsKt.getBitmap(AppAndroidEnvironment.INSTANCE.getApplicationContext(), n9);
    }

    @SuppressLint(value={"DiscouragedApi"})
    @NotNull
    public static final Bitmap bitmapFromResourceName(@NotNull String $this$bitmapFromResourceName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$bitmapFromResourceName, (String)"<this>");
        AppAndroidEnvironment appAndroidEnvironment = AppAndroidEnvironment.INSTANCE;
        Context context = appAndroidEnvironment.getApplicationContext();
        int n9 = context.getResources().getIdentifier(string2, "drawable", context.getPackageName());
        return ContextExtensionsKt.getBitmap(appAndroidEnvironment.getApplicationContext(), n9);
    }

    @Nullable
    public static final Bitmap bitmapFromBase64(@NotNull String $this$bitmapFromBase64) {
        Bitmap bitmap;
        String string2 = $this$bitmapFromBase64;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)string2)) {
            bitmap = null;
        } else {
            Object object;
            block13: {
                String string3 = object;
                int n9 = StringsKt.indexOf$default((CharSequence)string3, (String)",", (int)0, (boolean)false, (int)6, null);
                if (n9 < 0) break block13;
                object = ((Object)StringsKt.removeRange((CharSequence)object, (int)0, (int)n9)).toString();
            }
            byte[] byArray = Base64.decode((String)object, (int)2);
            object = byArray;
            if (byArray != null) {
                Object object2 = object;
                Object object3 = object2;
                Object object4 = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"decode(trimmedString, Base64.NO_WRAP)");
                int n10 = 0;
                object = BitmapFactory.decodeByteArray((byte[])object3, (int)n10, (int)((Object)object4).length);
            } else {
                object = null;
            }
            try {
                object = Result.constructor-impl((Object)object);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            bitmap = (Bitmap)object;
        }
        return bitmap;
    }

    @NotNull
    public static final String toBase64(@NotNull Bitmap $this$toBase64) {
        Bitmap.CompressFormat compressFormat;
        Bitmap bitmap;
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter((Object)$this$toBase64, (String)"<this>");
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        Bitmap bitmap2 = bitmap;
        byteArrayOutputStream2();
        bitmap = null;
        try {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)byteArrayOutputStream2, (Throwable)throwable);
                throw throwable2;
            }
        }
        bitmap2.compress(compressFormat, 100, (OutputStream)byteArrayOutputStream2);
        CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)bitmap);
        String string2 = Base64.encodeToString((byte[])byteArrayOutputStream.toByteArray(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(byteArray\u2026eArray(), Base64.NO_WRAP)");
        return string2;
    }

    @NotNull
    public static final byte[] toJpeg(@NotNull Bitmap $this$toJpeg) {
        Bitmap.CompressFormat compressFormat;
        Bitmap bitmap;
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter((Object)$this$toJpeg, (String)"<this>");
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        Bitmap bitmap2 = bitmap;
        byteArrayOutputStream2();
        bitmap = null;
        try {
            compressFormat = Bitmap.CompressFormat.JPEG;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)byteArrayOutputStream2, (Throwable)throwable);
                throw throwable2;
            }
        }
        bitmap2.compress(compressFormat, 100, (OutputStream)byteArrayOutputStream2);
        CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)bitmap);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        return byArray;
    }
}

