/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk;

import com.scandit.datacapture.core.area.LocationSelection;
import com.scandit.datacapture.core.capture.DataCaptureContext;
import com.scandit.datacapture.core.common.ContextStatus;
import com.scandit.datacapture.core.common.graphic.ImageBuffer;
import com.scandit.datacapture.core.data.FrameData;
import com.scandit.datacapture.core.internal.module.source.NativeAbstractCamera;
import com.scandit.datacapture.core.internal.module.source.NativeCameraSettings;
import com.scandit.datacapture.core.internal.module.source.NativeFocusSettings;
import com.scandit.datacapture.core.internal.sdk.area.NativeLocationSelection;
import com.scandit.datacapture.core.internal.sdk.capture.NativeDataCaptureContext;
import com.scandit.datacapture.core.internal.sdk.common.NativeContextStatus;
import com.scandit.datacapture.core.internal.sdk.common.geometry.NativeImageBuffer;
import com.scandit.datacapture.core.internal.sdk.common.graphics.NativeColor;
import com.scandit.datacapture.core.internal.sdk.data.NativeFrameData;
import com.scandit.datacapture.core.internal.sdk.extensions.NativeColorExtensionsKt;
import com.scandit.datacapture.core.internal.sdk.json.NativeJsonValue;
import com.scandit.datacapture.core.internal.sdk.ui.style.NativeBrush;
import com.scandit.datacapture.core.json.JsonValue;
import com.scandit.datacapture.core.source.Camera;
import com.scandit.datacapture.core.source.CameraSettings;
import com.scandit.datacapture.core.source.VideoResolution;
import com.scandit.datacapture.core.ui.style.Brush;
import com.scandit.datacapture.tools.internal.sdk.ProxyConverter;
import com.scandit.datacapture.tools.internal.sdk.ProxyConverterFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ProxyConverterFactory
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\fH\u0007J\u0010\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\u0010\u0010\u0003\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000eH\u0007J\u0010\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0010H\u0007J\u0010\u0010\u0003\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0012H\u0007J\u0010\u0010\u0003\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0014H\u0007J\u0010\u0010\u0003\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\tH\u0007J\u0010\u0010\u0003\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0013H\u0007J\u0010\u0010\u0003\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\rH\u0007J\u0010\u0010\u0003\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a8\u0006\u0019"}, d2={"Lcom/scandit/datacapture/core/internal/sdk/CoreNativeTypeFactory;", "", "()V", "convert", "Lcom/scandit/datacapture/core/internal/sdk/area/NativeLocationSelection;", "source", "Lcom/scandit/datacapture/core/area/LocationSelection;", "Lcom/scandit/datacapture/core/internal/sdk/common/NativeContextStatus;", "Lcom/scandit/datacapture/core/common/ContextStatus;", "Lcom/scandit/datacapture/core/source/CameraSettings;", "Lcom/scandit/datacapture/core/internal/module/source/NativeCameraSettings;", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "Lcom/scandit/datacapture/core/internal/sdk/capture/NativeDataCaptureContext;", "", "Lcom/scandit/datacapture/core/internal/sdk/common/graphics/NativeColor;", "Lcom/scandit/datacapture/core/data/FrameData;", "Lcom/scandit/datacapture/core/internal/sdk/data/NativeFrameData;", "Lcom/scandit/datacapture/core/json/JsonValue;", "Lcom/scandit/datacapture/core/internal/sdk/json/NativeJsonValue;", "Lcom/scandit/datacapture/core/ui/style/Brush;", "Lcom/scandit/datacapture/core/internal/sdk/ui/style/NativeBrush;", "Lcom/scandit/datacapture/core/internal/module/source/NativeAbstractCamera;", "camera", "Lcom/scandit/datacapture/core/source/Camera;", "", "sdc-core-android_release"})
public final class CoreNativeTypeFactory {
    public static final CoreNativeTypeFactory INSTANCE;

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final NativeLocationSelection convert(@NotNull LocationSelection source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return var1_1._locationSelectionImpl();
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final NativeBrush convert(@NotNull Brush source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return new NativeBrush(NativeColorExtensionsKt.toNativeColor(source.getFillColor()), NativeColorExtensionsKt.toNativeColor(source.getStrokeColor()), var1_1.getStrokeWidth());
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final Brush convert(@NotNull NativeBrush source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        NativeColor nativeColor = source.getFillColor();
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeColor, (String)"source.fillColor");
        int n2 = NativeColorExtensionsKt.toInt(nativeColor);
        NativeColor nativeColor2 = source.getStrokeColor();
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeColor2, (String)"source.strokeColor");
        return new Brush(n2, NativeColorExtensionsKt.toInt(nativeColor2), var1_1.getStrokeWidth());
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final NativeCameraSettings convert(@NotNull CameraSettings source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        VideoResolution videoResolution = source.getPreferredResolution();
        float f2 = source.getMaxFrameRate();
        float f3 = source.getZoomFactor();
        Object object = source.getProperty("manualLensPosition");
        if (!(object instanceof Float)) {
            object = null;
        }
        Float f4 = (Float)object;
        NativeFocusSettings nativeFocusSettings = new NativeFocusSettings(f4 != null ? f4.floatValue() : -1.0f, source.getShouldPreferSmoothAutoFocus());
        Object object2 = var1_1.getProperty("api");
        if (!(object2 instanceof Integer)) {
            object2 = null;
        }
        Integer n2 = (Integer)object2;
        return new NativeCameraSettings(videoResolution, f2, f3, nativeFocusSettings, n2 != null ? n2 : 1);
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final CameraSettings convert(@NotNull NativeCameraSettings source) {
        CameraSettings cameraSettings;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        CameraSettings cameraSettings2 = cameraSettings = new CameraSettings();
        VideoResolution videoResolution = source.getPreferredResolution();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)videoResolution), (String)"source.preferredResolution");
        cameraSettings.setPreferredResolution(videoResolution);
        cameraSettings2.setMaxFrameRate(source.getMaxFrameRate());
        cameraSettings2.setZoomFactor(source.getZoomFactor());
        NativeFocusSettings nativeFocusSettings = source.getFocus();
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeFocusSettings, (String)"source.focus");
        cameraSettings2.setShouldPreferSmoothAutoFocus(nativeFocusSettings.getShouldPreferSmoothAutoFocus());
        if (source.getApi() > 1) {
            cameraSettings2.setProperty("api", source.getApi());
        }
        NativeFocusSettings nativeFocusSettings2 = source.getFocus();
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeFocusSettings2, (String)"source.focus");
        if (nativeFocusSettings2.getManualLensPosition() >= 0.0f) {
            void var1_1;
            NativeFocusSettings nativeFocusSettings3 = var1_1.getFocus();
            Intrinsics.checkExpressionValueIsNotNull((Object)nativeFocusSettings3, (String)"source.focus");
            cameraSettings2.setProperty("manualLensPosition", Float.valueOf(nativeFocusSettings3.getManualLensPosition()));
        }
        return cameraSettings;
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final NativeContextStatus convert(@NotNull ContextStatus source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return new NativeContextStatus(source.getMessage(), var1_1.getCode());
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final ContextStatus convert(@NotNull NativeContextStatus source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return new ContextStatus((NativeContextStatus)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final DataCaptureContext convert(@NotNull NativeDataCaptureContext source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return new DataCaptureContext((NativeDataCaptureContext)var1_1, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final JsonValue convert(@NotNull NativeJsonValue source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return new JsonValue((NativeJsonValue)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final FrameData convert(@NotNull NativeFrameData source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return new FrameData((NativeFrameData)var1_1){
            private final NativeFrameData a;
            private /* synthetic */ NativeFrameData b;

            @NotNull
            public final NativeFrameData _impl() {
                return this.a;
            }

            public final void retain() {
                this.a.retain();
            }

            public final void release() {
                this.a.release();
            }

            public final int getOrientation() {
                return this.a.getOrientation();
            }

            @NotNull
            public final ImageBuffer getImageBuffer() {
                NativeImageBuffer nativeImageBuffer = this.a.getImageBuffer();
                Intrinsics.checkExpressionValueIsNotNull((Object)nativeImageBuffer, (String)"nativeFrameData.imageBuffer");
                return new ImageBuffer(nativeImageBuffer);
            }

            public final int hashCode() {
                return this.a.hashCode();
            }

            /*
             * WARNING - void declaration
             */
            public final boolean equals(@Nullable Object other) {
                void var1_1;
                if (!(other instanceof FrameData)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.a, (Object)((FrameData)var1_1)._impl());
            }
            {
                void var1_1;
                this.b = $captured_local_variable$0;
                this.a = var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final NativeJsonValue convert(@NotNull String source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        NativeJsonValue nativeJsonValue = NativeJsonValue.fromString((String)var1_1);
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeJsonValue, (String)"NativeJsonValue.fromString(source)");
        return nativeJsonValue;
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    public final int convert(@NotNull NativeColor source) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return NativeColorExtensionsKt.toInt((NativeColor)var1_1);
    }

    @ProxyConverter
    @NotNull
    public final NativeColor convert(int source) {
        return NativeColorExtensionsKt.toNativeColor(source);
    }

    /*
     * WARNING - void declaration
     */
    @ProxyConverter
    @NotNull
    public final NativeAbstractCamera convert(@NotNull Camera camera) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
        NativeAbstractCamera nativeAbstractCamera = var1_1._impl().asAbstractCamera();
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeAbstractCamera, (String)"camera._impl().asAbstractCamera()");
        return nativeAbstractCamera;
    }

    private CoreNativeTypeFactory() {
    }

    static {
        CoreNativeTypeFactory coreNativeTypeFactory;
        INSTANCE = coreNativeTypeFactory = new CoreNativeTypeFactory();
    }
}

