/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.extensions;

import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.media.Image;
import com.scandit.datacapture.core.common.graphic.Channel;
import com.scandit.datacapture.core.common.graphic.ImagePlane;
import com.scandit.datacapture.core.internal.module.common.geometry.NativeAxis;
import com.scandit.datacapture.core.internal.module.source.FrameBufferStack;
import com.scandit.datacapture.core.internal.sdk.common.geometry.NativeImageBuffer;
import com.scandit.datacapture.core.internal.sdk.source.NativeCameraCaptureParameters;
import com.scandit.datacapture.core.internal.sdk.source.NativeCameraFrameData;
import com.scandit.datacapture.core.internal.sdk.source.NativeCameraFrameDataPool;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001aI\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\b\u0013H\u0000\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0016"}, d2={"nv21BytesSize", "", "Lcom/scandit/datacapture/core/internal/sdk/common/geometry/NativeImageBuffer;", "getNv21BytesSize", "(Lcom/scandit/datacapture/core/internal/sdk/common/geometry/NativeImageBuffer;)I", "convertToFrameData", "Lcom/scandit/datacapture/core/internal/sdk/source/NativeCameraFrameData;", "Landroid/media/Image;", "buffers", "Lcom/scandit/datacapture/core/internal/module/source/FrameBufferStack;", "pool", "Lcom/scandit/datacapture/core/internal/sdk/source/NativeCameraFrameDataPool;", "captureDeviceOrientation", "isImageMirrored", "", "initParameters", "Lkotlin/Function1;", "Lcom/scandit/datacapture/core/internal/sdk/source/NativeCameraCaptureParameters;", "", "Lkotlin/ExtensionFunctionType;", "toNv21Bytes", "", "scandit-capture-core"})
public final class ImageExtensionsKt {
    public static final int getNv21BytesSize(@NotNull NativeImageBuffer $this$nv21BytesSize) {
        NativeImageBuffer nativeImageBuffer = $this$nv21BytesSize;
        Intrinsics.checkNotNullParameter((Object)nativeImageBuffer, (String)"<this>");
        int n3 = nativeImageBuffer.getWidth();
        return nativeImageBuffer.getHeight() * n3 * 12 / 8;
    }

    @NotNull
    public static final byte[] toNv21Bytes(@NotNull NativeImageBuffer $this$toNv21Bytes) {
        block7: {
            block8: {
                block9: {
                    block10: {
                        Rect rect;
                        NativeImageBuffer nativeImageBuffer;
                        NativeImageBuffer nativeImageBuffer2 = $this$toNv21Bytes;
                        Intrinsics.checkNotNullParameter((Object)nativeImageBuffer2, (String)"<this>");
                        ArrayList<ImagePlane> arrayList = nativeImageBuffer2.getPlanes();
                        if (!(arrayList.size() == 3)) break block7;
                        if (!(arrayList.get(0).getChannel() == Channel.Y)) break block8;
                        if (!(arrayList.get(1).getChannel() == Channel.U)) break block9;
                        if (!(arrayList.get(2).getChannel() == Channel.V)) break block10;
                        ArrayList<ImagePlane> arrayList2 = arrayList;
                        NativeImageBuffer nativeImageBuffer3 = nativeImageBuffer;
                        int n3 = nativeImageBuffer3.getWidth();
                        n3 = nativeImageBuffer3.getHeight() * n3;
                        Rect rect2 = rect;
                        NativeImageBuffer nativeImageBuffer4 = nativeImageBuffer;
                        int n4 = nativeImageBuffer4.getWidth();
                        int n5 = nativeImageBuffer4.getHeight();
                        rect = new Rect(0, 0, n4, n5);
                        byte[] byArray = new byte[ImageFormat.getBitsPerPixel((int)35) * n3 / 8];
                        Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"planes");
                        n5 = 0;
                        for (Object t3 : arrayList2) {
                            int n6;
                            block13: {
                                int n7;
                                int n8;
                                Rect rect3;
                                int n9;
                                int n10;
                                ImagePlane object;
                                block14: {
                                    block11: {
                                        block12: {
                                            n6 = n5 + 1;
                                            if (n5 < 0) {
                                                CollectionsKt.throwIndexOverflow();
                                            }
                                            object = (ImagePlane)t3;
                                            if (n5 == 0) break block11;
                                            if (n5 == 1) break block12;
                                            if (n5 != 2) break block13;
                                            n10 = 2;
                                            n9 = n3;
                                            break block14;
                                        }
                                        n10 = 2;
                                        n9 = n3 + 1;
                                        break block14;
                                    }
                                    n10 = 1;
                                    n9 = 0;
                                }
                                ImagePlane imagePlane = object;
                                ByteBuffer byteBuffer = imagePlane.getData();
                                int n11 = imagePlane.getPixelStride();
                                if (n5 == 0) {
                                    rect3 = rect2;
                                } else {
                                    Rect rect4;
                                    rect3 = rect4;
                                    Rect rect5 = rect2;
                                    n8 = rect5.top / 2;
                                    n7 = rect5.right / 2;
                                    int n12 = rect5.bottom / 2;
                                    rect4 = new Rect(rect2.left / 2, n8, n7, n12);
                                }
                                Rect rect6 = rect3;
                                n8 = rect6.width();
                                n7 = rect6.height();
                                byte[] n12 = new byte[object.getRowStride()];
                                int n13 = n11 == 1 && n10 == 1 ? n8 : (n8 - 1) * n11 + 1;
                                for (int i3 = 0; i3 < n7; ++i3) {
                                    ByteBuffer byteBuffer2 = byteBuffer;
                                    int n14 = i3 + rect3.top;
                                    n14 = object.getRowStride() * n14;
                                    byteBuffer2.position(rect3.left * n11 + n14);
                                    n14 = Integer.min(n13, byteBuffer2.limit() - byteBuffer.position());
                                    if (n11 == 1 && n10 == 1) {
                                        byteBuffer.get(byArray, n9, n14);
                                        n9 += n14;
                                        continue;
                                    }
                                    byteBuffer.get(n12, 0, n14);
                                    for (n14 = 0; n14 < n8; ++n14) {
                                        byArray[n9] = n12[n14 * n11];
                                        n9 += n10;
                                    }
                                }
                            }
                            n5 = n6;
                        }
                        return byArray;
                    }
                    throw new IllegalStateException("image buffer must contain YUV planes".toString());
                }
                throw new IllegalStateException("image buffer must contain YUV planes".toString());
            }
            throw new IllegalStateException("image buffer must contain YUV planes".toString());
        }
        throw new IllegalStateException("image buffer must contain YUV planes".toString());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final NativeCameraFrameData convertToFrameData(@NotNull Image $this$convertToFrameData, @NotNull FrameBufferStack buffers, @NotNull NativeCameraFrameDataPool pool, int captureDeviceOrientation, boolean isImageMirrored, @NotNull Function1<? super NativeCameraCaptureParameters, Unit> initParameters) {
        NativeCameraCaptureParameters nativeCameraCaptureParameters;
        void var2_2;
        Object object;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)object, (String)"buffers");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)nativeCameraCaptureParameters, (String)"initParameters");
        if (!buffers.a()) {
            void var3_3;
            void var4_4;
            Image image = byteBuffer;
            Object object2 = image.getPlanes()[0];
            Image.Plane plane = image.getPlanes()[1];
            Image.Plane plane2 = object2;
            void v22 = object;
            object = byteBuffer.getPlanes()[2];
            object2 = object2.getBuffer();
            Image image2 = byteBuffer;
            byteBuffer = plane.getBuffer();
            object = object.getBuffer();
            int n3 = image2.getWidth();
            int n4 = image2.getHeight();
            int n5 = object2.remaining();
            n5 = byteBuffer.remaining() + n5;
            byte[] byArray = v22.a(((Buffer)object).remaining() + n5);
            int n6 = plane.getPixelStride();
            int n7 = plane2.getRowStride();
            int n8 = plane.getRowStride();
            NativeAxis nativeAxis = var4_4 != false ? NativeAxis.Y : NativeAxis.NONE;
            void v4 = nativeCameraCaptureParameters;
            nativeCameraCaptureParameters = NativeCameraCaptureParameters.create();
            v4.invoke((Object)nativeCameraCaptureParameters);
            return NativeCameraFrameData.createNv21FrameData(n3, n4, byArray, (ByteBuffer)object2, byteBuffer, (ByteBuffer)object, n6, n7, n8, (NativeCameraFrameDataPool)var2_2, (int)var3_3, nativeAxis, nativeCameraCaptureParameters);
        }
        return null;
    }

    public static /* synthetic */ NativeCameraFrameData convertToFrameData$default(Image image, FrameBufferStack frameBufferStack, NativeCameraFrameDataPool nativeCameraFrameDataPool, int n3, boolean bl, Function1 function1, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            function1 = a.a;
        }
        return ImageExtensionsKt.convertToFrameData(image, frameBufferStack, nativeCameraFrameDataPool, n3, bl, (Function1<? super NativeCameraCaptureParameters, Unit>)function1);
    }
}

