/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.common.geometry;

import com.scandit.datacapture.core.common.geometry.Point;
import com.scandit.datacapture.core.common.geometry.Quadrilateral;
import com.scandit.datacapture.core.common.geometry.Size2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u0005\u001a\u00020\t*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\n\u001a\u00020\t*\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\r"}, d2={"center", "Lcom/scandit/datacapture/core/common/geometry/Point;", "Lcom/scandit/datacapture/core/common/geometry/Size2;", "getCenter", "(Lcom/scandit/datacapture/core/common/geometry/Size2;)Lcom/scandit/datacapture/core/common/geometry/Point;", "rotatedDegrees", "pivot", "degrees", "", "Lcom/scandit/datacapture/core/common/geometry/Quadrilateral;", "scaled", "scale", "", "sdc-core-android_release"})
public final class GeometryUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Point rotatedDegrees(@NotNull Point $this$rotatedDegrees, @NotNull Point pivot, int degrees) {
        void var1_1;
        Point point;
        void var2_2;
        Intrinsics.checkParameterIsNotNull((Object)$this$rotatedDegrees, (String)"$this$rotatedDegrees");
        Intrinsics.checkParameterIsNotNull((Object)pivot, (String)"pivot");
        double d2 = Math.toRadians((double)var2_2);
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = d4 * (double)($this$rotatedDegrees.x - pivot.x) - d3 * (double)($this$rotatedDegrees.y - pivot.y) + (double)pivot.x;
        double d6 = -d3 * (double)($this$rotatedDegrees.x - pivot.x) + d4 * (double)(point.y - pivot.y) + (double)var1_1.y;
        return new Point((float)d5, (float)d6);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Point scaled(@NotNull Point $this$scaled, float scale) {
        void var1_1;
        Point point;
        Intrinsics.checkParameterIsNotNull((Object)$this$scaled, (String)"$this$scaled");
        return new Point($this$scaled.x * scale, point.y * var1_1);
    }

    @NotNull
    public static final Point getCenter(@NotNull Size2 $this$center) {
        Size2 size2;
        Intrinsics.checkParameterIsNotNull((Object)$this$center, (String)"$this$center");
        return new Point($this$center.width / 2.0f, size2.height / 2.0f);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Quadrilateral rotatedDegrees(@NotNull Quadrilateral $this$rotatedDegrees, @NotNull Point pivot, int degrees) {
        void var2_2;
        void var1_1;
        Quadrilateral quadrilateral;
        Intrinsics.checkParameterIsNotNull((Object)$this$rotatedDegrees, (String)"$this$rotatedDegrees");
        Intrinsics.checkParameterIsNotNull((Object)pivot, (String)"pivot");
        Point point = $this$rotatedDegrees.topLeft;
        Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"topLeft");
        Point point2 = GeometryUtilsKt.rotatedDegrees(point, pivot, degrees);
        Point point3 = $this$rotatedDegrees.topRight;
        Intrinsics.checkExpressionValueIsNotNull((Object)point3, (String)"topRight");
        Point point4 = GeometryUtilsKt.rotatedDegrees(point3, pivot, degrees);
        Point point5 = $this$rotatedDegrees.bottomRight;
        Intrinsics.checkExpressionValueIsNotNull((Object)point5, (String)"bottomRight");
        Point point6 = GeometryUtilsKt.rotatedDegrees(point5, pivot, degrees);
        Point point7 = quadrilateral.bottomLeft;
        Intrinsics.checkExpressionValueIsNotNull((Object)point7, (String)"bottomLeft");
        return new Quadrilateral(point2, point4, point6, GeometryUtilsKt.rotatedDegrees(point7, (Point)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Quadrilateral scaled(@NotNull Quadrilateral $this$scaled, float scale) {
        void var1_1;
        Quadrilateral quadrilateral;
        Intrinsics.checkParameterIsNotNull((Object)$this$scaled, (String)"$this$scaled");
        Point point = $this$scaled.topLeft;
        Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"topLeft");
        Point point2 = GeometryUtilsKt.scaled(point, scale);
        Point point3 = $this$scaled.topRight;
        Intrinsics.checkExpressionValueIsNotNull((Object)point3, (String)"topRight");
        Point point4 = GeometryUtilsKt.scaled(point3, scale);
        Point point5 = $this$scaled.bottomRight;
        Intrinsics.checkExpressionValueIsNotNull((Object)point5, (String)"bottomRight");
        Point point6 = GeometryUtilsKt.scaled(point5, scale);
        Point point7 = quadrilateral.bottomLeft;
        Intrinsics.checkExpressionValueIsNotNull((Object)point7, (String)"bottomLeft");
        return new Quadrilateral(point2, point4, point6, GeometryUtilsKt.scaled(point7, (float)var1_1));
    }
}

