/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.generator;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.scandit.datacapture.barcode.generator.BarcodeGeneratorKt;
import com.scandit.datacapture.barcode.generator.BarcodeGeneratorOptions;
import com.scandit.datacapture.barcode.generator.BarcodeGeneratorProxy;
import com.scandit.datacapture.barcode.generator.BarcodeGeneratorProxyAdapter;
import com.scandit.datacapture.barcode.generator.QrCodeErrorCorrectionLevel;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGenerator;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGeneratorFactoryResult;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGeneratorGenerateResult;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGeneratorOptions;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGeneratorSymbology;
import com.scandit.datacapture.core.capture.DataCaptureContext;
import com.scandit.datacapture.core.common.graphic.ImageBuffer;
import com.scandit.datacapture.core.component.DataCaptureComponent;
import com.scandit.datacapture.core.internal.sdk.component.NativeDataCaptureComponent;
import com.scandit.datacapture.core.internal.sdk.extensions.CollectionsExtensionsKt;
import com.scandit.datacapture.tools.internal.sdk.NativeImpl;
import com.scandit.datacapture.tools.internal.sdk.ProxyFunction;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\n\u001a\u001b\u001c\u001d\u0019\u001e\u001f !\"B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\b\u001a\u00020\u0007H\u0097\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0003H\u0097\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00138WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator;", "Lcom/scandit/datacapture/core/component/DataCaptureComponent;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGeneratorProxy;", "Lcom/scandit/datacapture/barcode/internal/module/generator/NativeBarcodeGenerator;", "impl", "<init>", "(Lcom/scandit/datacapture/barcode/internal/module/generator/NativeBarcodeGenerator;)V", "Lcom/scandit/datacapture/core/internal/sdk/component/NativeDataCaptureComponent;", "_dataCaptureComponentImpl", "()Lcom/scandit/datacapture/core/internal/sdk/component/NativeDataCaptureComponent;", "_impl", "()Lcom/scandit/datacapture/barcode/internal/module/generator/NativeBarcodeGenerator;", "", "data", "", "imageWidth", "Landroid/graphics/Bitmap;", "generate", "([BI)Landroid/graphics/Bitmap;", "", "text", "(Ljava/lang/String;I)Landroid/graphics/Bitmap;", "getId", "()Ljava/lang/String;", "id", "Companion", "AztecBarcodeGeneratorBuilder", "BarcodeGeneratorBuilder", "Code128BarcodeGeneratorBuilder", "Code39BarcodeGeneratorBuilder", "DataMatrixBarcodeGeneratorBuilder", "Ean13BarcodeGeneratorBuilder", "InterleavedTwoOfFiveBarcodeGeneratorBuilder", "QrCodeBarcodeGeneratorBuilder", "UpcaBarcodeGeneratorBuilder", "scandit-barcode-capture"}, xi=48)
public final class BarcodeGenerator
implements DataCaptureComponent,
BarcodeGeneratorProxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ BarcodeGeneratorProxyAdapter a;

    /*
     * WARNING - void declaration
     */
    public BarcodeGenerator(@NotNull NativeBarcodeGenerator impl) {
        BarcodeGeneratorProxyAdapter barcodeGeneratorProxyAdapter;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"impl");
        BarcodeGeneratorProxy this_ = barcodeGeneratorProxyAdapter;
        barcodeGeneratorProxyAdapter = new BarcodeGeneratorProxyAdapter((NativeBarcodeGenerator)var1_1, null, 2, null);
        v1.a = this_;
    }

    @JvmStatic
    @NotNull
    public static final Code39BarcodeGeneratorBuilder code39BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.code39BarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final Code128BarcodeGeneratorBuilder code128BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.code128BarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final Ean13BarcodeGeneratorBuilder ean13BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.ean13BarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final UpcaBarcodeGeneratorBuilder upcaBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.upcaBarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final InterleavedTwoOfFiveBarcodeGeneratorBuilder interleavedTwoOfFiveBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.interleavedTwoOfFiveBarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final QrCodeBarcodeGeneratorBuilder qrCodeBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.qrCodeBarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final DataMatrixBarcodeGeneratorBuilder dataMatrixBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.dataMatrixBarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final AztecBarcodeGeneratorBuilder aztecBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.aztecBarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @Override
    @ProxyFunction(nativeName="getIdentifier", property="id")
    @NotNull
    public String getId() {
        return this.a.getId();
    }

    @Override
    @NativeImpl
    @NotNull
    public NativeDataCaptureComponent _dataCaptureComponentImpl() {
        return this.a._dataCaptureComponentImpl();
    }

    @Override
    @NativeImpl
    @NotNull
    public NativeBarcodeGenerator _impl() {
        return this.a._impl();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap generate(@NotNull byte[] data, int imageWidth) {
        block10: {
            Object object;
            block9: {
                void var2_6;
                ArrayList arrayList;
                Object object2;
                block8: {
                    ImageBuffer imageBuffer;
                    BarcodeGenerator barcodeGenerator = this_;
                    Intrinsics.checkNotNullParameter((Object)object2, (String)"data");
                    Object this_ = CollectionsKt.emptyList();
                    this_ = barcodeGenerator._impl().generate((byte[])object2, CollectionsExtensionsKt.toArrayList((Iterable)this_));
                    if (!((NativeBarcodeGeneratorGenerateResult)this_).ok()) {
                        this_ = ((NativeBarcodeGeneratorGenerateResult)this_).error();
                        Intrinsics.checkNotNull((Object)this_);
                        if (StringsKt.contains((CharSequence)this_, (CharSequence)"Invalid input", (boolean)true)) {
                            IllegalArgumentException illegalArgumentException;
                            object2 = illegalArgumentException;
                            illegalArgumentException = new IllegalArgumentException((String)this_);
                        } else {
                            RuntimeException runtimeException;
                            object2 = runtimeException;
                            runtimeException = new RuntimeException((String)this_);
                        }
                        throw object2;
                    }
                    this_ = ((NativeBarcodeGeneratorGenerateResult)this_).value().getImageBuffer();
                    object2 = imageBuffer;
                    Object object3 = this_;
                    int n2 = object3.getWidth();
                    int n3 = object3.getHeight();
                    arrayList = object3.getPlanes();
                    Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"getPlanes(...)");
                    if (var2_6 != new ImageBuffer(n2, n3, arrayList).getWidth()) break block8;
                    object = object2.toBitmap();
                    break block9;
                }
                if (var2_6 <= 0) break block10;
                float f2 = (float)object2.getWidth() / (float)object2.getHeight();
                float f3 = (float)var2_6;
                int n4 = (int)(f3 / f2);
                if (var2_6 < object2.getWidth()) {
                    object = Bitmap.createScaledBitmap((Bitmap)object2.toBitmap(), (int)var2_6, (int)n4, (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createScaledBitmap(...)");
                } else {
                    RectF rectF;
                    Paint paint;
                    arrayList = BarcodeGeneratorKt.access$toBitmap(object2, (int)var2_6, n4);
                    int n5 = (int)Math.ceil(f3 / (float)object2.getWidth());
                    Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)arrayList, (int)(object2.getWidth() * n5), (int)(object2.getHeight() * n5), (boolean)false);
                    object2 = bitmap;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"createScaledBitmap(...)");
                    arrayList.reconfigure((int)var2_6, n4, Bitmap.Config.ARGB_8888);
                    object = paint;
                    new Paint().setFilterBitmap(true);
                    object2 = rectF;
                    ArrayList arrayList2 = arrayList;
                    float f4 = arrayList2.getWidth();
                    float f5 = arrayList2.getHeight();
                    rectF = new RectF(0.0f, 0.0f, f4, f5);
                    new Canvas((Bitmap)arrayList).drawBitmap((Bitmap)object2, null, (RectF)object2, (Paint)object);
                    bitmap.recycle();
                    object = arrayList;
                }
            }
            return object;
        }
        throw new IllegalStateException("Image width should be bigger than zero!");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap generate(@NotNull String text, int imageWidth) {
        void var2_2;
        void var1_1;
        void v02 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v02, (String)"text");
        byte[] byArray = v02.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.generate(byArray, (int)var2_2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\f"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$AztecBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$QrCodeBarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "withLayers", "layers", "", "(Ljava/lang/Integer;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$AztecBarcodeGeneratorBuilder;", "withMinimumErrorCorrectionPercent", "minimumErrorCorrectionPercent", "scandit-barcode-capture"})
    public static final class AztecBarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<QrCodeBarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public AztecBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, NativeBarcodeGeneratorSymbology.AZTEC);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AztecBarcodeGeneratorBuilder withMinimumErrorCorrectionPercent(@Nullable Integer minimumErrorCorrectionPercent) {
            void var1_1;
            AztecBarcodeGeneratorBuilder aztecBarcodeGeneratorBuilder = this;
            aztecBarcodeGeneratorBuilder.getOptions$scandit_barcode_capture().setMinimumErrorCorrectionPercent$scandit_barcode_capture((Integer)var1_1);
            return aztecBarcodeGeneratorBuilder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AztecBarcodeGeneratorBuilder withLayers(@Nullable Integer layers) {
            void var1_1;
            AztecBarcodeGeneratorBuilder aztecBarcodeGeneratorBuilder = this;
            aztecBarcodeGeneratorBuilder.getOptions$scandit_barcode_capture().setLayers$scandit_barcode_capture((Integer)var1_1);
            return aztecBarcodeGeneratorBuilder;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001 \u0001*\b\u0012\u0004\u0012\u00028\u00000\u00002\u00020\u0002B\u0019\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0017\u001a\u00020\u00128\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "BuilderType", "", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "dataCaptureContext", "Lcom/scandit/datacapture/barcode/internal/module/generator/NativeBarcodeGeneratorSymbology;", "symbology", "<init>", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;Lcom/scandit/datacapture/barcode/internal/module/generator/NativeBarcodeGeneratorSymbology;)V", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator;", "build", "()Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator;", "", "backgroundColor", "withBackgroundColor", "(I)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "foregroundColor", "withForegroundColor", "Lcom/scandit/datacapture/barcode/generator/BarcodeGeneratorOptions;", "c", "Lcom/scandit/datacapture/barcode/generator/BarcodeGeneratorOptions;", "getOptions$scandit_barcode_capture", "()Lcom/scandit/datacapture/barcode/generator/BarcodeGeneratorOptions;", "options", "scandit-barcode-capture"}, xi=48)
    public static abstract class BarcodeGeneratorBuilder<BuilderType extends BarcodeGeneratorBuilder<? extends BuilderType>> {
        private final DataCaptureContext a;
        private final NativeBarcodeGeneratorSymbology b;
        private final BarcodeGeneratorOptions c;

        /*
         * WARNING - void declaration
         */
        public BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext, @NotNull NativeBarcodeGeneratorSymbology symbology) {
            void var2_2;
            void var1_1;
            BarcodeGeneratorBuilder barcodeGeneratorBuilder = this;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"symbology");
            this.a = var1_1;
            barcodeGeneratorBuilder.b = var2_2;
            barcodeGeneratorBuilder.c = com.scandit.datacapture.barcode.generator.BarcodeGenerator$Companion.access$createDefaultOptions(Companion, (NativeBarcodeGeneratorSymbology)var2_2);
        }

        @NotNull
        public final BarcodeGeneratorOptions getOptions$scandit_barcode_capture() {
            return this.c;
        }

        @NotNull
        public final BarcodeGenerator build() {
            BarcodeGeneratorBuilder barcodeGeneratorBuilder = barcodeGeneratorBuilder2;
            BarcodeGeneratorBuilder barcodeGeneratorBuilder2 = barcodeGeneratorBuilder.a;
            NativeBarcodeGeneratorSymbology nativeBarcodeGeneratorSymbology = barcodeGeneratorBuilder.b;
            BarcodeGeneratorOptions barcodeGeneratorOptions = barcodeGeneratorBuilder.c;
            return com.scandit.datacapture.barcode.generator.BarcodeGenerator$Companion.access$create(Companion, (DataCaptureContext)barcodeGeneratorBuilder2, nativeBarcodeGeneratorSymbology, barcodeGeneratorOptions);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BuilderType withBackgroundColor(int backgroundColor) {
            void var1_1;
            BarcodeGeneratorBuilder barcodeGeneratorBuilder = this;
            barcodeGeneratorBuilder.c.setBackgroundColor$scandit_barcode_capture((int)var1_1);
            Intrinsics.checkNotNull((Object)barcodeGeneratorBuilder, (String)"null cannot be cast to non-null type BuilderType of com.scandit.datacapture.barcode.generator.BarcodeGenerator.BarcodeGeneratorBuilder");
            return (BuilderType)barcodeGeneratorBuilder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BuilderType withForegroundColor(int foregroundColor) {
            void var1_1;
            BarcodeGeneratorBuilder barcodeGeneratorBuilder = this;
            barcodeGeneratorBuilder.c.setForegroundColor$scandit_barcode_capture((int)var1_1);
            Intrinsics.checkNotNull((Object)barcodeGeneratorBuilder, (String)"null cannot be cast to non-null type BuilderType of com.scandit.datacapture.barcode.generator.BarcodeGenerator.BarcodeGeneratorBuilder");
            return (BuilderType)barcodeGeneratorBuilder;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code128BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class Code128BarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<Code128BarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public Code128BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, NativeBarcodeGeneratorSymbology.CODE128);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code39BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class Code39BarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<Code39BarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public Code39BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, NativeBarcodeGeneratorSymbology.CODE39);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Companion;", "", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "dataCaptureContext", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code39BarcodeGeneratorBuilder;", "code39BarcodeGeneratorBuilder", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code39BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code128BarcodeGeneratorBuilder;", "code128BarcodeGeneratorBuilder", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code128BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Ean13BarcodeGeneratorBuilder;", "ean13BarcodeGeneratorBuilder", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Ean13BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$UpcaBarcodeGeneratorBuilder;", "upcaBarcodeGeneratorBuilder", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$UpcaBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$InterleavedTwoOfFiveBarcodeGeneratorBuilder;", "interleavedTwoOfFiveBarcodeGeneratorBuilder", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$InterleavedTwoOfFiveBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$QrCodeBarcodeGeneratorBuilder;", "qrCodeBarcodeGeneratorBuilder", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$QrCodeBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$DataMatrixBarcodeGeneratorBuilder;", "dataMatrixBarcodeGeneratorBuilder", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$DataMatrixBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$AztecBarcodeGeneratorBuilder;", "aztecBarcodeGeneratorBuilder", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$AztecBarcodeGeneratorBuilder;", "scandit-barcode-capture"}, xi=48)
    public static final class Companion {
        public static final BarcodeGeneratorOptions access$createDefaultOptions(Companion $this, NativeBarcodeGeneratorSymbology symbology) {
            Companion companion;
            companion.getClass();
            NativeBarcodeGeneratorOptions nativeBarcodeGeneratorOptions = NativeBarcodeGenerator.createDefaultOptions(symbology);
            Intrinsics.checkNotNullExpressionValue((Object)nativeBarcodeGeneratorOptions, (String)"createDefaultOptions(...)");
            return BarcodeGeneratorKt.access$toApi(nativeBarcodeGeneratorOptions);
        }

        /*
         * WARNING - void declaration
         */
        public static final BarcodeGenerator access$create(Companion $this, DataCaptureContext dataCaptureContext, NativeBarcodeGeneratorSymbology symbology, BarcodeGeneratorOptions options) {
            void var3_3;
            void var2_2;
            Object object;
            object.getClass();
            object = NativeBarcodeGenerator.create(dataCaptureContext._impl(), (NativeBarcodeGeneratorSymbology)var2_2, BarcodeGeneratorKt.toNativeOptions((BarcodeGeneratorOptions)var3_3));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
            if (((NativeBarcodeGeneratorFactoryResult)object).ok()) {
                object = ((NativeBarcodeGeneratorFactoryResult)object).value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
                return new BarcodeGenerator((NativeBarcodeGenerator)object);
            }
            throw new InvalidParameterException(((NativeBarcodeGeneratorFactoryResult)object).error());
        }

        public Companion(DefaultConstructorMarker $constructor_marker) {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Code39BarcodeGeneratorBuilder code39BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new Code39BarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Code128BarcodeGeneratorBuilder code128BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new Code128BarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Ean13BarcodeGeneratorBuilder ean13BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new Ean13BarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final UpcaBarcodeGeneratorBuilder upcaBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new UpcaBarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final InterleavedTwoOfFiveBarcodeGeneratorBuilder interleavedTwoOfFiveBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new InterleavedTwoOfFiveBarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final QrCodeBarcodeGeneratorBuilder qrCodeBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new QrCodeBarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final DataMatrixBarcodeGeneratorBuilder dataMatrixBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new DataMatrixBarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final AztecBarcodeGeneratorBuilder aztecBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new AztecBarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$DataMatrixBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class DataMatrixBarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<DataMatrixBarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public DataMatrixBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, NativeBarcodeGeneratorSymbology.DATA_MATRIX);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Ean13BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class Ean13BarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<Ean13BarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public Ean13BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, NativeBarcodeGeneratorSymbology.EAN13);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$InterleavedTwoOfFiveBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class InterleavedTwoOfFiveBarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<InterleavedTwoOfFiveBarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public InterleavedTwoOfFiveBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, NativeBarcodeGeneratorSymbology.INTERLEAVED_TWO_OF_FIVE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$QrCodeBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "withErrorCorrectionLevel", "errorCorrectionLevel", "Lcom/scandit/datacapture/barcode/generator/QrCodeErrorCorrectionLevel;", "withVersionNumber", "versionNumber", "", "scandit-barcode-capture"})
    public static final class QrCodeBarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<QrCodeBarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public QrCodeBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, NativeBarcodeGeneratorSymbology.QR);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final QrCodeBarcodeGeneratorBuilder withErrorCorrectionLevel(@NotNull QrCodeErrorCorrectionLevel errorCorrectionLevel) {
            void var1_1;
            QrCodeBarcodeGeneratorBuilder qrCodeBarcodeGeneratorBuilder = this;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"errorCorrectionLevel");
            qrCodeBarcodeGeneratorBuilder.getOptions$scandit_barcode_capture().setErrorCorrectionLevel$scandit_barcode_capture((QrCodeErrorCorrectionLevel)var1_1);
            return qrCodeBarcodeGeneratorBuilder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final QrCodeBarcodeGeneratorBuilder withVersionNumber(int versionNumber) {
            void var1_1;
            QrCodeBarcodeGeneratorBuilder qrCodeBarcodeGeneratorBuilder = this;
            qrCodeBarcodeGeneratorBuilder.getOptions$scandit_barcode_capture().setVersionNumber$scandit_barcode_capture((int)var1_1);
            return qrCodeBarcodeGeneratorBuilder;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$UpcaBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class UpcaBarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<UpcaBarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public UpcaBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, NativeBarcodeGeneratorSymbology.UPCA);
        }
    }
}

