/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.tracking.impl.serialization;

import com.scandit.datacapture.barcode.tracking.impl.capture.NativeBarcodeTracking;
import com.scandit.datacapture.barcode.tracking.impl.capture.NativeBarcodeTrackingSettings;
import com.scandit.datacapture.barcode.tracking.impl.serialization.NativeBarcodeTrackingDeserializerHelper;
import com.scandit.datacapture.barcode.tracking.impl.serialization.NativeBarcodeTrackingDeserializerListener;
import com.scandit.datacapture.barcode.tracking.impl.ui.overlay.NativeBarcodeTrackingBasicOverlay;
import com.scandit.datacapture.core.impl.capture.NativeDataCaptureContext;
import com.scandit.datacapture.core.impl.json.NativeJsonValue;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeTrackingDeserializer {
    public abstract NativeBarcodeTracking modeFromJson(NativeDataCaptureContext var1, NativeJsonValue var2);

    public abstract NativeBarcodeTracking updateModeFromJson(NativeBarcodeTracking var1, NativeJsonValue var2);

    public abstract NativeBarcodeTrackingSettings settingsFromJson(NativeJsonValue var1);

    public abstract NativeBarcodeTrackingSettings updateSettingsFromJson(NativeBarcodeTrackingSettings var1, NativeJsonValue var2);

    public abstract NativeBarcodeTrackingBasicOverlay basicOverlayFromJson(NativeBarcodeTracking var1, NativeJsonValue var2);

    public abstract NativeBarcodeTrackingBasicOverlay updateBasicOverlayFromJson(NativeBarcodeTrackingBasicOverlay var1, NativeJsonValue var2);

    public abstract void setHelper(NativeBarcodeTrackingDeserializerHelper var1);

    public abstract NativeBarcodeTrackingDeserializerHelper getHelper();

    public abstract void setListener(NativeBarcodeTrackingDeserializerListener var1);

    public abstract ArrayList<String> getWarnings();

    public static NativeBarcodeTrackingDeserializer create() {
        return CppProxy.create();
    }

    private static final class CppProxy
    extends NativeBarcodeTrackingDeserializer {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public NativeBarcodeTracking modeFromJson(NativeDataCaptureContext context, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_modeFromJson(this.nativeRef, context, json);
        }

        private native NativeBarcodeTracking native_modeFromJson(long var1, NativeDataCaptureContext var3, NativeJsonValue var4);

        @Override
        public NativeBarcodeTracking updateModeFromJson(NativeBarcodeTracking mode, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_updateModeFromJson(this.nativeRef, mode, json);
        }

        private native NativeBarcodeTracking native_updateModeFromJson(long var1, NativeBarcodeTracking var3, NativeJsonValue var4);

        @Override
        public NativeBarcodeTrackingSettings settingsFromJson(NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_settingsFromJson(this.nativeRef, json);
        }

        private native NativeBarcodeTrackingSettings native_settingsFromJson(long var1, NativeJsonValue var3);

        @Override
        public NativeBarcodeTrackingSettings updateSettingsFromJson(NativeBarcodeTrackingSettings settings, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_updateSettingsFromJson(this.nativeRef, settings, json);
        }

        private native NativeBarcodeTrackingSettings native_updateSettingsFromJson(long var1, NativeBarcodeTrackingSettings var3, NativeJsonValue var4);

        @Override
        public NativeBarcodeTrackingBasicOverlay basicOverlayFromJson(NativeBarcodeTracking mode, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_basicOverlayFromJson(this.nativeRef, mode, json);
        }

        private native NativeBarcodeTrackingBasicOverlay native_basicOverlayFromJson(long var1, NativeBarcodeTracking var3, NativeJsonValue var4);

        @Override
        public NativeBarcodeTrackingBasicOverlay updateBasicOverlayFromJson(NativeBarcodeTrackingBasicOverlay overlay, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_updateBasicOverlayFromJson(this.nativeRef, overlay, json);
        }

        private native NativeBarcodeTrackingBasicOverlay native_updateBasicOverlayFromJson(long var1, NativeBarcodeTrackingBasicOverlay var3, NativeJsonValue var4);

        @Override
        public void setHelper(NativeBarcodeTrackingDeserializerHelper helper) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setHelper(this.nativeRef, helper);
        }

        private native void native_setHelper(long var1, NativeBarcodeTrackingDeserializerHelper var3);

        @Override
        public NativeBarcodeTrackingDeserializerHelper getHelper() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getHelper(this.nativeRef);
        }

        private native NativeBarcodeTrackingDeserializerHelper native_getHelper(long var1);

        @Override
        public void setListener(NativeBarcodeTrackingDeserializerListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setListener(this.nativeRef, listener);
        }

        private native void native_setListener(long var1, NativeBarcodeTrackingDeserializerListener var3);

        @Override
        public ArrayList<String> getWarnings() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getWarnings(this.nativeRef);
        }

        private native ArrayList<String> native_getWarnings(long var1);

        public static native NativeBarcodeTrackingDeserializer create();
    }
}

