/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.impl.serialization;

import com.scandit.datacapture.barcode.impl.capture.NativeBarcodeCapture;
import com.scandit.datacapture.barcode.impl.capture.NativeBarcodeCaptureSettings;
import com.scandit.datacapture.barcode.impl.serialization.NativeBarcodeCaptureDeserializerHelper;
import com.scandit.datacapture.barcode.impl.serialization.NativeBarcodeCaptureDeserializerListener;
import com.scandit.datacapture.barcode.impl.ui.NativeBarcodeCaptureOverlay;
import com.scandit.datacapture.core.impl.capture.NativeDataCaptureContext;
import com.scandit.datacapture.core.impl.json.NativeJsonValue;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeCaptureDeserializer {
    public abstract NativeBarcodeCapture modeFromJson(NativeDataCaptureContext var1, NativeJsonValue var2);

    public abstract NativeBarcodeCapture updateModeFromJson(NativeBarcodeCapture var1, NativeJsonValue var2);

    public abstract NativeBarcodeCaptureSettings settingsFromJson(NativeJsonValue var1);

    public abstract NativeBarcodeCaptureSettings updateSettingsFromJson(NativeBarcodeCaptureSettings var1, NativeJsonValue var2);

    public abstract NativeBarcodeCaptureOverlay overlayFromJson(NativeBarcodeCapture var1, NativeJsonValue var2);

    public abstract NativeBarcodeCaptureOverlay updateOverlayFromJson(NativeBarcodeCaptureOverlay var1, NativeJsonValue var2);

    public abstract void setHelper(NativeBarcodeCaptureDeserializerHelper var1);

    public abstract NativeBarcodeCaptureDeserializerHelper getHelper();

    public abstract void setListener(NativeBarcodeCaptureDeserializerListener var1);

    public abstract ArrayList<String> getWarnings();

    public static NativeBarcodeCaptureDeserializer create() {
        return CppProxy.create();
    }

    private static final class CppProxy
    extends NativeBarcodeCaptureDeserializer {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public NativeBarcodeCapture modeFromJson(NativeDataCaptureContext context, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_modeFromJson(this.nativeRef, context, json);
        }

        private native NativeBarcodeCapture native_modeFromJson(long var1, NativeDataCaptureContext var3, NativeJsonValue var4);

        @Override
        public NativeBarcodeCapture updateModeFromJson(NativeBarcodeCapture mode, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_updateModeFromJson(this.nativeRef, mode, json);
        }

        private native NativeBarcodeCapture native_updateModeFromJson(long var1, NativeBarcodeCapture var3, NativeJsonValue var4);

        @Override
        public NativeBarcodeCaptureSettings settingsFromJson(NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_settingsFromJson(this.nativeRef, json);
        }

        private native NativeBarcodeCaptureSettings native_settingsFromJson(long var1, NativeJsonValue var3);

        @Override
        public NativeBarcodeCaptureSettings updateSettingsFromJson(NativeBarcodeCaptureSettings settings, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_updateSettingsFromJson(this.nativeRef, settings, json);
        }

        private native NativeBarcodeCaptureSettings native_updateSettingsFromJson(long var1, NativeBarcodeCaptureSettings var3, NativeJsonValue var4);

        @Override
        public NativeBarcodeCaptureOverlay overlayFromJson(NativeBarcodeCapture mode, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_overlayFromJson(this.nativeRef, mode, json);
        }

        private native NativeBarcodeCaptureOverlay native_overlayFromJson(long var1, NativeBarcodeCapture var3, NativeJsonValue var4);

        @Override
        public NativeBarcodeCaptureOverlay updateOverlayFromJson(NativeBarcodeCaptureOverlay overlay, NativeJsonValue json) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_updateOverlayFromJson(this.nativeRef, overlay, json);
        }

        private native NativeBarcodeCaptureOverlay native_updateOverlayFromJson(long var1, NativeBarcodeCaptureOverlay var3, NativeJsonValue var4);

        @Override
        public void setHelper(NativeBarcodeCaptureDeserializerHelper helper) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setHelper(this.nativeRef, helper);
        }

        private native void native_setHelper(long var1, NativeBarcodeCaptureDeserializerHelper var3);

        @Override
        public NativeBarcodeCaptureDeserializerHelper getHelper() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getHelper(this.nativeRef);
        }

        private native NativeBarcodeCaptureDeserializerHelper native_getHelper(long var1);

        @Override
        public void setListener(NativeBarcodeCaptureDeserializerListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setListener(this.nativeRef, listener);
        }

        private native void native_setListener(long var1, NativeBarcodeCaptureDeserializerListener var3);

        @Override
        public ArrayList<String> getWarnings() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getWarnings(this.nativeRef);
        }

        private native ArrayList<String> native_getWarnings(long var1);

        public static native NativeBarcodeCaptureDeserializer create();
    }
}

