/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.impl.capture;

import com.scandit.datacapture.barcode.impl.data.NativeBarcode;
import com.scandit.datacapture.barcode.impl.data.NativeLocalizedOnlyBarcode;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeCaptureSession {
    public abstract ArrayList<NativeBarcode> getNewlyRecognizedBarcodes();

    public abstract ArrayList<NativeLocalizedOnlyBarcode> getNewlyLocalizedBarcodes();

    public abstract void clear();

    private static final class CppProxy
    extends NativeBarcodeCaptureSession {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public ArrayList<NativeBarcode> getNewlyRecognizedBarcodes() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getNewlyRecognizedBarcodes(this.nativeRef);
        }

        private native ArrayList<NativeBarcode> native_getNewlyRecognizedBarcodes(long var1);

        @Override
        public ArrayList<NativeLocalizedOnlyBarcode> getNewlyLocalizedBarcodes() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getNewlyLocalizedBarcodes(this.nativeRef);
        }

        private native ArrayList<NativeLocalizedOnlyBarcode> native_getNewlyLocalizedBarcodes(long var1);

        @Override
        public void clear() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_clear(this.nativeRef);
        }

        private native void native_clear(long var1);
    }
}

