/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.model.accounts;

import java.util.HashMap;
import java.util.Map;

public class UpdateUser {
    public String userID;
    public String firstName;
    public String lastName;
    public String phone;

    private UpdateUser(Builder builder) {
        this.userID = builder.userID;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phone = builder.phone;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.firstName != null) {
            parameters.put("first_name", this.firstName);
        }
        if (this.lastName != null) {
            parameters.put("last_name", this.lastName);
        }
        if (this.phone != null) {
            parameters.put("phone", this.phone);
        }
        return parameters;
    }

    public static final class Builder {
        private String userID;
        private String firstName;
        private String lastName;
        private String phone;

        public Builder setUserID(String val) {
            this.userID = val;
            return this;
        }

        public Builder setFirstName(String val) {
            this.firstName = val;
            return this;
        }

        public Builder setLastName(String val) {
            this.lastName = val;
            return this;
        }

        public Builder setPhone(String val) {
            this.phone = val;
            return this;
        }

        public UpdateUser build() {
            if (this.phone != null && !this.phone.matches("^\\+?1?\\d{8,15}$")) {
                throw new IllegalArgumentException("Phone number must be in international format, e.g. +1 1234567890");
            }
            return new UpdateUser(this);
        }
    }
}

