/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.model.accounts;

import com.saucelabs.saucerest.model.accounts.Roles;
import java.util.HashMap;
import java.util.Map;

public class CreateUser {
    public String firstName;
    public String lastName;
    public String email;
    public String userName;
    public String password;
    public String organization;
    public Integer role;
    public String team;

    private CreateUser(Builder builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.email = builder.email;
        this.userName = builder.userName;
        this.password = builder.password;
        this.organization = builder.organization;
        this.role = builder.role;
        this.team = builder.team;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.firstName != null) {
            parameters.put("first_name", this.firstName);
        }
        if (this.lastName != null) {
            parameters.put("last_name", this.lastName);
        }
        if (this.email != null) {
            parameters.put("email", this.email);
        }
        if (this.userName != null) {
            parameters.put("username", this.userName);
        }
        if (this.password != null) {
            parameters.put("password", this.password);
        }
        if (this.organization != null) {
            parameters.put("organization", this.organization);
        }
        if (this.role != null) {
            parameters.put("role", this.role);
        }
        if (this.team != null) {
            parameters.put("team", this.team);
        }
        return parameters;
    }

    public static final class Builder {
        private String firstName;
        private String lastName;
        private String email;
        private String userName;
        private String password;
        private String organization;
        private Integer role;
        private String team;

        public Builder setFirstName(String val) {
            this.firstName = val;
            return this;
        }

        public Builder setLastName(String val) {
            this.lastName = val;
            return this;
        }

        public Builder setEmail(String val) {
            this.email = val;
            return this;
        }

        public Builder setUserName(String val) {
            this.userName = val;
            return this;
        }

        public Builder setPassword(String val) {
            this.password = val;
            return this;
        }

        public Builder setOrganization(String val) {
            this.organization = val;
            return this;
        }

        public Builder setRole(Roles val) {
            this.role = val.getValue();
            return this;
        }

        public Builder setTeam(String val) {
            this.team = val;
            return this;
        }

        public CreateUser build() {
            this.checkParameter();
            return new CreateUser(this);
        }

        private void checkParameter() {
            if (this.firstName == null || this.firstName.isEmpty()) {
                throw new IllegalArgumentException("First name is required");
            }
            if (this.lastName == null || this.lastName.isEmpty()) {
                throw new IllegalArgumentException("Last name is required");
            }
            if (this.email == null || this.email.isEmpty()) {
                throw new IllegalArgumentException("Email is required");
            }
            if (this.userName == null || this.userName.isEmpty()) {
                throw new IllegalArgumentException("Username is required");
            }
            if (this.password == null || this.password.isEmpty()) {
                throw new IllegalArgumentException("Password is required");
            }
            if (this.password.length() <= 8) {
                throw new IllegalArgumentException("Password must be at least 8 characters");
            }
            if (!this.password.matches(".*[0-9].*")) {
                throw new IllegalArgumentException("Password must contain at least one number");
            }
            if (!this.password.matches(".*[A-Z].*")) {
                throw new IllegalArgumentException("Password must contain at least one uppercase letter");
            }
            if (!this.password.matches(".*[a-z].*")) {
                throw new IllegalArgumentException("Password must contain at least one lowercase letter");
            }
            if (!this.password.matches(".*[!@#$%^&*()_+\\-=\\[\\]{};':\"\\\\|,.<>\\/?].*")) {
                throw new IllegalArgumentException("Password must contain at least one special character");
            }
            if (this.password.matches(".*\\s.*")) {
                throw new IllegalArgumentException("Password must not contain any whitespace");
            }
            if (this.organization == null || this.organization.isEmpty()) {
                throw new IllegalArgumentException("Organization is required");
            }
            if (this.role == null) {
                throw new IllegalArgumentException("Role is required");
            }
        }
    }
}

