/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.sauceconnect.JobsForATunnel;
import com.saucelabs.saucerest.model.sauceconnect.StopTunnel;
import com.saucelabs.saucerest.model.sauceconnect.TunnelInformation;
import com.saucelabs.saucerest.model.sauceconnect.Versions;
import java.io.IOException;
import java.util.List;

public class SauceConnect
extends AbstractEndpoint {
    public SauceConnect(DataCenter dataCenter) {
        super(dataCenter);
    }

    public SauceConnect(String apiServer) {
        super(apiServer);
    }

    public SauceConnect(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    public SauceConnect(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public List<String> getTunnelsForAUser() throws IOException {
        return this.getTunnelsForAUser(this.username);
    }

    public List<String> getTunnelsForAUser(String username) throws IOException {
        String url = this.getBaseEndpoint() + username + "/tunnels";
        return this.deserializeJSONArray(this.getResponseObject(url), String.class);
    }

    public TunnelInformation getTunnelInformation(String username, String tunnelID) throws IOException {
        String url = this.getBaseEndpoint() + username + "/tunnels/" + tunnelID;
        return this.deserializeJSONObject(this.getResponseObject(url), TunnelInformation.class);
    }

    public TunnelInformation getTunnelInformation(String tunnelID) throws IOException {
        return this.getTunnelInformation(this.username, tunnelID);
    }

    public JobsForATunnel getCurrentJobsForATunnel(String username, String tunnelID) throws IOException {
        String url = this.getBaseEndpoint() + username + "/tunnels/" + tunnelID + "/num_jobs";
        return this.deserializeJSONObject(this.getResponseObject(url), JobsForATunnel.class);
    }

    public JobsForATunnel getCurrentJobsForATunnel(String tunnelID) throws IOException {
        return this.getCurrentJobsForATunnel(this.username, tunnelID);
    }

    public StopTunnel stopTunnel(String username, String tunnelID) throws IOException {
        String url = this.getBaseEndpoint() + username + "/tunnels/" + tunnelID;
        return this.deserializeJSONObject(this.request(url, HttpMethod.DELETE).body().string(), StopTunnel.class);
    }

    public StopTunnel stopTunnel(String tunnelID) throws IOException {
        return this.stopTunnel(this.username, tunnelID);
    }

    public Versions getLatestVersions() throws IOException {
        String url = this.getBaseEndpoint() + "public/tunnels/info/versions";
        return this.deserializeJSONObject(this.getResponseObject(url), Versions.class);
    }

    @Override
    public String getBaseEndpoint() {
        return super.getBaseEndpoint() + "rest/v1/";
    }
}

