/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.google.common.collect.ImmutableMap;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.JobVisibility;
import com.saucelabs.saucerest.TestAsset;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.awaitility.Awaitility;
import org.json.JSONObject;

public class Job
extends AbstractEndpoint {
    private final String jobID;

    public Job(DataCenter dataCenter, String sessionId) {
        super(dataCenter);
        this.jobID = sessionId;
    }

    public Job(String apiServer, String sessionId) {
        super(apiServer);
        this.jobID = sessionId;
    }

    public Job(String username, String accessKey, DataCenter dataCenter, String sessionId) {
        super(username, accessKey, dataCenter);
        this.jobID = sessionId;
    }

    public Job(String username, String accessKey, String apiServer, String sessionId) {
        super(username, accessKey, apiServer);
        this.jobID = sessionId;
    }

    public JSONObject getDetails() throws IOException {
        return new JSONObject(this.getResponseObject(this.getBaseEndpoint()));
    }

    public JSONObject changeName(String testName) throws IOException {
        return this.updateDetails((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)testName));
    }

    public JSONObject changeBuild(String buildName) throws IOException {
        return this.updateDetails((Map<String, Object>)ImmutableMap.of((Object)"build", (Object)buildName));
    }

    public JSONObject changeVisibility(JobVisibility visibility) throws IOException {
        return this.updateDetails((Map<String, Object>)ImmutableMap.of((Object)"public", (Object)visibility.value));
    }

    public JSONObject changeResults(Boolean passed) throws IOException {
        return this.updateDetails((Map<String, Object>)ImmutableMap.of((Object)"passed", (Object)passed));
    }

    public JSONObject passed() throws IOException {
        return this.changeResults(true);
    }

    public JSONObject failed() throws IOException {
        return this.changeResults(false);
    }

    public JSONObject addTags(List<String> tagsList) throws IOException {
        return this.updateDetails((Map<String, Object>)ImmutableMap.of((Object)"tags", tagsList));
    }

    public JSONObject addCustomData(Map<String, Object> customData) throws IOException {
        return this.updateDetails((Map<String, Object>)ImmutableMap.of((Object)"custom-data", customData));
    }

    public JSONObject stop() throws IOException {
        String url = this.getBaseEndpoint() + "/stop";
        return new JSONObject(this.request(url, HttpMethod.PUT, new HashMap<String, Object>()).body().string());
    }

    public void delete() throws IOException {
        this.waitForFinishedTest();
        this.request(this.getBaseEndpoint(), HttpMethod.DELETE);
    }

    public JSONObject availableAssets() throws IOException {
        String url = this.getBaseEndpoint() + "/assets";
        this.waitForFinishedTest();
        return new JSONObject(this.getResponseObject(url));
    }

    public boolean isAssetAvailable(TestAsset asset) throws IOException {
        Collection availableAssets = this.availableAssets().toMap().values();
        return availableAssets.stream().map(item -> item instanceof ArrayList ? "screenshots.zip" : (String)item).anyMatch(item -> item.equals(asset.label));
    }

    public void download(TestAsset asset, Path location) throws IOException {
        if (!this.isAssetAvailable(asset)) {
            throw new FileNotFoundException("Can not find " + asset.label + " in list of available assets");
        }
        this.downloadKnownAsset(asset, location, "");
    }

    public void downloadAllAssets(Path location) throws IOException {
        this.downloadAllAssets(location, "");
    }

    public void downloadAllAssets(Path location, String prepend) throws IOException {
        JSONObject jsonObject = this.availableAssets();
        jsonObject.toMap().values().stream().map(asset -> asset instanceof ArrayList ? "screenshots.zip" : (String)asset).forEach(assetName -> this.downloadKnownAsset(TestAsset.get(assetName).get(), location, prepend));
    }

    public void deleteAllAssets() throws IOException {
        String url = this.getBaseEndpoint() + "/assets";
        this.request(url, HttpMethod.DELETE);
    }

    private JSONObject updateDetails(Map<String, Object> updates) throws IOException {
        return new JSONObject(this.request(this.getBaseEndpoint(), HttpMethod.PUT, updates).body().string());
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "rest/v1/" + this.username + "/jobs/" + this.jobID;
    }

    private void downloadKnownAsset(TestAsset asset, Path location, String prepend) {
        if (!location.getFileName().toString().contains(".")) {
            location = Paths.get(location.toString(), prepend + asset.label);
        }
        String url = this.getBaseEndpoint() + "/assets/" + asset.label;
        try {
            BufferedSource stream = this.getStream(url);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((Path)location, (OpenOption[])new OpenOption[0]));
            sink.writeAll((Source)Objects.requireNonNull(stream));
            sink.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void waitForFinishedTest() {
        String url = this.getBaseEndpoint() + "/assets";
        Awaitility.await().ignoreExceptionsMatching(e -> e.getMessage().contains("Bad Request")).atMost(Duration.ofSeconds(60L)).pollInterval(Duration.ofSeconds(1L)).until(() -> this.getResponseObject(url) != null);
    }
}

