/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import com.saucelabs.saucerest.AutomationBackend;
import com.saucelabs.saucerest.BuildUtils;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.ErrorExplainers;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.JobSource;
import com.saucelabs.saucerest.SauceException;
import com.saucelabs.saucerest.SauceSSLSocketFactory;
import com.saucelabs.saucerest.SauceShareableLink;
import com.saucelabs.saucerest.TestAsset;
import com.saucelabs.saucerest.api.Accounts;
import com.saucelabs.saucerest.api.Job;
import com.saucelabs.saucerest.api.Platform;
import com.saucelabs.saucerest.api.RealDevices;
import com.saucelabs.saucerest.api.SauceConnect;
import com.saucelabs.saucerest.api.Storage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SauceREST
implements Serializable {
    private static final Logger logger = Logger.getLogger(SauceREST.class.getName());
    private static final long HTTP_READ_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(System.getenv("SAUCE_HTTP_READ_TIMEOUT_SECONDS") != null ? (long)Integer.parseInt(System.getenv("SAUCE_HTTP_READ_TIMEOUT_SECONDS")) : 10L);
    private static final long HTTP_CONNECT_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    private static final int DEFAULT_BUILDS_LIMIT = 50;
    private static final String DATE_FORMAT = "yyyyMMdd_HHmmSS";
    private static String extraUserAgent = "";
    private final String server;
    private final String apiServer;
    private final String edsServer;
    private final String appServer;
    private final String restApiEndpoint;
    private final int maxDuration;
    private final int maxRetries;
    private final int delay;
    private final int maxDelay;
    private final int delayFactor;
    private final ChronoUnit chronoUnit;
    private final List<Class<? extends Throwable>> throwableList;
    protected String username;
    protected String accessKey;

    public SauceREST(DataCenter dataCenter) {
        this(System.getenv("SAUCE_USERNAME"), System.getenv("SAUCE_ACCESS_KEY"), dataCenter);
    }

    public SauceREST(String username, String accessKey, String dataCenter) {
        this(username, accessKey, DataCenter.fromString(dataCenter));
    }

    public SauceREST(String username, String accessKey, DataCenter dataCenter) {
        this(username, accessKey, dataCenter, 15, -1, 1, 5, ChronoUnit.SECONDS, 2, Collections.singletonList(SauceException.NotYetDone.class));
    }

    public SauceREST(String username, String accessKey, DataCenter dataCenter, int maxDuration, int maxRetries, int delay, int maxDelay, ChronoUnit chronoUnit, int delayFactor, List<Class<? extends Throwable>> throwableList) {
        this.username = username;
        this.accessKey = accessKey;
        this.server = this.buildUrl(dataCenter.server(), "SAUCE_REST_ENDPOINT", "saucerest-java.base_url");
        this.appServer = this.buildUrl(dataCenter.appServer(), "SAUCE_REST_APP_ENDPOINT", "saucerest-java.base_app_url");
        this.apiServer = this.buildUrl(dataCenter.apiServer(), "SAUCE_API_ENDPOINT", "saucerest-java.base_api_url");
        this.edsServer = this.buildUrl(dataCenter.edsServer(), "SAUCE_REST_EDS_ENDPOINT", "saucerest-java.base_eds_url");
        this.restApiEndpoint = this.server + "rest/v1/";
        this.maxDuration = maxDuration;
        this.maxRetries = maxRetries;
        this.delay = delay;
        this.maxDelay = maxDelay;
        this.chronoUnit = chronoUnit;
        this.delayFactor = delayFactor;
        this.throwableList = throwableList;
    }

    public static String getExtraUserAgent() {
        return extraUserAgent;
    }

    public static void setExtraUserAgent(String extraUserAgent) {
        SauceREST.extraUserAgent = extraUserAgent;
    }

    private String buildUrl(String defaultUrl, String envVarName, String systemPropertyName) {
        String envVar = System.getenv(envVarName);
        return envVar != null ? envVar : System.getProperty(systemPropertyName, defaultUrl);
    }

    private RetryPolicy<Object> getRetryPolicy() {
        return ((RetryPolicy)new RetryPolicy().handle(this.throwableList)).withMaxDuration(Duration.ofSeconds(this.maxDuration)).withMaxRetries(this.maxRetries).withBackoff((long)this.delay, (long)this.maxDelay, this.chronoUnit, (double)this.delayFactor);
    }

    public Job getJob(DataCenter dataCenter, String sessionId) {
        return new Job(this.username, this.accessKey, dataCenter, sessionId);
    }

    public Job getJob(String sessionId) {
        return new Job(this.username, this.accessKey, this.apiServer, sessionId);
    }

    public Job getJob(String apiServer, String sessionId) {
        return new Job(this.username, this.accessKey, apiServer, sessionId);
    }

    public Storage getStorage() {
        return new Storage(this.username, this.accessKey, this.apiServer);
    }

    public Storage getStorage(DataCenter dataCenter) {
        return new Storage(this.username, this.accessKey, dataCenter);
    }

    public Storage getStorage(String apiServer) {
        return new Storage(this.username, this.accessKey, apiServer);
    }

    public Platform getPlatform() {
        return new Platform(this.username, this.accessKey, this.apiServer);
    }

    public Platform getPlatform(DataCenter dataCenter) {
        return new Platform(this.username, this.accessKey, dataCenter);
    }

    public Platform getPlatform(String apiServer) {
        return new Platform(this.username, this.accessKey, apiServer);
    }

    public RealDevices getRealDevices(DataCenter dataCenter) {
        return new RealDevices(this.username, this.accessKey, dataCenter);
    }

    public RealDevices getRealDevices() {
        return new RealDevices(this.username, this.accessKey, this.apiServer);
    }

    public RealDevices getRealDevices(String apiServer) {
        return new RealDevices(this.username, this.accessKey, apiServer);
    }

    public SauceConnect getSauceConnect() {
        return new SauceConnect(this.username, this.accessKey, this.apiServer);
    }

    public SauceConnect getSauceConnect(String apiServer) {
        return new SauceConnect(this.username, this.accessKey, apiServer);
    }

    public SauceConnect getSauceConnect(DataCenter dataCenter) {
        return new SauceConnect(this.username, this.accessKey, dataCenter);
    }

    public Accounts getAccounts() {
        return new Accounts(this.username, this.accessKey, this.apiServer);
    }

    public Accounts getAccounts(String apiServer) {
        return new Accounts(this.username, this.accessKey, apiServer);
    }

    public Accounts getAccounts(DataCenter dataCenter) {
        return new Accounts(this.username, this.accessKey, dataCenter);
    }

    public String getUsername() {
        return this.username;
    }

    public String getServer() {
        return this.server;
    }

    public String getEdsServer() {
        return this.edsServer;
    }

    public String getAppServer() {
        return this.appServer;
    }

    public String getRestApiEndpoint() {
        return this.restApiEndpoint;
    }

    protected URL buildURL(String endpoint) {
        return this.buildEndpoint(this.restApiEndpoint, endpoint, "URL");
    }

    protected URL buildBuildUrl(JobSource source, String endpoint) {
        return this.buildEndpoint(this.apiServer, "v2/builds/" + source.name().toLowerCase(Locale.ROOT) + "/" + endpoint, "Builds URL");
    }

    protected URL appendToBaseURL(String endpoint, String urlDescription) {
        return this.buildEndpoint(this.apiServer, endpoint, urlDescription);
    }

    private URL buildHarUrl(String jobId) {
        return this.buildEDSURL(jobId + "/" + TestAsset.HAR.label);
    }

    protected URL buildEDSURL(String endpoint) {
        return this.buildEndpoint(this.edsServer, endpoint, "EDS URL");
    }

    private URL buildEndpoint(String server, String endpoint, String urlDescription) {
        try {
            return new URL(new URL(server), endpoint);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, e, () -> "Error constructing Sauce " + urlDescription);
            return null;
        }
    }

    public String getUserAgent() {
        String userAgent = "SauceREST/" + BuildUtils.getCurrentVersion();
        if (!"".equals(SauceREST.getExtraUserAgent())) {
            userAgent = userAgent + " " + SauceREST.getExtraUserAgent();
        }
        logger.log(Level.FINEST, "userAgent is set to {0}", userAgent);
        return userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doJSONPOST(URL url, JSONObject body) throws SauceException {
        HttpURLConnection postBack = null;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            String inputLine;
            postBack = this.openConnection(HttpMethod.POST, url);
            if (postBack instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)postBack).setSSLSocketFactory(factory);
            }
            postBack.setRequestProperty("Content-Type", "application/json");
            logger.log(Level.FINE, "POSTing to {0}", url);
            logger.log(Level.FINE, body.toString(2));
            postBack.getOutputStream().write(body.toString().getBytes());
            reader = new BufferedReader(new InputStreamReader(postBack.getInputStream()));
            logger.log(Level.FINEST, "Building string from response.");
            while ((inputLine = reader.readLine()) != null) {
                logger.log(Level.FINEST, "  {0}", inputLine);
                builder.append(inputLine);
            }
        }
        catch (IOException e) {
            try {
                if (postBack.getResponseCode() == 401) {
                    logger.log(Level.SEVERE, "Error POSTing to {0}: Unauthorized (401)", url);
                    throw new SauceException.NotAuthorized();
                }
            }
            catch (IOException e1) {
                logger.log(Level.SEVERE, e, () -> "Error POSTing to " + url + " and getting status code: ");
            }
            logger.log(Level.SEVERE, e, () -> "Error POSTing to " + url + ":");
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, e, () -> "Error POSTing to " + url + ":");
        }
        finally {
            this.closeInputStream(postBack);
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing Sauce input stream", e);
            }
        }
        return builder.toString();
    }

    public void jobPassed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", true);
        this.updateJobInfo(jobId, updates);
    }

    public void jobFailed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", false);
        this.updateJobInfo(jobId, updates);
    }

    public void addTags(String jobId, List<String> tags) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("tags", tags);
        this.updateJobInfo(jobId, updates);
    }

    private AutomationBackend getAutomationBackend(String jobId) {
        JSONObject jsonObject = new JSONObject(this.getJobInfo(jobId));
        String automationBackend = jsonObject.getString("automation_backend");
        return Stream.of(AutomationBackend.values()).filter(backend -> backend.label.equalsIgnoreCase(automationBackend)).findFirst().orElse(null);
    }

    public BufferedInputStream getAvailableAssets(String jobId) throws IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets");
        return this.downloadFileData(jobId, restEndpoint);
    }

    public void downloadAllAssets(String jobId, String location) throws IOException {
        JSONObject jsonObject;
        boolean hasScreenshots = false;
        boolean isAppiumBackend = this.getAutomationBackend(jobId) == AutomationBackend.APPIUM;
        try (BufferedInputStream stream = this.getAvailableAssets(jobId);){
            jsonObject = new JSONObject(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8));
        }
        jsonObject.remove(TestAsset.VIDEO.label);
        if (jsonObject.keySet().contains("screenshots")) {
            hasScreenshots = true;
            jsonObject.remove("screenshots");
        }
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (jsonObject.get(key) instanceof String) {
                String assetName = jsonObject.getString(key);
                TestAsset testAsset = null;
                String overwriteFilename = isAppiumBackend && "selenium-log".equalsIgnoreCase(key) ? TestAsset.APPIUM_LOG.label : assetName;
                for (TestAsset asset : TestAsset.values()) {
                    if (!asset.label.equalsIgnoreCase(assetName)) continue;
                    testAsset = asset;
                }
                this.saveAsset(jobId, testAsset, location, this.getDefaultFileName(jobId, overwriteFilename));
                continue;
            }
            logger.log(Level.WARNING, "No valid JSON response found.");
        }
        if (hasScreenshots) {
            this.downloadScreenshots(jobId, location, null);
        }
    }

    public boolean downloadDeviceLog(String jobId, String location, boolean isEmulator) {
        String filename = isEmulator ? TestAsset.LOGCAT_LOG.label : TestAsset.SYSLOG_LOG.label;
        return this.downloadDeviceLog(jobId, location, filename, isEmulator);
    }

    public boolean downloadDeviceLog(String jobId, String location, String filename, boolean isEmulator) {
        return this.handleErrorAtDownloadGracefully(() -> this.downloadDeviceLogOrThrow(jobId, location, filename, isEmulator));
    }

    public void downloadDeviceLogOrThrow(String jobId, String location, boolean isEmulator) throws SauceException.NotAuthorized, IOException {
        String filename = isEmulator ? TestAsset.LOGCAT_LOG.label : TestAsset.SYSLOG_LOG.label;
        this.downloadDeviceLogOrThrow(jobId, location, filename, isEmulator);
    }

    public void downloadDeviceLogOrThrow(String jobId, String location, String filename, boolean isEmulator) throws SauceException.NotAuthorized, IOException {
        TestAsset asset = isEmulator ? TestAsset.LOGCAT_LOG : TestAsset.SYSLOG_LOG;
        this.saveAssetOrThrowException(jobId, asset, location, filename);
    }

    public boolean downloadScreenshots(String jobId, String location) {
        return this.downloadScreenshots(jobId, location, TestAsset.SCREENSHOTS.label);
    }

    public boolean downloadScreenshots(String jobId, String location, String filename) {
        return this.handleErrorAtDownloadGracefully(() -> this.downloadScreenshotsOrThrow(jobId, location, filename));
    }

    public void downloadScreenshotsOrThrow(String jobId, String location) throws SauceException.NotAuthorized, IOException {
        this.downloadScreenshotsOrThrow(jobId, location, TestAsset.SCREENSHOTS.label);
    }

    public void downloadScreenshotsOrThrow(String jobId, String location, String filename) throws SauceException.NotAuthorized, IOException {
        this.saveAssetOrThrowException(jobId, TestAsset.SCREENSHOTS, location, filename);
    }

    public boolean downloadVideo(String jobId, String location) {
        return this.downloadVideo(jobId, location, TestAsset.VIDEO.label);
    }

    public boolean downloadVideo(String jobId, String location, String fileName) {
        return this.saveAsset(jobId, TestAsset.VIDEO, location, fileName);
    }

    public BufferedInputStream downloadVideo(String jobId) throws IOException {
        return this.downloadAssetData(jobId, TestAsset.VIDEO);
    }

    public void downloadVideoOrThrow(String jobId, String location) throws SauceException.NotAuthorized, IOException {
        this.downloadVideoOrThrow(jobId, location, TestAsset.VIDEO.label);
    }

    public void downloadVideoOrThrow(String jobId, String location, String fileName) throws SauceException.NotAuthorized, IOException {
        this.saveAssetOrThrowException(jobId, TestAsset.VIDEO, location, fileName);
    }

    public boolean downloadServerLog(String jobId, String location) {
        return this.downloadServerLog(jobId, location, TestAsset.SELENIUM_LOG.label);
    }

    public boolean downloadServerLog(String jobId, String location, String fileName) {
        return this.handleErrorGracefully("Failed to save file", () -> this.downloadServerLogOrThrow(jobId, location, fileName));
    }

    public BufferedInputStream downloadServerLog(String jobId) throws IOException {
        return this.downloadAssetData(jobId, TestAsset.SELENIUM_LOG);
    }

    public void downloadServerLogOrThrow(String jobId, String location) throws SauceException.NotAuthorized, IOException {
        this.downloadServerLogOrThrow(jobId, location, "selenium-server.log");
    }

    public void downloadServerLogOrThrow(String jobId, String location, String fileName) throws SauceException.NotAuthorized, IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/selenium-server.log");
        this.saveServerLogFileOrThrow(jobId, location, fileName, restEndpoint);
    }

    public BufferedInputStream downloadSauceLabsLog(String jobId) throws IOException {
        return this.downloadAssetData(jobId, TestAsset.SAUCE_LOG);
    }

    public boolean downloadSauceLabsLog(String jobId, String location) {
        return this.downloadSauceLabsLog(jobId, location, TestAsset.SAUCE_LOG.label);
    }

    public boolean downloadSauceLabsLog(String jobId, String location, String fileName) {
        return this.saveAsset(jobId, TestAsset.SAUCE_LOG, location, fileName);
    }

    public boolean downloadAutomatorLog(String jobId, String location) {
        return this.downloadAutomatorLog(jobId, location, TestAsset.AUTOMATOR_LOG.label);
    }

    public boolean downloadAutomatorLog(String jobId, String location, String filename) {
        return this.saveAsset(jobId, TestAsset.AUTOMATOR_LOG, location, filename);
    }

    public boolean downloadHAR(String jobId, String location) {
        return this.downloadHAR(jobId, location, TestAsset.HAR.label);
    }

    public boolean downloadHAR(String jobId, String location, String fileName) {
        URL restEndpoint = this.buildHarUrl(jobId);
        return this.saveFile(jobId, location, fileName, restEndpoint);
    }

    public void downloadHAROrThrow(String jobId, String location) throws SauceException.NotAuthorized, IOException {
        this.downloadHAROrThrow(jobId, location, TestAsset.HAR.label);
    }

    public void downloadHAROrThrow(String jobId, String location, String fileName) throws SauceException.NotAuthorized, IOException {
        URL restEndpoint = this.buildHarUrl(jobId);
        this.saveFileOrThrowException(jobId, location, fileName, restEndpoint);
    }

    public BufferedInputStream getHARDataStream(String jobId) throws IOException {
        logger.log(Level.FINEST, "getHARDataStream for {0}", jobId);
        URL restEndpoint = this.buildHarUrl(jobId);
        return this.downloadFileData(jobId, restEndpoint);
    }

    public JSONTokener getHARData(String jobId) throws IOException, JSONException {
        logger.log(Level.FINEST, "getHARData for {0}", jobId);
        URL restEndpoint = this.buildHarUrl(jobId);
        BufferedInputStream har_stream = this.downloadFileData(jobId, restEndpoint);
        return new JSONTokener((InputStream)har_stream);
    }

    public String retrieveResults(String path) {
        URL restEndpoint = this.buildURL(path);
        return this.retrieveResults(restEndpoint);
    }

    public String getJobInfo(String jobId) {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId);
        return this.retrieveResults(restEndpoint);
    }

    public String getFullJobs() {
        return this.getFullJobs(20);
    }

    public String getFullJobs(int limit) {
        URL restEndpoint = this.buildURL(this.username + "/jobs?full=true&limit=" + limit);
        return this.retrieveResults(restEndpoint);
    }

    public String getJobs() {
        URL restEndpoint = this.buildURL(this.username + "/jobs");
        return this.retrieveResults(restEndpoint);
    }

    public String getJobs(int limit) {
        URL restEndpoint = this.buildURL(this.username + "/jobs?limit=" + limit);
        return this.retrieveResults(restEndpoint);
    }

    public String getJobs(int limit, long to, int from) {
        URL restEndpoint = this.buildURL(this.username + "/jobs?limit=" + limit + "&from=" + to + "&to=" + from);
        return this.retrieveResults(restEndpoint);
    }

    public String getJobsByIds(Iterable<String> ids, boolean full) {
        ArrayList<String> params = new ArrayList<String>();
        for (String jobId : ids) {
            params.add("id=" + jobId);
        }
        if (params.size() == 0) {
            return "{}";
        }
        if (full) {
            params.add("full=true");
        }
        URL restEndpoint = this.buildURL("jobs?" + String.join((CharSequence)"&", params));
        return this.retrieveResults(restEndpoint);
    }

    public String getFullJobsByIds(Iterable<String> ids) {
        return this.getJobsByIds(ids, true);
    }

    public String retrieveResults(URL restEndpoint) {
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            String inputLine;
            HttpURLConnection connection = this.openConnection(HttpMethod.GET, restEndpoint);
            if (connection instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
            }
            connection.setRequestProperty("charset", "utf-8");
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = reader.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.SEVERE, "Received a SocketTimeoutException when invoking Sauce REST API, check status.saucelabs.com for network outages", e);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "Error retrieving Sauce Results", e);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing Sauce input stream", e);
        }
        return builder.toString();
    }

    private BufferedInputStream downloadAssetData(String jobId, TestAsset assetName) throws IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/" + assetName.label);
        return this.downloadFileData(jobId, restEndpoint);
    }

    private BufferedInputStream downloadFileData(String jobId, URL restEndpoint) throws SauceException.NotAuthorized, IOException {
        HttpURLConnection connection;
        block4: {
            logger.log(Level.FINE, "Downloading asset {0} For Job {1}", new Object[]{restEndpoint, jobId});
            logger.log(Level.FINEST, "Opening connection for Job {0}", jobId);
            connection = null;
            try {
                connection = (HttpURLConnection)Failsafe.with(this.getRetryPolicy(), (Policy[])new RetryPolicy[0]).get(() -> this.setConnection(jobId, restEndpoint));
            }
            catch (FailsafeException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof FileNotFoundException) {
                    throw (FileNotFoundException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (!(throwable instanceof SauceException.NotAuthorized)) break block4;
                throw (SauceException.NotAuthorized)throwable;
            }
        }
        logger.log(Level.FINEST, "Obtaining input stream for request issued for Job {0}", jobId);
        InputStream stream = connection.getInputStream();
        return new BufferedInputStream(stream);
    }

    private HttpURLConnection setConnection(String jobId, URL restEndpoint, HttpMethod method) throws IOException {
        HttpURLConnection connection = this.openConnection(method, restEndpoint);
        int responseCode = connection.getResponseCode();
        logger.log(Level.FINEST, "{0} - {1} for: {2}", new Object[]{responseCode, restEndpoint, jobId});
        switch (responseCode) {
            case 404: {
                String path = restEndpoint.getPath();
                String errorDetails = null;
                if (path.endsWith("mp4")) {
                    errorDetails = ErrorExplainers.videoMissing();
                } else if (path.endsWith("har")) {
                    errorDetails = ErrorExplainers.HARMissing();
                } else if (path.endsWith("log") || path.endsWith("json")) {
                    errorDetails = ErrorExplainers.LogNotFound();
                } else if (path.contains("tunnels")) {
                    errorDetails = ErrorExplainers.TunnelNotFound();
                    throw new SauceException.NotFound(String.join((CharSequence)System.lineSeparator(), errorDetails));
                }
                String error = ErrorExplainers.resourceMissing();
                throw new FileNotFoundException(errorDetails != null ? String.join((CharSequence)System.lineSeparator(), error, errorDetails) : error);
            }
            case 401: {
                String errorReasons = "";
                if (this.username == null || this.username.isEmpty()) {
                    errorReasons = String.join((CharSequence)System.lineSeparator(), "Your username is empty or blank.");
                }
                if (this.accessKey == null || this.accessKey.isEmpty()) {
                    errorReasons = String.join((CharSequence)System.lineSeparator(), "Your access key is empty or blank.");
                }
                errorReasons = !errorReasons.isEmpty() ? String.join((CharSequence)System.lineSeparator(), errorReasons, ErrorExplainers.missingCreds()) : ErrorExplainers.incorrectCreds(this.username, this.accessKey);
                throw new SauceException.NotAuthorized(errorReasons);
            }
            case 400: {
                String errorStream = IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)StandardCharsets.UTF_8);
                if (errorStream.isEmpty() || !errorStream.contains("Job hasn't finished running")) break;
                throw new SauceException.NotYetDone(ErrorExplainers.JobNotYetDone());
            }
            case 200: {
                break;
            }
            default: {
                logger.log(Level.WARNING, "Unknown response code received:{0}", responseCode);
            }
        }
        return connection;
    }

    private HttpURLConnection setConnection(String jobId, URL restEndpoint) throws IOException {
        return this.setConnection(jobId, restEndpoint, HttpMethod.GET);
    }

    private HttpURLConnection setConnection(URL restEndpoint, HttpMethod method) throws IOException {
        return this.setConnection("", restEndpoint, method);
    }

    private boolean saveAsset(String jobId, TestAsset assetName, String location, String fileName) {
        return this.handleErrorAtDownloadGracefully(() -> this.saveAssetOrThrowException(jobId, assetName, location, fileName));
    }

    private void saveAssetOrThrowException(String jobId, TestAsset assetName, String location, String fileName) throws IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/" + assetName.label);
        this.saveFileOrThrowException(jobId, location, fileName, restEndpoint);
    }

    private boolean saveFile(String jobId, String location, String fileName, URL restEndpoint) {
        return this.handleErrorAtDownloadGracefully(() -> this.saveFileOrThrowException(jobId, location, fileName, restEndpoint));
    }

    private String getFileName(String fileName, String jobId, URL restEndpoint) {
        if (fileName == null || fileName.length() < 1) {
            return this.getDefaultFileName(jobId, FilenameUtils.getName((String)restEndpoint.getPath()));
        }
        return fileName.replace('/', '_');
    }

    private String getDefaultFileName(String jobId, String overwriteFilename) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return String.format("%s_%s_%s", jobId, format.format(new Date()), overwriteFilename);
    }

    private void saveFileOrThrowException(String jobId, String location, String fileName, URL restEndpoint) throws SauceException.NotAuthorized, IOException {
        logger.log(Level.FINEST, "Attempting to save asset {0} for Job {1} to {2}", new Object[]{restEndpoint, jobId, location});
        fileName = this.getFileName(fileName, jobId, restEndpoint);
        File targetFile = new File(location, fileName);
        System.out.println("Saving " + restEndpoint + " for Job " + jobId + " as " + targetFile);
        logger.log(Level.FINEST, "Saving {0} for Job {1} as {2}", new Object[]{restEndpoint, jobId, targetFile});
        try (BufferedInputStream in = this.downloadFileData(jobId, restEndpoint);){
            FileUtils.copyInputStreamToFile((InputStream)in, (File)targetFile);
        }
    }

    private void saveServerLogFileOrThrow(String jobId, String location, String fileName, URL restEndpoint) throws SauceException.NotAuthorized, IOException {
        byte[] bytes;
        logger.log(Level.FINEST, "Attempting to save asset {0} for Job {1} to {2}", new Object[]{restEndpoint, jobId, location});
        try (BufferedInputStream in = this.downloadFileData(jobId, restEndpoint);){
            bytes = IOUtils.toByteArray((InputStream)in);
        }
        fileName = this.getFileName(fileName, jobId, restEndpoint);
        if (fileName.contains("selenium-server.log") && new String(bytes, StandardCharsets.UTF_8).contains("Appium")) {
            fileName = fileName.replace("selenium-server", "appium-server");
        }
        File targetFile = new File(location, fileName);
        logger.log(Level.FINEST, "Saving {0} for Job {1} as {2}", new Object[]{restEndpoint, jobId, targetFile});
        FileUtils.writeByteArrayToFile((File)targetFile, (byte[])bytes);
    }

    private boolean handleErrorAtDownloadGracefully(IOExecutable executable) {
        return this.handleErrorGracefully("Error downloading Sauce Results", executable);
    }

    private boolean handleErrorGracefully(String logMessage, IOExecutable executable) {
        try {
            executable.execute();
            return true;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, logMessage, e);
            return false;
        }
    }

    protected void addAuthenticationProperty(HttpURLConnection connection) {
        if (this.username != null && this.accessKey != null) {
            String auth = this.encodeAuthentication();
            logger.log(Level.FINE, "Encoded Authorization: {0}", auth);
            connection.setRequestProperty("Authorization", auth);
        }
    }

    public void updateJobInfo(String jobId, Map<String, Object> updates) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId);
            postBack = this.openConnection(HttpMethod.PUT, restEndpoint);
            postBack.getOutputStream().write(new JSONObject(updates).toString().getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error updating Sauce Results", e);
        }
        this.closeInputStream(postBack);
    }

    public void stopJob(String jobId) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/stop");
            postBack = this.openConnection(HttpMethod.PUT, restEndpoint);
            postBack.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(postBack);
    }

    public void deleteJob(String jobId) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId);
            postBack = this.openConnection(HttpMethod.DELETE, restEndpoint);
            postBack.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(postBack);
    }

    private void closeInputStream(HttpURLConnection connection) {
        try {
            if (connection != null) {
                connection.getInputStream().close();
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.SEVERE, "Received a SocketTimeoutException when invoking Sauce REST API, check status.saucelabs.com for network outages", e);
        }
        catch (IOException e) {
            try {
                int responseCode = connection.getResponseCode();
                if (responseCode == 401) {
                    throw new SauceException.NotAuthorized();
                }
                if (responseCode == 429) {
                    throw new SauceException.TooManyRequests();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Error determining response code", e);
            }
            logger.log(Level.WARNING, "Error closing result stream", e);
        }
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection con;
        if ("true".equals(System.getenv("USE_PROXY"))) {
            logger.log(Level.SEVERE, "Using proxy: {0}:{1}", new Object[]{System.getenv("http.proxyHost"), System.getenv("http.proxyPort")});
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getenv("http.proxyHost"), Integer.parseInt(System.getenv("http.proxyPort"))));
            con = (HttpURLConnection)url.openConnection(proxy);
        } else {
            con = (HttpURLConnection)url.openConnection();
        }
        con.setReadTimeout((int)HTTP_READ_TIMEOUT_SECONDS);
        con.setConnectTimeout((int)HTTP_CONNECT_TIMEOUT_SECONDS);
        return con;
    }

    private HttpURLConnection openConnection(HttpMethod method, URL url) throws IOException {
        HttpURLConnection connection = this.openConnection(url);
        connection.setRequestMethod(method.label);
        connection.setRequestProperty("User-Agent", this.getUserAgent());
        connection.setDoOutput(true);
        this.addAuthenticationProperty(connection);
        return connection;
    }

    public String getPublicJobLink(String jobId) {
        try {
            return SauceShareableLink.getShareableLink(this.getUsername(), this.accessKey, jobId, this.getAppServer());
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.WARNING, "Could not get an instance with provided HmacMD5 algorithm.", e.getCause());
        }
        catch (InvalidKeyException e) {
            logger.log(Level.WARNING, "Could not init a MAC object with the provided key.", e.getCause());
        }
        logger.log(Level.WARNING, "Could not create a shareable link.");
        return "";
    }

    protected String encodeAuthentication() {
        String auth = this.username + ":" + this.accessKey;
        auth = "Basic " + Base64.getEncoder().encodeToString(auth.getBytes());
        return auth;
    }

    public BufferedInputStream deleteTunnel(String tunnelId) throws IOException {
        try {
            URL restEndpoint = this.buildURL(this.username + "/tunnels/" + tunnelId);
            HttpURLConnection connection = this.setConnection(restEndpoint, HttpMethod.DELETE);
            InputStream stream = connection.getInputStream();
            return new BufferedInputStream(stream);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof SauceException.NotAuthorized || cause instanceof SauceException.NotFound) {
                throw (SauceException)cause;
            }
            throw new SauceException.UnknownError("Unknown Error deleting tunnel");
        }
    }

    public String getTunnels() {
        URL restEndpoint = this.buildURL(this.username + "/tunnels");
        return this.retrieveResults(restEndpoint);
    }

    public String getTunnelInformation(String tunnelId) {
        URL restEndpoint = this.buildURL(this.username + "/tunnels/" + tunnelId);
        return this.retrieveResults(restEndpoint);
    }

    public String getConcurrency() {
        URL restEndpoint = this.appendToBaseURL("/rest/v1.2/users/" + this.username + "/concurrency", "Get User Concurrency");
        return this.retrieveResults(restEndpoint);
    }

    public String getActivity() {
        URL restEndpoint = this.buildURL(this.username + "/activity");
        return this.retrieveResults(restEndpoint);
    }

    public String getUser() {
        URL restEndpoint = this.buildURL("users/" + this.username);
        return this.retrieveResults(restEndpoint);
    }

    public String getBuildJobs(JobSource source, String build) {
        URL jobsEndpoint = this.buildBuildUrl(source, build + "/jobs/");
        return this.retrieveResults(jobsEndpoint);
    }

    public String getBuild(JobSource source, String build) {
        URL restEndpoint = this.buildBuildUrl(source, build + "/");
        return this.retrieveResults(restEndpoint);
    }

    public String getBuilds(JobSource source) {
        return this.getBuilds(source, 50);
    }

    public String getBuilds(JobSource source, int limit) {
        URL restEndpoint = this.buildBuildUrl(source, "?limit=" + limit);
        return this.retrieveResults(restEndpoint);
    }

    public String getBuildForJob(JobSource source, String jobId) {
        URL restEndpoint = this.buildBuildUrl(source, "jobs/" + jobId + "/build/");
        return this.retrieveResults(restEndpoint);
    }

    public String getBuildsByName(JobSource source, String name) throws UnsupportedEncodingException {
        return this.getBuildsByName(source, name, 50);
    }

    public String getBuildsByName(JobSource source, String name, int limit) throws UnsupportedEncodingException {
        URL restEndpoint = this.buildBuildUrl(source, "?name=" + URLEncoder.encode(name, "UTF-8") + "&limit=" + limit);
        return this.retrieveResults(restEndpoint);
    }

    public boolean recordCI(String platform, String platformVersion) {
        URL restEndpoint = this.buildURL("stats/ci");
        JSONObject obj = new JSONObject();
        try {
            obj.put("platform", (Object)platform);
            obj.put("platform_version", (Object)platformVersion);
        }
        catch (JSONException e) {
            logger.log(Level.SEVERE, "Error attempting to craft json:", e);
            return false;
        }
        try {
            this.doJSONPOST(restEndpoint, obj);
        }
        catch (SauceException e) {
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SauceREST)) {
            return super.equals(obj);
        }
        SauceREST sauceobj = (SauceREST)obj;
        return Objects.equals(sauceobj.username, this.username) && Objects.equals(sauceobj.accessKey, this.accessKey) && Objects.equals(sauceobj.server, this.server);
    }

    private static interface IOExecutable {
        public void execute() throws IOException;
    }
}

