/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import com.saucelabs.saucerest.BuildUtils;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.ErrorExplainers;
import com.saucelabs.saucerest.SauceException;
import com.saucelabs.saucerest.SauceSSLSocketFactory;
import com.saucelabs.saucerest.SecurityUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.rmi.UnexpectedException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SauceREST
implements Serializable {
    private static final Logger logger = Logger.getLogger(SauceREST.class.getName());
    private static final long HTTP_READ_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(System.getenv("SAUCE_HTTP_READ_TIMEOUT_SECONDS") != null ? (long)Integer.parseInt(System.getenv("SAUCE_HTTP_READ_TIMEOUT_SECONDS")) : 10L);
    private static final long HTTP_CONNECT_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    protected String username;
    protected String accessKey;
    private static final String DATE_FORMAT = "yyyyMMdd_HHmmSS";
    private static String extraUserAgent = "";
    private String server;
    private String edsServer;
    private String appServer;
    private String restApiEndpoint;

    public SauceREST(String username, String accessKey) {
        this(username, accessKey, DataCenter.US);
    }

    public SauceREST(String username, String accessKey, String dataCenter) {
        this(username, accessKey, DataCenter.fromString(dataCenter));
    }

    public SauceREST(String username, String accessKey, DataCenter dataCenter) {
        this.username = username;
        this.accessKey = accessKey;
        this.server = this.buildUrl(dataCenter.server(), "SAUCE_REST_ENDPOINT", "saucerest-java.base_url");
        this.appServer = this.buildUrl(dataCenter.appServer(), "SAUCE_REST_APP_ENDPOINT", "saucerest-java.base_app_url");
        this.edsServer = this.buildUrl(dataCenter.edsServer(), "SAUCE_REST_EDS_ENDPOINT", "saucerest-java.base_eds_url");
        this.restApiEndpoint = this.server + "rest/v1/";
    }

    private String buildUrl(String defaultUrl, String envVarName, String systemPropertyName) {
        String envVar = System.getenv(envVarName);
        return envVar != null ? envVar : System.getProperty(systemPropertyName, defaultUrl);
    }

    public static String getExtraUserAgent() {
        return extraUserAgent;
    }

    public static void setExtraUserAgent(String extraUserAgent) {
        SauceREST.extraUserAgent = extraUserAgent;
    }

    public String getUsername() {
        return this.username;
    }

    public String getServer() {
        return this.server;
    }

    public String getEdsServer() {
        return this.edsServer;
    }

    public String getAppServer() {
        return this.appServer;
    }

    public String getRestApiEndpoint() {
        return this.restApiEndpoint;
    }

    protected URL buildURL(String endpoint) {
        return this.buildEndpoint(this.restApiEndpoint, endpoint, "URL");
    }

    protected URL buildEDSURL(String endpoint) {
        return this.buildEndpoint(this.edsServer, endpoint, "EDS URL");
    }

    private URL buildEndpoint(String server, String endpoint, String urlDescription) {
        try {
            return new URL(new URL(server), endpoint);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, e, () -> "Error constructing Sauce " + urlDescription);
            return null;
        }
    }

    protected String getUserAgent() {
        String userAgent = "SauceREST/" + BuildUtils.getCurrentVersion();
        if (!"".equals(SauceREST.getExtraUserAgent())) {
            userAgent = userAgent + " " + SauceREST.getExtraUserAgent();
        }
        logger.log(Level.FINEST, "userAgent is set to " + userAgent);
        return userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doJSONPOST(URL url, JSONObject body) throws SauceException {
        HttpURLConnection postBack = null;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            String inputLine;
            postBack = this.openConnection(url);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            if (postBack instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)postBack).setSSLSocketFactory(factory);
            }
            postBack.setDoOutput(true);
            postBack.setRequestMethod("POST");
            postBack.setRequestProperty("Content-Type", "application/json");
            this.addAuthenticationProperty(postBack);
            logger.log(Level.FINE, "POSTing to " + url.toString());
            logger.log(Level.FINE, body.toString(2));
            postBack.getOutputStream().write(body.toString().getBytes());
            reader = new BufferedReader(new InputStreamReader(postBack.getInputStream()));
            logger.log(Level.FINEST, "Building string from response.");
            while ((inputLine = reader.readLine()) != null) {
                logger.log(Level.FINEST, "  " + inputLine);
                builder.append(inputLine);
            }
        }
        catch (IOException e) {
            try {
                if (postBack.getResponseCode() == 401) {
                    logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ": Unauthorized (401)");
                    throw new SauceException.NotAuthorized();
                }
            }
            catch (IOException e1) {
                logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + " and getting status code: ", e);
            }
            logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ":", e);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ":", e);
        }
        finally {
            this.closeInputStream(postBack);
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing Sauce input stream", e);
            }
        }
        return builder.toString();
    }

    public void jobPassed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", true);
        this.updateJobInfo(jobId, updates);
    }

    public void jobFailed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", false);
        this.updateJobInfo(jobId, updates);
    }

    public void addTags(String jobId, List<String> tags) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("tags", tags);
        this.updateJobInfo(jobId, updates);
    }

    public boolean downloadVideo(String jobId, String location) {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/video.mp4");
        return this.saveFile(jobId, location, this.getDefaultFileName(jobId, restEndpoint), restEndpoint);
    }

    public boolean downloadVideo(String jobId, String location, String fileName) {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/video.mp4");
        return this.saveFile(jobId, location, fileName, restEndpoint);
    }

    public void downloadVideoOrThrow(String jobId, String location) throws SauceException.NotAuthorized, IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/video.mp4");
        this.saveFileOrThrowException(jobId, location, this.getDefaultFileName(jobId, restEndpoint), restEndpoint);
    }

    public void downloadVideoOrThrow(String jobId, String location, String fileName) throws SauceException.NotAuthorized, IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/video.mp4");
        this.saveFileOrThrowException(jobId, location, fileName, restEndpoint);
    }

    public BufferedInputStream downloadVideo(String jobId) throws IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/video.mp4");
        return this.downloadFileData(jobId, restEndpoint);
    }

    public boolean downloadLog(String jobId, String location) {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/selenium-server.log");
        return this.saveFile(jobId, location, this.getDefaultFileName(jobId, restEndpoint), restEndpoint);
    }

    public boolean downloadLog(String jobId, String location, String fileName) {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/selenium-server.log");
        return this.saveFile(jobId, location, fileName, restEndpoint);
    }

    public BufferedInputStream downloadJsonLog(String jobId) throws IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/log.json");
        return this.downloadFileData(jobId, restEndpoint);
    }

    public boolean downloadJsonLog(String jobId, String location) {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/log.json");
        return this.saveFile(jobId, location, this.getDefaultFileName(jobId, restEndpoint), restEndpoint);
    }

    public boolean downloadJsonLog(String jobId, String location, String fileName) {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/log.json");
        return this.saveFile(jobId, location, fileName, restEndpoint);
    }

    public void downloadLogOrThrow(String jobId, String location) throws SauceException.NotAuthorized, IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/selenium-server.log");
        this.saveFileOrThrowException(jobId, location, this.getDefaultFileName(jobId, restEndpoint), restEndpoint);
    }

    public void downloadLogOrThrow(String jobId, String location, String fileName) throws SauceException.NotAuthorized, IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/selenium-server.log");
        this.saveFileOrThrowException(jobId, location, fileName, restEndpoint);
    }

    public BufferedInputStream downloadLog(String jobId) throws IOException {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/assets/selenium-server.log");
        return this.downloadFileData(jobId, restEndpoint);
    }

    public boolean downloadHAR(String jobId, String location) {
        URL restEndpoint = this.buildEDSURL(jobId + "/network.har");
        return this.saveFile(jobId, location, this.getDefaultFileName(jobId, restEndpoint), restEndpoint);
    }

    public boolean downloadHAR(String jobId, String location, String fileName) {
        URL restEndpoint = this.buildEDSURL(jobId + "/network.har");
        return this.saveFile(jobId, location, fileName, restEndpoint);
    }

    public void downloadHAROrThrow(String jobId, String location) throws SauceException.NotAuthorized, IOException {
        URL restEndpoint = this.buildEDSURL(jobId + "/network.har");
        this.saveFileOrThrowException(jobId, location, this.getDefaultFileName(jobId, restEndpoint), restEndpoint);
    }

    public void downloadHAROrThrow(String jobId, String location, String fileName) throws SauceException.NotAuthorized, IOException {
        URL restEndpoint = this.buildEDSURL(jobId + "/network.har");
        this.saveFileOrThrowException(jobId, location, fileName, restEndpoint);
    }

    public BufferedInputStream getHARDataStream(String jobId) throws IOException {
        logger.log(Level.FINEST, "getHARDataStream for " + jobId);
        URL restEndpoint = this.buildEDSURL(jobId + "/network.har");
        return this.downloadFileData(jobId, restEndpoint);
    }

    public JSONTokener getHARData(String jobId) throws IOException, JSONException {
        logger.log(Level.FINEST, "getHARData for " + jobId);
        URL restEndpoint = this.buildEDSURL(jobId + "/network.har");
        BufferedInputStream har_stream = this.downloadFileData(jobId, restEndpoint);
        return new JSONTokener((InputStream)har_stream);
    }

    public String retrieveResults(String path) {
        URL restEndpoint = this.buildURL(path);
        return this.retrieveResults(restEndpoint);
    }

    public String getJobInfo(String jobId) {
        URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId);
        return this.retrieveResults(restEndpoint);
    }

    public String getFullJobs() {
        return this.getFullJobs(20);
    }

    public String getFullJobs(int limit) {
        URL restEndpoint = this.buildURL(this.username + "/jobs?full=true&limit=" + limit);
        return this.retrieveResults(restEndpoint);
    }

    public String getJobs() {
        URL restEndpoint = this.buildURL(this.username + "/jobs");
        return this.retrieveResults(restEndpoint);
    }

    public String getJobs(int limit) {
        URL restEndpoint = this.buildURL(this.username + "/jobs?limit=" + limit);
        return this.retrieveResults(restEndpoint);
    }

    public String getJobs(int limit, long to, int from) {
        URL restEndpoint = this.buildURL(this.username + "/jobs?limit=" + limit + "&from=" + to + "&to=" + from);
        return this.retrieveResults(restEndpoint);
    }

    public String retrieveResults(URL restEndpoint) {
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            String inputLine;
            HttpURLConnection connection = this.openConnection(restEndpoint);
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            if (connection instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
            }
            connection.setRequestProperty("charset", "utf-8");
            connection.setDoOutput(true);
            this.addAuthenticationProperty(connection);
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = reader.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.SEVERE, "Received a SocketTimeoutException when invoking Sauce REST API, check status.saucelabs.com for network outages", e);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "Error retrieving Sauce Results", e);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing Sauce input stream", e);
        }
        return builder.toString();
    }

    private BufferedInputStream downloadFileData(String jobId, URL restEndpoint) throws SauceException.NotAuthorized, IOException {
        logger.log(Level.FINE, "Downloading asset " + restEndpoint.toString() + " For Job " + jobId);
        logger.log(Level.FINEST, "Opening connection for Job " + jobId);
        HttpURLConnection connection = this.openConnection(restEndpoint);
        connection.setRequestProperty("User-Agent", this.getUserAgent());
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        this.addAuthenticationProperty(connection);
        Integer responseCode = connection.getResponseCode();
        logger.log(Level.FINEST, responseCode.toString() + " - " + restEndpoint + " for: " + jobId);
        switch (responseCode) {
            case 404: {
                String error = ErrorExplainers.resourceMissing();
                String path = restEndpoint.getPath();
                if (path.endsWith("mp4")) {
                    error = String.join((CharSequence)System.lineSeparator(), error, ErrorExplainers.videoMissing());
                } else if (path.endsWith("har")) {
                    error = String.join((CharSequence)System.lineSeparator(), error, ErrorExplainers.HARMissing());
                }
                throw new FileNotFoundException(error);
            }
            case 401: {
                String errorReasons = new String();
                if (this.username == null || this.username.isEmpty()) {
                    errorReasons = String.join((CharSequence)System.lineSeparator(), "Your username is empty or blank.");
                }
                if (this.accessKey == null || this.accessKey.isEmpty()) {
                    errorReasons = String.join((CharSequence)System.lineSeparator(), "Your access key is empty or blank.");
                }
                errorReasons = !errorReasons.isEmpty() ? String.join((CharSequence)System.lineSeparator(), errorReasons, ErrorExplainers.missingCreds()) : ErrorExplainers.incorrectCreds(this.username, this.accessKey);
                throw new SauceException.NotAuthorized(errorReasons);
            }
        }
        logger.log(Level.FINEST, "Obtaining input stream for request issued for Job " + jobId);
        InputStream stream = connection.getInputStream();
        BufferedInputStream in = new BufferedInputStream(stream);
        return in;
    }

    private boolean saveFile(String jobId, String location, String fileName, URL restEndpoint) {
        try {
            this.saveFileOrThrowException(jobId, location, fileName, restEndpoint);
            return true;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error downloading Sauce Results", e);
            return false;
        }
    }

    private String getDefaultFileName(String jobId, URL restEndpoint) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        String saveName = jobId + format.format(new Date());
        String extension = this.getExtension(restEndpoint);
        saveName = saveName + extension;
        return saveName;
    }

    private void saveFileOrThrowException(String jobId, String location, String fileName, URL restEndpoint) throws SauceException.NotAuthorized, IOException {
        String jobAndAsset = restEndpoint.toString() + " for Job " + jobId;
        logger.log(Level.FINEST, "Attempting to save asset " + jobAndAsset + " to " + location);
        BufferedInputStream in = this.downloadFileData(jobId, restEndpoint);
        if (fileName == null || fileName.length() < 1) {
            fileName = this.getDefaultFileName(jobId, restEndpoint);
        }
        File targetFile = new File(location, fileName.replaceAll("\\/", "_"));
        System.out.println("Saving " + jobAndAsset + " as " + targetFile);
        logger.log(Level.FINEST, "Saving " + jobAndAsset + " as " + targetFile);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));){
            int i;
            while ((i = in.read()) != -1) {
                out.write(i);
            }
            out.flush();
        }
    }

    private String getExtension(URL restEndpoint) {
        if (restEndpoint.getPath().endsWith(".mp4")) {
            return ".mp4";
        }
        if (restEndpoint.getPath().endsWith(".har")) {
            return ".har";
        }
        if (restEndpoint.getPath().endsWith(".json")) {
            return ".json";
        }
        return ".log";
    }

    protected void addAuthenticationProperty(HttpURLConnection connection) {
        if (this.username != null && this.accessKey != null) {
            String auth = this.encodeAuthentication();
            logger.log(Level.FINE, "Encoded Authorization: " + auth);
            connection.setRequestProperty("Authorization", auth);
        }
    }

    public void updateJobInfo(String jobId, Map<String, Object> updates) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId);
            postBack = this.openConnection(restEndpoint);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            postBack.setDoOutput(true);
            postBack.setRequestMethod("PUT");
            this.addAuthenticationProperty(postBack);
            postBack.getOutputStream().write(new JSONObject(updates).toString().getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error updating Sauce Results", e);
        }
        this.closeInputStream(postBack);
    }

    public void stopJob(String jobId) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId + "/stop");
            postBack = this.openConnection(restEndpoint);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            postBack.setDoOutput(true);
            postBack.setRequestMethod("PUT");
            this.addAuthenticationProperty(postBack);
            postBack.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(postBack);
    }

    public void deleteJob(String jobId) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = this.buildURL(this.username + "/jobs/" + jobId);
            postBack = this.openConnection(restEndpoint);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            postBack.setDoOutput(true);
            postBack.setRequestMethod("DELETE");
            this.addAuthenticationProperty(postBack);
            postBack.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(postBack);
    }

    private void closeInputStream(HttpURLConnection connection) {
        try {
            if (connection != null) {
                connection.getInputStream().close();
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.SEVERE, "Received a SocketTimeoutException when invoking Sauce REST API, check status.saucelabs.com for network outages", e);
        }
        catch (IOException e) {
            try {
                int responseCode = connection.getResponseCode();
                if (responseCode == 401) {
                    throw new SauceException.NotAuthorized();
                }
                if (responseCode == 429) {
                    throw new SauceException.TooManyRequests();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Error determining response code", e);
            }
            logger.log(Level.WARNING, "Error closing result stream", e);
        }
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection con;
        if ("true".equals(System.getenv("USE_PROXY"))) {
            logger.log(Level.SEVERE, "Using proxy: " + System.getenv("http.proxyHost") + System.getenv("http.proxyPort"));
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getenv("http.proxyHost"), Integer.parseInt(System.getenv("http.proxyPort"))));
            con = (HttpURLConnection)url.openConnection(proxy);
        } else {
            con = (HttpURLConnection)url.openConnection();
        }
        con.setReadTimeout((int)HTTP_READ_TIMEOUT_SECONDS);
        con.setConnectTimeout((int)HTTP_CONNECT_TIMEOUT_SECONDS);
        return con;
    }

    public String uploadFile(File file) throws IOException {
        return this.uploadFile(file, file.getName());
    }

    public String uploadFile(File file, String fileName) throws IOException {
        return this.uploadFile(file, fileName, true);
    }

    @Deprecated
    public String uploadFile(File file, String fileName, Boolean overwrite) throws IOException {
        return this.uploadFile(file, fileName, (boolean)overwrite);
    }

    public String uploadFile(File file, String fileName, boolean overwrite) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String string = this.uploadFile((InputStream)is, fileName, overwrite);
            return string;
        }
    }

    @Deprecated
    public String uploadFile(InputStream is, String fileName, Boolean overwrite) throws IOException {
        return this.uploadFile(is, fileName, (boolean)overwrite);
    }

    public String uploadFile(InputStream is, String fileName, boolean overwrite) throws IOException {
        try {
            String line;
            int c;
            URL restEndpoint = this.buildURL("storage/" + this.username + "/" + fileName + "?overwrite=" + overwrite);
            HttpURLConnection connection = this.openConnection(restEndpoint);
            if (connection instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
            }
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            this.addAuthenticationProperty(connection);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            DataOutputStream oos = new DataOutputStream(connection.getOutputStream());
            byte[] buf = new byte[8192];
            while ((c = is.read(buf, 0, buf.length)) > 0) {
                oos.write(buf, 0, c);
                oos.flush();
            }
            oos.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                builder.append(line);
            }
            JSONObject sauceUploadResponse = new JSONObject(builder.toString());
            if (sauceUploadResponse.has("error")) {
                throw new UnexpectedException("Failed to upload to sauce-storage: " + sauceUploadResponse.getString("error"));
            }
            return sauceUploadResponse.getString("md5");
        }
        catch (JSONException e) {
            throw new UnexpectedException("Failed to parse json response.", (Exception)((Object)e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedException("Failed to get algorithm.", e);
        }
        catch (KeyManagementException e) {
            throw new UnexpectedException("Failed to get key management.", e);
        }
    }

    public String getPublicJobLink(String jobId) {
        try {
            String key = this.username + ":" + this.accessKey;
            String auth_token = SecurityUtils.hmacEncode("HmacMD5", jobId, key);
            return this.server + "jobs/" + jobId + "?auth=" + auth_token;
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "Unable to create an authenticated public link to job:", ex);
            return "";
        }
    }

    protected String encodeAuthentication() {
        String auth = this.username + ":" + this.accessKey;
        auth = "Basic " + Base64.encodeBase64String((byte[])auth.getBytes());
        return auth;
    }

    public void deleteTunnel(String tunnelId) {
        HttpURLConnection connection = null;
        try {
            URL restEndpoint = this.buildURL(this.username + "/tunnels/" + tunnelId);
            connection = this.openConnection(restEndpoint);
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            connection.setDoOutput(true);
            connection.setRequestMethod("DELETE");
            this.addAuthenticationProperty(connection);
            connection.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(connection);
    }

    public String getTunnels() {
        URL restEndpoint = this.buildURL(this.username + "/tunnels");
        return this.retrieveResults(restEndpoint);
    }

    public String getTunnelInformation(String tunnelId) {
        URL restEndpoint = this.buildURL(this.username + "/tunnels/" + tunnelId);
        return this.retrieveResults(restEndpoint);
    }

    public String getConcurrency() {
        URL restEndpoint = this.buildURL("users/" + this.username + "/concurrency");
        return this.retrieveResults(restEndpoint);
    }

    public String getActivity() {
        URL restEndpoint = this.buildURL(this.username + "/activity");
        return this.retrieveResults(restEndpoint);
    }

    public String getStoredFiles() {
        URL restEndpoint = this.buildURL("storage/" + this.username);
        return this.retrieveResults(restEndpoint);
    }

    public String getUser() {
        URL restEndpoint = this.buildURL("users/" + this.username);
        return this.retrieveResults(restEndpoint);
    }

    public String getSupportedPlatforms(String automationApi) {
        URL restEndpoint = this.buildURL("info/platforms/" + automationApi);
        return this.retrieveResults(restEndpoint);
    }

    public String getBuildFullJobs(String build, int limit) {
        URL restEndpoint = this.buildURL(this.username + "/build/" + build + "/jobs?full=1" + (limit == 0 ? "" : "&limit=" + limit));
        return this.retrieveResults(restEndpoint);
    }

    public String getBuildFullJobs(String build) {
        return this.getBuildFullJobs(build, 0);
    }

    public String getBuild(String build) {
        URL restEndpoint = this.buildURL(this.username + "/builds/" + build);
        return this.retrieveResults(restEndpoint);
    }

    public boolean recordCI(String platform, String platformVersion) {
        URL restEndpoint = this.buildURL("stats/ci");
        JSONObject obj = new JSONObject();
        try {
            obj.put("platform", (Object)platform);
            obj.put("platform_version", (Object)platformVersion);
        }
        catch (JSONException e) {
            logger.log(Level.SEVERE, "Error attempting to craft json:", e);
            return false;
        }
        try {
            this.doJSONPOST(restEndpoint, obj);
        }
        catch (SauceException e) {
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SauceREST)) {
            return super.equals(obj);
        }
        SauceREST sauceobj = (SauceREST)obj;
        return Objects.equals(sauceobj.username, this.username) && Objects.equals(sauceobj.accessKey, this.accessKey) && Objects.equals(sauceobj.server, this.server);
    }
}

