/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

public enum DataCenter {
    US("https://saucelabs.com/", "https://eds.us-west-1.saucelabs.com/", "https://app.saucelabs.com/"),
    EU("https://eu-central-1.saucelabs.com/", "https://eds.eu-central-1.saucelabs.com/", "https://app.eu-central-1.saucelabs.com/"),
    US_EAST("https://us-east-1.saucelabs.com/", "https://eds.us-east-1.saucelabs.com/", "https://app.us-east-1.saucelabs.com/");

    public final String server;
    public final String edsServer;
    public final String appServer;

    private DataCenter(String server, String edsServer, String appServer) {
        this.server = server;
        this.edsServer = edsServer;
        this.appServer = appServer;
    }

    public String server() {
        return this.server;
    }

    public String edsServer() {
        return this.edsServer;
    }

    public String appServer() {
        return this.appServer;
    }

    public static DataCenter fromString(String dataCenter) {
        for (DataCenter dc : DataCenter.values()) {
            if (!dc.name().equals(dataCenter)) continue;
            return dc;
        }
        return US;
    }
}

