/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.testng;

import com.saucelabs.common.SauceOnDemandAuthentication;
import com.saucelabs.common.SauceOnDemandSessionIdProvider;
import com.saucelabs.common.Utils;
import com.saucelabs.saucerest.SauceREST;
import com.saucelabs.testng.SauceOnDemandAuthenticationProvider;
import java.util.HashMap;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class SauceOnDemandTestListener
extends TestListenerAdapter {
    private static final String SELENIUM_BROWSER = "SELENIUM_BROWSER";
    private static final String SELENIUM_PLATFORM = "SELENIUM_PLATFORM";
    private static final String SELENIUM_VERSION = "SELENIUM_VERSION";
    private static final String SELENIUM_IS_LOCAL = "SELENIUM_IS_LOCAL";
    private SauceREST sauceREST;
    private boolean isLocal = false;
    public static boolean verboseMode = true;

    public void onStart(ITestContext testContext) {
        String version;
        String platform;
        String browser;
        super.onStart(testContext);
        String local = Utils.readPropertyOrEnv((String)SELENIUM_IS_LOCAL, (String)"");
        if (local != null && !local.equals("")) {
            this.isLocal = true;
        }
        if ((browser = System.getenv(SELENIUM_BROWSER)) != null && !browser.equals("")) {
            System.setProperty("browser", browser);
        }
        if ((platform = System.getenv(SELENIUM_PLATFORM)) != null && !platform.equals("")) {
            System.setProperty("os", platform);
        }
        if ((version = System.getenv(SELENIUM_VERSION)) != null && !version.equals("")) {
            System.setProperty("version", version);
        }
    }

    public void onTestStart(ITestResult result) {
        SauceOnDemandAuthentication sauceOnDemandAuthentication;
        super.onTestStart(result);
        if (this.isLocal) {
            return;
        }
        if (result.getInstance() instanceof SauceOnDemandAuthenticationProvider) {
            SauceOnDemandAuthenticationProvider provider = (SauceOnDemandAuthenticationProvider)result.getInstance();
            sauceOnDemandAuthentication = provider.getAuthentication();
        } else {
            sauceOnDemandAuthentication = new SauceOnDemandAuthentication();
        }
        this.sauceREST = new SauceREST(sauceOnDemandAuthentication.getUsername(), sauceOnDemandAuthentication.getAccessKey());
    }

    public void onTestFailure(ITestResult testResult) {
        SauceOnDemandSessionIdProvider sessionIdProvider = (SauceOnDemandSessionIdProvider)testResult.getInstance();
        if (sessionIdProvider != null && this.sauceREST != null) {
            String sessionId = sessionIdProvider.getSessionId();
            this.markJobStatus(sessionId, false);
            this.printOutSessionID(sessionId, testResult.getMethod().getMethodName());
            this.printPublicJobLink(sessionId);
        }
        super.onTestFailure(testResult);
    }

    private void markJobStatus(String sessionId, boolean passed) {
        try {
            HashMap<String, Boolean> updates = new HashMap<String, Boolean>();
            updates.put("passed", passed);
            this.sauceREST.updateJobInfo(sessionId, updates);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printPublicJobLink(String sessionId) {
        if (verboseMode) {
            String authLink = this.sauceREST.getPublicJobLink(sessionId);
            System.out.println("Job link: " + authLink);
        }
    }

    private void printOutSessionID(String sessionId, String testName) {
        System.out.println(String.format("SauceOnDemandSessionID=%1$s job-name=%2$s", sessionId, testName));
    }

    public void onTestSuccess(ITestResult testResult) {
        SauceOnDemandSessionIdProvider sessionIdProvider = (SauceOnDemandSessionIdProvider)testResult.getInstance();
        String sessionId = sessionIdProvider.getSessionId();
        this.printOutSessionID(sessionId, testResult.getMethod().getMethodName());
        this.markJobStatus(sessionId, true);
        super.onTestSuccess(testResult);
    }
}

