/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.testng;

import com.saucelabs.common.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.testng.annotations.DataProvider;

public class SauceBrowserDataProvider {
    public static final String SAUCE_ONDEMAND_BROWSERS = "SAUCE_ONDEMAND_BROWSERS";

    @DataProvider(name="sauceBrowserDataProvider")
    public static Iterator<Object[]> sauceBrowserDataProvider(Method testMethod) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        String json = Utils.readPropertyOrEnv((String)SAUCE_ONDEMAND_BROWSERS, (String)"");
        if (json == null || json.equals("")) {
            throw new IllegalArgumentException("Unable to find JSON");
        }
        try {
            JSONArray browsers = (JSONArray)new JSONParser().parse(json);
            for (Object object : browsers) {
                JSONObject jsonObject = (JSONObject)object;
                data.add(new Object[]{jsonObject.get((Object)"browser"), jsonObject.get((Object)"version"), jsonObject.get((Object)"os")});
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error parsing JSON String", e);
        }
        return data.iterator();
    }
}

