/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.ci.sauceconnect;

import com.saucelabs.ci.sauceconnect.SauceTunnelManager;
import com.saucelabs.ci.sauceconnect.TunnelInformation;
import com.saucelabs.saucerest.SauceREST;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractSauceTunnelManager
implements SauceTunnelManager {
    protected static final Logger julLogger = Logger.getLogger(AbstractSauceTunnelManager.class.getName());
    protected boolean quietMode;
    private Map<String, List<Process>> openedProcesses = new HashMap<String, List<Process>>();
    protected Map<String, TunnelInformation> tunnelInformationMap = new ConcurrentHashMap<String, TunnelInformation>();
    private SauceREST sauceRest;
    private AtomicInteger launchAttempts = new AtomicInteger(0);

    public AbstractSauceTunnelManager(boolean quietMode) {
        this.quietMode = quietMode;
    }

    public void setSauceRest(SauceREST sauceRest) {
        this.sauceRest = sauceRest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeTunnelsForPlan(String userName, String options, PrintStream printStream) {
        String identifier = AbstractSauceTunnelManager.getTunnelIdentifier(options, userName);
        TunnelInformation tunnelInformation = this.getTunnelInformation(identifier);
        if (tunnelInformation == null) {
            return;
        }
        try {
            tunnelInformation.getLock().lock();
            int count = this.decrementProcessCountForUser(tunnelInformation, printStream);
            if (count == 0) {
                Process sauceConnect = tunnelInformation.getProcess();
                this.closeSauceConnectProcess(printStream, sauceConnect);
                String tunnelId = tunnelInformation.getTunnelId();
                if (tunnelId != null && this.sauceRest != null) {
                    this.sauceRest.deleteTunnel(tunnelId);
                }
                this.tunnelInformationMap.remove(identifier);
                List<Process> processes = this.openedProcesses.get(identifier);
                if (processes != null) {
                    processes.remove(sauceConnect);
                }
                this.logMessage(printStream, "Sauce Connect stopped for: " + identifier);
            } else {
                this.logMessage(printStream, "Jobs still running, not closing Sauce Connect");
            }
        }
        finally {
            tunnelInformation.getLock().unlock();
        }
    }

    private void closeSauceConnectProcess(PrintStream printStream, final Process sauceConnect) {
        this.logMessage(printStream, "Flushing Sauce Connect Input Stream");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)sauceConnect.getInputStream(), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
        this.logMessage(printStream, "Flushing Sauce Connect Error Stream");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)sauceConnect.getErrorStream(), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
        this.logMessage(printStream, "Closing Sauce Connect process");
        sauceConnect.destroy();
    }

    private int decrementProcessCountForUser(TunnelInformation identifier, PrintStream printStream) {
        int count = identifier.getProcessCount() - 1;
        identifier.setProcessCount(count);
        this.logMessage(printStream, "Decremented process count for " + identifier + ", now " + count);
        return count;
    }

    protected void logMessage(PrintStream printStream, String message) {
        if (printStream != null) {
            printStream.println(message);
        }
        julLogger.log(Level.INFO, message);
    }

    public static String getTunnelIdentifier(String options, String defaultValue) {
        if (options == null || options.equals("")) {
            return defaultValue;
        }
        String identifier = null;
        String[] split = options.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String option = split[i];
            if (!option.equals("-i") && !option.equals("--tunnel-identifier")) continue;
            identifier = split[i + 1];
        }
        if (identifier != null) {
            return identifier;
        }
        return defaultValue;
    }

    public static String getLogfile(String options) {
        if (options == null || options.equals("")) {
            return null;
        }
        String logFile = null;
        String[] split = options.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String option = split[i];
            if (!option.equals("-l") && !option.equals("--logfile")) continue;
            logFile = split[i + 1];
        }
        return logFile;
    }

    protected String[] addElement(String[] original, String added) {
        String[] split = StringUtils.split((String)added, (char)' ');
        return this.joinArgs(original, split);
    }

    protected String[] joinArgs(String[] initial, String ... toAdd) {
        String[] result = Arrays.copyOf(initial, initial.length + toAdd.length);
        System.arraycopy(toAdd, 0, result, initial.length, toAdd.length);
        return result;
    }

    protected void incrementProcessCountForUser(TunnelInformation identifier, PrintStream printStream) {
        int processCount = identifier.getProcessCount() + 1;
        identifier.setProcessCount(processCount);
        this.logMessage(printStream, "Incremented process count for " + identifier + ", now " + processCount);
    }

    protected abstract Process prepAndCreateProcess(String var1, String var2, int var3, File var4, String var5, PrintStream var6, String var7) throws SauceConnectException;

    protected Process createProcess(String[] args, File directory) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.directory(directory);
        return processBuilder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Process openConnection(String username, String apiKey, int port, File sauceConnectJar, String options, PrintStream printStream, Boolean verboseLogging, String sauceConnectPath) throws SauceConnectException {
        if (this.sauceRest == null) {
            this.sauceRest = new SauceREST(username, apiKey);
        }
        String identifier = AbstractSauceTunnelManager.getTunnelIdentifier(options, username);
        TunnelInformation tunnelInformation = this.getTunnelInformation(identifier);
        try {
            tunnelInformation.getLock().lock();
            if (options == null) {
                options = "";
            }
            if (verboseLogging != null) {
                this.quietMode = verboseLogging == false;
            }
            String tunnelIdentifier = this.activeTunnelIdentifier(username, identifier);
            if (tunnelInformation.getProcessCount() == 0) {
                if (tunnelIdentifier != null) {
                    this.logMessage(printStream, "Detected active tunnel: " + tunnelIdentifier);
                }
            } else {
                if (tunnelIdentifier != null) {
                    this.logMessage(printStream, "Sauce Connect already running for " + identifier);
                    this.incrementProcessCountForUser(tunnelInformation, printStream);
                    Process process = tunnelInformation.getProcess();
                    return process;
                }
                this.logMessage(printStream, "Process count non-zero, but no active tunnels found for identifier: " + identifier);
                this.logMessage(printStream, "Process count reset to zero");
                tunnelInformation.setProcessCount(0);
            }
            Process process = this.prepAndCreateProcess(username, apiKey, port, sauceConnectJar, options, printStream, sauceConnectPath);
            List<Process> openedProcesses = this.openedProcesses.get(tunnelIdentifier);
            try {
                Semaphore semaphore = new Semaphore(1);
                semaphore.acquire();
                SystemErrorGobbler errorGobbler = this.makeErrorGobbler(printStream, process.getErrorStream());
                errorGobbler.start();
                SystemOutGobbler outputGobbler = this.makeOutputGobbler(printStream, process.getInputStream(), semaphore);
                outputGobbler.start();
                boolean sauceConnectStarted = semaphore.tryAcquire(3L, TimeUnit.MINUTES);
                if (sauceConnectStarted) {
                    if (outputGobbler.isFailed()) {
                        String message = "Error launching Sauce Connect";
                        this.logMessage(printStream, message);
                        this.closeSauceConnectProcess(printStream, process);
                        throw new SauceConnectDidNotStartException(message);
                    }
                    if (outputGobbler.isCantLockPidfile()) {
                        this.logMessage(printStream, "Sauce Connect can't lock pidfile, attempting to close open Sauce Connect processes");
                        for (Process openedProcess : openedProcesses) {
                            openedProcess.destroy();
                        }
                        if (this.launchAttempts.get() < 3) {
                            Thread.sleep(5000L);
                            this.launchAttempts.incrementAndGet();
                            Process message = this.openConnection(username, apiKey, port, sauceConnectJar, options, printStream, verboseLogging, sauceConnectPath);
                            return message;
                        }
                        throw new SauceConnectDidNotStartException("Unable to start Sauce Connect, please see the Sauce Connect log");
                    }
                    if (outputGobbler.getTunnelId() != null) {
                        tunnelInformation.setTunnelId(outputGobbler.getTunnelId());
                    }
                } else {
                    File sauceConnectLogFile = this.getSauceConnectLogFile(options);
                    String message = sauceConnectLogFile != null ? "Time out while waiting for Sauce Connect to start, please check the Sauce Connect log located in " + sauceConnectLogFile.getAbsoluteFile() : "Time out while waiting for Sauce Connect to start, please check the Sauce Connect log";
                    this.logMessage(printStream, message);
                    this.closeSauceConnectProcess(printStream, process);
                    throw new SauceConnectDidNotStartException(message);
                }
                this.logMessage(printStream, "Sauce Connect " + this.getCurrentVersion() + " now launched for: " + identifier);
            }
            catch (InterruptedException e) {
                julLogger.log(Level.WARNING, "Exception occurred during invocation of Sauce Connect", e);
            }
            this.incrementProcessCountForUser(tunnelInformation, printStream);
            tunnelInformation.setProcess(process);
            List<Process> processes = openedProcesses;
            if (processes == null) {
                processes = new ArrayList<Process>();
                this.openedProcesses.put(identifier, processes);
            }
            processes.add(process);
            Process process2 = process;
            return process2;
        }
        finally {
            tunnelInformation.getLock().unlock();
            this.launchAttempts.set(0);
        }
    }

    public SystemErrorGobbler makeErrorGobbler(PrintStream printStream, InputStream errorStream) {
        return new SystemErrorGobbler("ErrorGobbler", errorStream, printStream);
    }

    public SystemOutGobbler makeOutputGobbler(PrintStream printStream, InputStream inputStream, Semaphore semaphore) {
        return new SystemOutGobbler("OutputGobbler", inputStream, semaphore, printStream, this.getSauceStartedMessage());
    }

    private TunnelInformation getTunnelInformation(String identifier) {
        if (identifier == null) {
            return null;
        }
        TunnelInformation tunnelInformation = this.tunnelInformationMap.get(identifier);
        if (tunnelInformation == null) {
            tunnelInformation = new TunnelInformation(identifier);
            this.tunnelInformationMap.put(identifier, tunnelInformation);
        }
        return tunnelInformation;
    }

    private String activeTunnelIdentifier(String username, String identifier) {
        try {
            JSONArray tunnelArray = new JSONArray(this.sauceRest.getTunnels());
            if (tunnelArray.length() == 0) {
                return null;
            }
            for (int i = 0; i < tunnelArray.length(); ++i) {
                String tunnelId = tunnelArray.getString(i);
                JSONObject tunnelInformation = new JSONObject(this.sauceRest.getTunnelInformation(tunnelId));
                String tunnelIdentifier = tunnelInformation.getString("tunnel_identifier");
                String status = tunnelInformation.getString("status");
                if ((!status.equals("running") || !tunnelIdentifier.equals("null") || !identifier.equals(username)) && (tunnelIdentifier.equals("null") || !tunnelIdentifier.equals(identifier))) continue;
                return tunnelId;
            }
        }
        catch (JSONException e) {
            julLogger.log(Level.WARNING, "Exception occurred retrieving tunnel information", e);
        }
        return null;
    }

    protected abstract String getCurrentVersion();

    protected abstract String[] generateSauceConnectArgs(String[] var1, String var2, String var3, int var4, String var5);

    public String getSauceConnectWorkingDirectory() {
        return System.getProperty("user.home");
    }

    public abstract File getSauceConnectLogFile(String var1);

    protected abstract String getSauceStartedMessage();

    public static class SauceConnectDidNotStartException
    extends SauceConnectException {
        public SauceConnectDidNotStartException(String message) {
            super(message);
        }
    }

    public static class SauceConnectException
    extends IOException {
        public SauceConnectException(String message) {
            super(message);
        }

        public SauceConnectException(Exception cause) {
            super(cause);
        }
    }

    public class SystemErrorGobbler
    extends StreamGobbler {
        public SystemErrorGobbler(String name, InputStream is, PrintStream printStream) {
            super(name, is, printStream);
        }
    }

    public class SystemOutGobbler
    extends StreamGobbler {
        private final Semaphore semaphore;
        private final String startedMessage;
        private String tunnelId;
        private boolean failed;
        private boolean cantLockPidfile;

        public SystemOutGobbler(String name, InputStream is, Semaphore semaphore, PrintStream printStream, String startedMessage) {
            super(name, is, printStream);
            this.semaphore = semaphore;
            this.startedMessage = startedMessage;
        }

        @Override
        protected void processLine(String line) {
            super.processLine(line);
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"can't lock pidfile")) {
                this.cantLockPidfile = true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Tunnel ID:")) {
                this.tunnelId = StringUtils.substringAfter((String)line, (String)"Tunnel ID: ").trim();
            }
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Provisioned tunnel:")) {
                this.tunnelId = StringUtils.substringAfter((String)line, (String)"Provisioned tunnel:").trim();
            }
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"Goodbye")) {
                this.failed = true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)this.startedMessage) || this.failed || this.cantLockPidfile) {
                this.semaphore.release();
            }
        }

        public String getTunnelId() {
            return this.tunnelId;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public boolean isCantLockPidfile() {
            return this.cantLockPidfile;
        }
    }

    protected abstract class StreamGobbler
    extends Thread {
        private final PrintStream printStream;
        private final InputStream is;

        public StreamGobbler(String name, InputStream is, PrintStream printStream) {
            super(name);
            this.is = is;
            this.printStream = printStream;
        }

        @Override
        public void run() {
            block3: {
                try {
                    String line;
                    InputStreamReader isr = new InputStreamReader(this.is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        this.processLine(line);
                    }
                }
                catch (IOException ioe) {
                    if (ioe.getMessage().equalsIgnoreCase("stream closed")) break block3;
                    ioe.printStackTrace();
                }
            }
        }

        protected void processLine(String line) {
            if (!AbstractSauceTunnelManager.this.quietMode) {
                if (this.printStream != null) {
                    this.printStream.println(line);
                }
                System.out.println(line);
                julLogger.info(line);
            }
        }
    }
}

