/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.ci;

import com.saucelabs.ci.OperatingSystemDescription;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class JobInformation
implements Serializable {
    private String jobId;
    private String hmac;
    private String status;
    private String name;
    private String os;
    private String browser;
    private String version;
    private String videoUrl;
    private String logUrl;
    private String build;
    private long startTime;
    private long endTime;
    private String failureMessage;
    private final HashMap<String, Object> changes = new HashMap();

    public JobInformation(String jobId, String hmac) {
        this.jobId = jobId;
        this.hmac = hmac;
    }

    public String getHmac() {
        return this.hmac;
    }

    public void setHmac(String hmac) {
        this.hmac = hmac;
    }

    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public void setStatus(@Nonnull Boolean status) {
        this.setStatus(status != false ? "Passed" : "Failed");
    }

    public void setStatus(@Nullable String status) {
        this.status = status;
        this.changes.put("status", status);
    }

    public boolean hasJobName() {
        return this.name != null && !this.name.equals("") && !this.name.equals("null");
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
        this.changes.put("name", name);
    }

    public boolean hasBuild() {
        return this.build != null && !this.build.equals("") && !this.build.equals("null");
    }

    @Nullable
    public String getBuild() {
        return this.build;
    }

    public void setBuild(@Nullable String build) {
        this.build = build;
        this.changes.put("build", build);
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
        this.changes.put("browser", browser);
    }

    public String getOs() {
        return OperatingSystemDescription.getOperatingSystemName(this.os);
    }

    public void setOs(String os) {
        this.os = os;
        this.changes.put("os", os);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.changes.put("version", version);
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.changes.put("startTime", startTime);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
        this.changes.put("endTime", endTime);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobInformation that = (JobInformation)o;
        if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
            return false;
        }
        if (this.hmac != null ? !this.hmac.equals(that.hmac) : that.hmac != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.os != null ? !this.os.equals(that.os) : that.os != null) {
            return false;
        }
        if (this.browser != null ? !this.browser.equals(that.browser) : that.browser != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.videoUrl != null ? !this.videoUrl.equals(that.videoUrl) : that.videoUrl != null) {
            return false;
        }
        if (this.logUrl != null ? !this.logUrl.equals(that.logUrl) : that.logUrl != null) {
            return false;
        }
        if (this.build != null ? !this.build.equals(that.build) : that.build != null) {
            return false;
        }
        if (this.failureMessage != null ? !this.failureMessage.equals(that.failureMessage) : that.failureMessage != null) {
            return false;
        }
        if (this.startTime != that.startTime) {
            return false;
        }
        if (this.endTime != that.endTime) {
            return false;
        }
        return this.changes != null ? this.changes.equals(that.changes) : that.changes == null;
    }

    public int hashCode() {
        return this.jobId != null ? this.jobId.hashCode() : 0;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
        this.changes.put("videoUrl", videoUrl);
    }

    public String getVideoUrl() {
        return this.videoUrl;
    }

    public void setLogUrl(String logUrl) {
        this.logUrl = logUrl;
        this.changes.put("logUrl", logUrl);
    }

    public String getLogUrl() {
        return this.logUrl;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        this.changes.put("failureMessage", failureMessage);
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMessage;
    }

    public boolean hasFailureMessage() {
        return this.failureMessage != null && !this.failureMessage.equals("") && !this.failureMessage.equals("null");
    }

    public void populateFromJson(JSONObject jobData) throws JSONException {
        JSONObject customData;
        if (jobData.has("passed") && !jobData.isNull("passed")) {
            this.setStatus(jobData.getBoolean("passed"));
        }
        if (jobData.has("name") && !jobData.isNull("name")) {
            this.setName(jobData.getString("name"));
        }
        if (jobData.has("build") && !jobData.isNull("build")) {
            this.setBuild(jobData.getString("build"));
        }
        if (jobData.has("custom-data") && !jobData.isNull("custom-data") && (customData = jobData.getJSONObject("custom-data")).has("FAILURE_MESSAGE")) {
            String failureMessage = customData.getString("FAILURE_MESSAGE");
            this.setFailureMessage(failureMessage);
        }
        if (jobData.has("end_time") && !jobData.isNull("end_time")) {
            this.setEndTime(jobData.getLong("end_time"));
        }
        this.setStartTime(jobData.getLong("start_time"));
        this.setOs(jobData.getString("os"));
        this.setBrowser(jobData.getString("browser"));
        this.setVersion(jobData.getString("browser_short_version"));
        this.setVideoUrl(jobData.getString("video_url"));
        this.setLogUrl(jobData.getString("log_url"));
        this.clearChanges();
    }

    public boolean hasChange(String field) {
        return this.changes.containsKey(field);
    }

    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public void clearChanges() {
        this.changes.clear();
    }

    public Map<String, Object> getChanges() {
        return new HashMap<String, Object>(this.changes);
    }
}

