/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.ci;

import com.saucelabs.ci.Browser;
import com.saucelabs.ci.CacheTimeUtil;
import com.saucelabs.ci.OperatingSystemDescription;
import com.saucelabs.saucerest.SauceREST;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BrowserFactory {
    private static final Logger logger = Logger.getLogger(BrowserFactory.class.getName());
    public static final int ONE_HOUR_IN_MILLIS = 3600000;
    private SauceREST sauceREST;
    private Map<String, Browser> seleniumLookup = new HashMap<String, Browser>();
    private Map<String, Browser> appiumLookup = new HashMap<String, Browser>();
    private Map<String, Browser> webDriverLookup = new HashMap<String, Browser>();
    protected Timestamp lastLookup = null;
    private static final String IEHTA = "iehta";
    private static final String CHROME = "chrome";
    private static BrowserFactory instance;

    public BrowserFactory() {
        this(null);
    }

    public BrowserFactory(SauceREST sauceREST) {
        this.sauceREST = sauceREST == null ? new SauceREST(null, null) : sauceREST;
        try {
            this.initializeWebDriverBrowsers();
            this.initializeAppiumBrowsers();
        }
        catch (JSONException e) {
            logger.log(Level.WARNING, "Error retrieving browsers, attempting to continue", e);
        }
    }

    public List<Browser> getAppiumBrowsers() throws JSONException {
        List<Browser> browsers = this.shouldRetrieveBrowsers() ? this.initializeAppiumBrowsers() : new ArrayList<Browser>(this.appiumLookup.values());
        Collections.sort(browsers);
        return browsers;
    }

    public List<Browser> getWebDriverBrowsers() throws JSONException {
        List<Browser> browsers = this.shouldRetrieveBrowsers() ? this.initializeWebDriverBrowsers() : new ArrayList<Browser>(this.webDriverLookup.values());
        Collections.sort(browsers);
        return browsers;
    }

    public boolean shouldRetrieveBrowsers() {
        return this.lastLookup == null || CacheTimeUtil.pastAcceptableDuration(this.lastLookup, 3600000L);
    }

    private List<Browser> initializeAppiumBrowsers() throws JSONException {
        List<Browser> browsers = this.getAppiumBrowsersFromSauceLabs();
        this.appiumLookup = new HashMap<String, Browser>();
        for (Browser browser : browsers) {
            this.appiumLookup.put(browser.getKey(), browser);
        }
        this.lastLookup = new Timestamp(new Date().getTime());
        return browsers;
    }

    private List<Browser> initializeWebDriverBrowsers() throws JSONException {
        List<Browser> browsers = this.getWebDriverBrowsersFromSauceLabs();
        this.webDriverLookup = new HashMap<String, Browser>();
        for (Browser browser : browsers) {
            this.webDriverLookup.put(browser.getKey(), browser);
        }
        this.lastLookup = new Timestamp(new Date().getTime());
        return browsers;
    }

    private List<Browser> getWebDriverBrowsersFromSauceLabs() throws JSONException {
        String response = this.sauceREST.getSupportedPlatforms("webdriver");
        if (response.equals("")) {
            response = "[]";
        }
        return this.getBrowserListFromJson(response);
    }

    private List<Browser> getAppiumBrowsersFromSauceLabs() throws JSONException {
        String response = this.sauceREST.getSupportedPlatforms("appium");
        if (response.equals("")) {
            response = "[]";
        }
        return this.getBrowserListFromJson(response);
    }

    public List<Browser> getBrowserListFromJson(String browserListJson) throws JSONException {
        HashMap<String, Browser> browsers = new HashMap<String, Browser>();
        JSONArray browserArray = new JSONArray(browserListJson);
        for (int i = 0; i < browserArray.length(); ++i) {
            String shortVersion;
            String osName;
            String longVersion;
            String longName;
            String seleniumName;
            JSONObject browserObject = browserArray.getJSONObject(i);
            if (browserObject.length() == 0 || (seleniumName = browserObject.getString("api_name")).equals(IEHTA)) continue;
            if (browserObject.has("device")) {
                longName = browserObject.getString("long_name");
                longVersion = browserObject.getString("long_version");
                osName = browserObject.getString("api_name");
                shortVersion = browserObject.getString("short_version");
                String device = longName;
                String deviceType = null;
                if (browserObject.has("device-type")) {
                    deviceType = browserObject.getString("device-type");
                }
                if (device.equalsIgnoreCase("ipad") || device.equalsIgnoreCase("iphone")) {
                    device = device + " Simulator";
                    osName = "iOS";
                    seleniumName = "Safari";
                }
                Browser browser = this.createDeviceBrowser(seleniumName, longName, longVersion, osName, device, deviceType, shortVersion, "portrait");
                browsers.put(browser.getKey(), browser);
                browser = this.createDeviceBrowser(seleniumName, longName, longVersion, osName, device, deviceType, shortVersion, "landscape");
                browsers.put(browser.getKey(), browser);
                continue;
            }
            longName = browserObject.getString("long_name");
            longVersion = browserObject.getString("long_version");
            osName = browserObject.getString("os");
            shortVersion = browserObject.getString("short_version");
            Browser browser = this.createBrowserBrowser(seleniumName, longName, "latest", osName, "latest");
            browsers.put(browser.getKey(), browser);
            browser = this.createBrowserBrowser(seleniumName, longName, longVersion, osName, shortVersion);
            browsers.put(browser.getKey(), browser);
        }
        return new ArrayList<Browser>(browsers.values());
    }

    private Browser createDeviceBrowser(String seleniumName, String longName, String longVersion, String osName, String device, String deviceType, String shortVersion, String orientation) {
        String browserKey = device + orientation + seleniumName + longVersion;
        browserKey = browserKey.replaceAll(" ", "_");
        browserKey = browserKey.replaceAll("\\.", "_");
        StringBuilder label = new StringBuilder();
        label.append(longName).append(' ');
        if (deviceType != null) {
            label.append(deviceType).append(' ');
        }
        label.append(shortVersion);
        label.append(" (").append(orientation).append(')');
        Browser browser = new Browser(browserKey, osName, seleniumName, longName, shortVersion, longVersion, label.toString());
        browser.setDevice(device);
        browser.setDeviceType(deviceType);
        browser.setDeviceOrientation(orientation);
        return browser;
    }

    private Browser createBrowserBrowser(String seleniumName, String longName, String longVersion, String osName, String shortVersion) {
        String browserKey = osName + seleniumName + shortVersion;
        browserKey = browserKey.replaceAll(" ", "_");
        browserKey = browserKey.replaceAll("\\.", "_");
        String label = OperatingSystemDescription.getOperatingSystemName(osName) + " " + longName + " " + shortVersion;
        return new Browser(browserKey, osName, seleniumName, longName, shortVersion, longVersion, label);
    }

    public Browser seleniumBrowserForKey(String key) {
        return this.seleniumLookup.get(key);
    }

    public Browser seleniumBrowserForKey(String key, boolean useLatestVersion) {
        Browser browser = this.webDriverBrowserForKey(key);
        if (useLatestVersion) {
            return this.getLatestSeleniumBrowserVersion(browser);
        }
        return browser;
    }

    private Browser getLatestSeleniumBrowserVersion(Browser originalBrowser) {
        Browser candidateBrowser = originalBrowser;
        for (Browser browser : this.seleniumLookup.values()) {
            try {
                if (!browser.getBrowserName().equals(originalBrowser.getBrowserName()) || !browser.getOs().equals(originalBrowser.getOs()) || Integer.parseInt(browser.getLongVersion()) <= Integer.parseInt(candidateBrowser.getLongVersion())) continue;
                candidateBrowser = browser;
            }
            catch (NumberFormatException e) {}
        }
        return candidateBrowser;
    }

    public Browser webDriverBrowserForKey(String key) {
        return this.webDriverLookup.get(key);
    }

    public Browser webDriverBrowserForKey(String key, boolean useLatestVersion) {
        Browser browser = this.webDriverBrowserForKey(key);
        if (useLatestVersion) {
            return this.getLatestWebDriverBrowserVersion(browser);
        }
        return browser;
    }

    private Browser getLatestWebDriverBrowserVersion(Browser originalBrowser) {
        Browser candidateBrowser = originalBrowser;
        for (Browser browser : this.webDriverLookup.values()) {
            try {
                if (!browser.getBrowserName().equals(originalBrowser.getBrowserName()) || !browser.getOs().equals(originalBrowser.getOs()) || Integer.parseInt(browser.getLongVersion()) <= Integer.parseInt(candidateBrowser.getLongVersion())) continue;
                candidateBrowser = browser;
            }
            catch (NumberFormatException e) {}
        }
        return candidateBrowser;
    }

    public Browser appiumBrowserForKey(String key) {
        return this.appiumLookup.get(key);
    }

    public static BrowserFactory getInstance() {
        return BrowserFactory.getInstance(null);
    }

    public static BrowserFactory getInstance(SauceREST sauceREST) {
        if (instance == null) {
            instance = new BrowserFactory(sauceREST);
        }
        return instance;
    }
}

