/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.ci;

import com.saucelabs.ci.Browser;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SODSeleniumConfiguration {
    private static final Logger logger = Logger.getLogger(SODSeleniumConfiguration.class.getName());
    private String username;
    private String accessKey;
    private Browser browser;
    private String jobName;
    private boolean recordVideo;
    private List<String> userExtensions;
    private String firefoxProfileUrl;
    private int maxDuration;
    private int idleTimeout;

    public SODSeleniumConfiguration(String username, String accessKey, Browser browser) {
        this.username = username;
        this.accessKey = accessKey;
        this.browser = browser;
        this.userExtensions = new ArrayList<String>();
    }

    public String toJson() throws JSONException {
        JSONObject config = new JSONObject();
        config.put("username", (Object)this.username);
        config.put("access-key", (Object)this.accessKey);
        if (this.browser != null) {
            config.put("os", (Object)this.browser.getOs());
            config.put("browser", (Object)this.browser.getBrowserName());
            config.put("browser-version", (Object)this.browser.getVersion());
        }
        config.put("record-video", this.recordVideo);
        if (StringUtils.isNotBlank((CharSequence)this.jobName)) {
            config.put("job-name", (Object)this.jobName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.firefoxProfileUrl)) {
            config.put("firefox-profile-url", (Object)this.firefoxProfileUrl);
        }
        if (this.userExtensions.size() > 0) {
            JSONArray extArray = new JSONArray(this.userExtensions);
            config.put("user-extensions-url", (Object)extArray);
        }
        if (this.maxDuration > 0) {
            config.put("max-duration", this.maxDuration);
        }
        if (this.idleTimeout > 0) {
            config.put("idle-timeout", this.idleTimeout);
        }
        return StringEscapeUtils.escapeJava((String)config.toString());
    }

    public void addUserExtension(String ext) {
        this.userExtensions.add(ext);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public String getFirefoxProfileUrl() {
        return this.firefoxProfileUrl;
    }

    public void setFirefoxProfileUrl(String firefoxProfileUrl) {
        this.firefoxProfileUrl = firefoxProfileUrl;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration = maxDuration;
    }

    public boolean isRecordVideo() {
        return this.recordVideo;
    }

    public void setRecordVideo(boolean recordVideo) {
        this.recordVideo = recordVideo;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<String> getUserExtensions() {
        return this.userExtensions;
    }

    public void setUserExtensions(List<String> userExtensions) {
        this.userExtensions = userExtensions;
    }

    public void setUserExtensions(JSONArray userExtensionsJson) {
        for (int i = 0; i < userExtensionsJson.length(); ++i) {
            try {
                String ext = userExtensionsJson.getString(i);
                this.userExtensions.add(ext);
                continue;
            }
            catch (JSONException e) {
                logger.log(Level.WARNING, "Error parsing JSON string", e);
            }
        }
    }

    public void setUserExtensions(String jsonString) {
        if (StringUtils.isNotBlank((CharSequence)jsonString)) {
            try {
                this.setUserExtensions(new JSONArray(jsonString));
            }
            catch (JSONException e) {
                logger.log(Level.WARNING, "Error parsing JSON string", e);
            }
        }
    }
}

