/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.ci;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class BuildInformation
implements Serializable {
    private String buildId;
    private String status;
    private String name;
    private long startTime;
    private long endTime;
    private int jobsPassed;
    private int jobsFinished;
    private int jobsFailed;
    private int jobsErrored;
    private final HashMap<String, Object> changes = new HashMap();

    public BuildInformation(String buildId) {
        this.buildId = buildId;
    }

    public String getBuildId() {
        return this.buildId;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable String status) {
        this.status = status;
        this.changes.put("status", status);
    }

    public boolean hasBuildName() {
        return this.name != null && !this.name.equals("") && !this.name.equals("null");
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.changes.put("startTime", startTime);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
        this.changes.put("endTime", endTime);
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
        this.changes.put("name", name);
    }

    public int getJobsFinished() {
        return this.jobsFinished;
    }

    public void setJobsFinished(int jobsFinished) {
        this.jobsFinished = jobsFinished;
        this.changes.put("jobsFinished", jobsFinished);
    }

    public int getJobsPassed() {
        return this.jobsPassed;
    }

    public void setJobsPassed(int jobsPassed) {
        this.jobsPassed = jobsPassed;
        this.changes.put("jobsPassed", jobsPassed);
    }

    public int getJobsFailed() {
        return this.jobsFailed;
    }

    public void setJobsFailed(int jobsFailed) {
        this.jobsFailed = jobsFailed;
        this.changes.put("jobsFailed", jobsFailed);
    }

    public int getJobsErrored() {
        return this.jobsErrored;
    }

    public void setJobsErrored(int jobsErrored) {
        this.jobsErrored = jobsErrored;
        this.changes.put("jobsErrored", jobsErrored);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildInformation that = (BuildInformation)o;
        if (this.endTime != that.endTime) {
            return false;
        }
        if (this.jobsFinished != that.jobsFinished) {
            return false;
        }
        if (this.jobsPassed != that.jobsPassed) {
            return false;
        }
        if (this.jobsFailed != that.jobsFailed) {
            return false;
        }
        if (this.jobsErrored != that.jobsErrored) {
            return false;
        }
        if (this.buildId != null ? !this.buildId.equals(that.buildId) : that.buildId != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.startTime != that.startTime) {
            return false;
        }
        return this.changes != null ? this.changes.equals(that.changes) : that.changes == null;
    }

    public int hashCode() {
        return this.buildId != null ? this.buildId.hashCode() : 0;
    }

    public void populateFromJson(JSONObject buildData) throws JSONException {
        if (buildData.has("status") && !buildData.isNull("status")) {
            this.setStatus(buildData.getString("status"));
        }
        if (buildData.has("name") && !buildData.isNull("name")) {
            this.setName(buildData.getString("name"));
        }
        if (buildData.has("end_time") && !buildData.isNull("end_time")) {
            this.setEndTime(buildData.getLong("end_time"));
        }
        this.setStartTime(buildData.getLong("start_time"));
        JSONObject buildJobs = buildData.getJSONObject("jobs");
        this.setJobsFinished(buildJobs.getInt("finished"));
        this.setJobsPassed(buildJobs.getInt("passed"));
        this.setJobsFailed(buildJobs.getInt("failed"));
        this.setJobsErrored(buildJobs.getInt("errored"));
        this.clearChanges();
    }

    public boolean hasChange(String field) {
        return this.changes.containsKey(field);
    }

    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public void clearChanges() {
        this.changes.clear();
    }

    public Map<String, Object> getChanges() {
        return new HashMap<String, Object>(this.changes);
    }
}

