/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.ci.sauceconnect;

import com.saucelabs.ci.sauceconnect.AbstractSauceTunnelManager;
import com.saucelabs.ci.sauceconnect.SauceTunnelManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.json.JSONObject;

public class SauceConnectFourManager
extends AbstractSauceTunnelManager
implements SauceTunnelManager {
    private boolean useLatestSauceConnect = false;
    private boolean cleanUpOnExit;
    private static final String UNIX_TEMP_DIR = "/tmp";
    private static final String WINDOWS_TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String SAUCE_CONNECT_4_STARTED = "Sauce Connect is up, you may start your tests";
    public static final String CURRENT_SC_VERSION = "4.6.2";
    public static final String LATEST_SC_VERSION = SauceConnectFourManager.getLatestSauceConnectVersion();
    private static final String SAUCE_CONNECT = "sc-";
    public static final String SAUCE_CONNECT_4 = "sc-4.6.2";

    public SauceConnectFourManager() {
        this(false);
    }

    public SauceConnectFourManager(boolean quietMode) {
        super(quietMode);
    }

    @Override
    protected Process prepAndCreateProcess(String username, String apiKey, int port, File sauceConnectJar, String options, PrintStream printStream, String sauceConnectPath) throws AbstractSauceTunnelManager.SauceConnectException {
        try {
            File sauceConnectBinary;
            if (sauceConnectPath == null || sauceConnectPath.equals("")) {
                File workingDirectory = null;
                if (sauceConnectJar != null && sauceConnectJar.exists()) {
                    workingDirectory = sauceConnectJar.getParentFile();
                }
                if (workingDirectory == null) {
                    workingDirectory = new File(this.getSauceConnectWorkingDirectory());
                }
                if (!workingDirectory.canWrite()) {
                    throw new AbstractSauceTunnelManager.SauceConnectException("Can't write to " + workingDirectory.getAbsolutePath() + ", please check the directory permissions");
                }
                OperatingSystem operatingSystem = OperatingSystem.getOperatingSystem();
                File unzipDirectory = this.getUnzipDir(workingDirectory, operatingSystem);
                sauceConnectBinary = new File(unzipDirectory, operatingSystem.getExecutable());
                if (!sauceConnectBinary.exists()) {
                    this.extractZipFile(workingDirectory, operatingSystem);
                } else {
                    this.logMessage(printStream, sauceConnectBinary + " already exists, so not extracting");
                }
            } else {
                sauceConnectBinary = new File(sauceConnectPath);
                if (!sauceConnectBinary.exists()) {
                    throw new AbstractSauceTunnelManager.SauceConnectException(sauceConnectPath + " doesn't exist, please check the location");
                }
            }
            Object[] args = new String[]{sauceConnectBinary.getPath()};
            args = this.generateSauceConnectArgs((String[])args, username, apiKey, port, options);
            julLogger.log(Level.INFO, "Launching Sauce Connect " + this.getCurrentVersion() + " " + this.hideSauceConnectCommandlineSecrets(Arrays.toString(args)));
            return this.createProcess((String[])args, sauceConnectBinary.getParentFile());
        }
        catch (IOException e) {
            throw new AbstractSauceTunnelManager.SauceConnectException(e);
        }
    }

    public String hideSauceConnectCommandlineSecrets(String text) {
        return text.replaceAll("(-k, )\\w+-\\w+-\\w+-\\w+-\\w+", "$1****").replaceAll("(--api-key, )\\w+-\\w+-\\w+-\\w+-\\w+", "$1****").replaceAll("(-w, \\w+:)\\w+", "$1****").replaceAll("(--proxy-userpwd, \\w+:)\\w+", "$1****").replaceAll("(-a, \\w+:\\w+:\\w+:)\\w+", "$1****").replaceAll("(--auth, \\w+:\\w+:\\w+:)\\w+", "$1****");
    }

    public void setUseLatestSauceConnect(boolean useLatestSauceConnect) {
        this.useLatestSauceConnect = useLatestSauceConnect;
    }

    public void setCleanUpOnExit(boolean cleanUpOnExit) {
        this.cleanUpOnExit = cleanUpOnExit;
    }

    public static String getLatestSauceConnectVersion() {
        try {
            URL url = new URL("https://saucelabs.com/versions.json");
            String versionsJson = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            return new JSONObject(versionsJson).getJSONObject("Sauce Connect").getString("version");
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected String[] generateSauceConnectArgs(String[] args, String username, String apiKey, int port, String options) {
        args = this.addElement(args, "-u");
        args = this.addElement(args, username);
        args = this.addElement(args, "-k");
        args = this.addElement(args, apiKey);
        args = this.addElement(args, "-P");
        args = this.addElement(args, String.valueOf(port));
        if (StringUtils.isNotBlank((CharSequence)options.trim())) {
            args = this.addElement(args, options.trim());
        }
        return args;
    }

    public File extractZipFile(File workingDirectory, OperatingSystem operatingSystem) throws IOException {
        ZipUnArchiver unArchiver;
        File zipFile = this.extractFile(workingDirectory, operatingSystem.getFileName(this.useLatestSauceConnect));
        if (this.cleanUpOnExit) {
            zipFile.deleteOnExit();
        }
        if (operatingSystem == OperatingSystem.OSX || operatingSystem == OperatingSystem.WINDOWS) {
            unArchiver = new ZipUnArchiver();
        } else if (operatingSystem == OperatingSystem.LINUX || operatingSystem == OperatingSystem.LINUX32) {
            this.removeOldTarFile(zipFile);
            unArchiver = new TarGZipUnArchiver();
        } else {
            throw new RuntimeException("Unknown operating system: " + operatingSystem.name());
        }
        this.extractArchive((AbstractUnArchiver)unArchiver, zipFile, workingDirectory);
        File unzipDir = this.getUnzipDir(workingDirectory, operatingSystem);
        if (this.cleanUpOnExit) {
            unzipDir.deleteOnExit();
        }
        return unzipDir;
    }

    private File getUnzipDir(File workingDirectory, OperatingSystem operatingSystem) {
        return new File(workingDirectory, operatingSystem.getDirectory(this.useLatestSauceConnect));
    }

    private void removeOldTarFile(File zipFile) throws AbstractSauceTunnelManager.SauceConnectException {
        File tarFile = new File(zipFile.getParentFile(), zipFile.getName().replaceAll(".gz", ""));
        SauceConnectFourManager.removeFileIfExists(tarFile, "Unable to delete old tar");
    }

    private void extractArchive(AbstractUnArchiver unArchiver, File archive, File destination) {
        unArchiver.enableLogging((Logger)new ConsoleLogger(0, "Sauce"));
        unArchiver.setSourceFile(archive);
        unArchiver.setDestDirectory(destination);
        unArchiver.extract();
    }

    private File extractFile(File workingDirectory, String fileName) throws IOException {
        File destination = new File(workingDirectory, fileName);
        SauceConnectFourManager.removeFileIfExists(destination, "Unable to delete old zip");
        InputStream inputStream = this.useLatestSauceConnect ? new URL("https://saucelabs.com/downloads/" + fileName).openStream() : this.getClass().getClassLoader().getResourceAsStream(fileName);
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)destination);
        return destination;
    }

    private static void removeFileIfExists(File file, String exceptionMessage) throws AbstractSauceTunnelManager.SauceConnectException {
        if (file.exists() && !file.delete()) {
            throw new AbstractSauceTunnelManager.SauceConnectException(exceptionMessage);
        }
    }

    @Override
    protected String getSauceStartedMessage() {
        return SAUCE_CONNECT_4_STARTED;
    }

    @Override
    protected String getCurrentVersion() {
        return this.useLatestSauceConnect ? LATEST_SC_VERSION : CURRENT_SC_VERSION;
    }

    @Override
    public File getSauceConnectLogFile(String options) {
        File sauceConnectLogFile;
        String logfile = SauceConnectFourManager.getLogfile(options);
        if (logfile != null) {
            File sauceConnectLogFile2 = new File(logfile);
            if (sauceConnectLogFile2.exists()) {
                return sauceConnectLogFile2;
            }
            return null;
        }
        String fileName = "sc.log";
        File logFileDirectory = new File(OperatingSystem.getOperatingSystem().getDefaultSauceConnectLogDirectory());
        String tunnelIdentifier = SauceConnectFourManager.getTunnelIdentifier(options, null);
        if (tunnelIdentifier != null) {
            fileName = MessageFormat.format("sc-{0}.log", tunnelIdentifier);
        }
        if (!(sauceConnectLogFile = new File(logFileDirectory, fileName)).exists() && !(sauceConnectLogFile = new File(this.getSauceConnectWorkingDirectory(), fileName)).exists()) {
            return null;
        }
        return sauceConnectLogFile;
    }

    static /* synthetic */ String access$000() {
        return WINDOWS_TEMP_DIR;
    }

    public static enum OperatingSystem {
        OSX("osx", "zip", "/tmp"),
        WINDOWS("win32", "zip", SauceConnectFourManager.access$000(), "sc.exe"),
        LINUX("linux", "tar.gz", "/tmp"),
        LINUX32("linux32", "tar.gz", "/tmp");

        private final String directoryEnding;
        private final String archiveExtension;
        private final String executable;
        private final String tempDirectory;

        private OperatingSystem(String directoryEnding, String archiveExtension, String tempDirectory, String executable) {
            this.directoryEnding = directoryEnding;
            this.archiveExtension = archiveExtension;
            this.executable = "bin" + File.separatorChar + executable;
            this.tempDirectory = tempDirectory;
        }

        private OperatingSystem(String directoryEnding, String archiveExtension, String tempDirectory) {
            this(directoryEnding, archiveExtension, tempDirectory, "sc");
        }

        public static OperatingSystem getOperatingSystem() {
            String os = System.getProperty("os.name").toLowerCase();
            if (OperatingSystem.isWindows(os)) {
                return WINDOWS;
            }
            if (OperatingSystem.isMac(os)) {
                return OSX;
            }
            if (OperatingSystem.isUnix(os)) {
                return OperatingSystem.is64BitLinux() ? LINUX : LINUX32;
            }
            throw new IllegalStateException("Unsupported OS: " + os);
        }

        private static boolean is64BitLinux() {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("uname -a");
                process.waitFor();
                return IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8).contains("64");
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }

        private static boolean isWindows(String os) {
            return os.contains("win");
        }

        private static boolean isMac(String os) {
            return os.contains("mac");
        }

        private static boolean isUnix(String os) {
            return os.contains("nux");
        }

        public String getDirectory(boolean useLatestSauceConnect) {
            return SauceConnectFourManager.SAUCE_CONNECT + this.getVersion(useLatestSauceConnect) + '-' + this.directoryEnding;
        }

        public String getFileName(boolean useLatestSauceConnect) {
            return this.getDirectory(useLatestSauceConnect) + '.' + this.archiveExtension;
        }

        private String getVersion(boolean useLatestSauceConnect) {
            return useLatestSauceConnect ? LATEST_SC_VERSION : SauceConnectFourManager.CURRENT_SC_VERSION;
        }

        public String getExecutable() {
            return this.executable;
        }

        public String getDefaultSauceConnectLogDirectory() {
            return this.tempDirectory;
        }
    }
}

