/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.ci;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Browser
implements Comparable<Browser> {
    private final String key;
    private final String os;
    private final String browserName;
    private final String version;
    private final String name;
    private final String longVersion;
    private final String longName;
    private String device;
    private String deviceType;
    private String deviceOrientation;
    private static final Map<String, String> oses;

    public Browser(String key, String os, String browserName, String longName, String version, String longVersion, String name) {
        this.key = key;
        this.os = os;
        this.browserName = browserName;
        this.longName = longName;
        this.version = version;
        this.longVersion = longVersion;
        this.name = name;
    }

    public Browser(Browser original, boolean useLatest) {
        this.key = null;
        this.os = original.os;
        this.browserName = original.browserName;
        this.name = original.name;
        if (useLatest) {
            this.version = "latest";
            this.longVersion = "latest";
        } else {
            this.version = original.version;
            this.longVersion = original.longVersion;
        }
        this.longName = original.longName;
        this.device = original.device;
        this.deviceType = original.deviceType;
        this.deviceOrientation = original.deviceOrientation;
    }

    public String getKey() {
        if (this.key == null) {
            String browserKey = this.os + "_" + this.device + "_" + this.deviceOrientation + "_" + this.name + "_" + this.longVersion;
            browserKey = browserKey.replaceAll(" ", "_");
            browserKey = browserKey.replaceAll("\\.", "_");
            return browserKey;
        }
        return this.key;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String getName() {
        String newName = this.name.toLowerCase();
        if (oses.containsKey(newName)) {
            return oses.get(newName);
        }
        return this.name;
    }

    public String getOs() {
        return this.os;
    }

    public String getVersion() {
        return this.version;
    }

    private static boolean isBetterMatch(String previous, String matcher) {
        return previous == null || matcher.length() >= previous.length();
    }

    public String getPlatform() {
        return this.os;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Browser)) {
            return false;
        }
        Browser browser = (Browser)object;
        return (this.key == null ? browser.key == null : this.key.equals(browser.key)) && (this.browserName == null ? browser.browserName == null : this.browserName.equals(browser.browserName)) && (this.name == null ? browser.name == null : this.name.equals(browser.name)) && (this.os == null ? browser.os == null : this.os.equals(browser.os)) && (this.deviceType == null ? browser.deviceType == null : this.deviceType.equals(browser.deviceType)) && (this.version == null ? browser.version == null : this.version.equals(browser.version));
    }

    public int hashCode() {
        int result = 17;
        if (this.key != null) {
            result = 31 * result + this.key.hashCode();
        }
        if (this.browserName != null) {
            result = 31 * result + this.browserName.hashCode();
        }
        if (this.name != null) {
            result = 31 * result + this.name.hashCode();
        }
        if (this.os != null) {
            result = 31 * result + this.os.hashCode();
        }
        if (this.version != null) {
            result = 31 * result + this.version.hashCode();
        }
        if (this.deviceType != null) {
            result = 31 * result + this.deviceType.hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(Browser browser) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.name, browser.name);
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    public String getUri() {
        return this.getUri(null, null);
    }

    public String getUri(String username, String accessKey) {
        StringBuilder builder = new StringBuilder();
        builder.append("sauce-ondemand:?os=").append(this.os).append("&browser=").append(this.browserName).append("&browser-version=").append(this.version);
        if (username != null) {
            builder.append("&username=").append(username);
        }
        if (accessKey != null) {
            builder.append("&access-key=").append(accessKey);
        }
        return builder.toString();
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceOrientation(String deviceOrientation) {
        this.deviceOrientation = deviceOrientation;
    }

    public String getDeviceOrientation() {
        return this.deviceOrientation;
    }

    public String getLongVersion() {
        return this.longVersion;
    }

    public String getLongName() {
        return this.longName;
    }

    static {
        HashMap<String, String> aMap = new HashMap<String, String>();
        aMap.put("windows 10", "Windows 10");
        aMap.put("windows 2012 r2", "Windows 8.1");
        aMap.put("windows 2012", "Windows 8");
        aMap.put("windows 2008", "Windows 7");
        aMap.put("windows 2003", "Windows XP");
        aMap.put("linux", "Linux");
        aMap.put("mac 10.12", "macOS Sierra");
        aMap.put("mac 10.11", "OS X El Capitan");
        aMap.put("mac 10.10", "OS X Yosemite");
        aMap.put("mac 10.9", "OS X Mavericks");
        aMap.put("mac 10.8", "OS X Mountain Lion");
        oses = Collections.unmodifiableMap(aMap);
    }
}

