/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.filter.patch;

import com.sap.scimono.SCIMFilterParser;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.patch.PatchOperation;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.entity.validation.patch.PatchValidationException;
import com.sap.scimono.entity.validation.patch.PathAttributeExistenceValidator;
import com.sap.scimono.entity.validation.patch.PathMutabilityValidator;
import com.sap.scimono.entity.validation.patch.PathSchemaExistenceValidator;
import com.sap.scimono.entity.validation.patch.ValuePathAttributesValidator;
import com.sap.scimono.exception.SCIMException;
import com.sap.scimono.filter.QueryFilterVisitor;
import java.util.ArrayList;

public class ValuePathAttributesValidationVisitor
extends QueryFilterVisitor<Void, Void> {
    protected ValuePathAttributesValidator valuePathValidator;
    protected String currentAttributePath;
    protected PatchOperation operation;

    public ValuePathAttributesValidationVisitor(ValuePathAttributesValidator valuePathValidator, PatchOperation operation) {
        this(valuePathValidator, operation, valuePathValidator.getCoreSchemaId());
    }

    private ValuePathAttributesValidationVisitor(ValuePathAttributesValidator valuePathValidator, PatchOperation operation, String currentAttributePath) {
        this.valuePathValidator = valuePathValidator;
        this.operation = operation;
        this.currentAttributePath = currentAttributePath;
    }

    @Override
    public Void visitAttrPath(SCIMFilterParser.AttrPathContext ctx) {
        return ctx.accept(new AttrPathVisitor(this.valuePathValidator, this.operation, this.currentAttributePath));
    }

    @Override
    public Void visitValuePath(SCIMFilterParser.ValuePathContext ctx) {
        return ctx.accept(new ValuePathExpressionVisitor(this.valuePathValidator, this.operation, this.currentAttributePath));
    }

    protected void validateAttribute(String attributeName) {
        String fullAttrName;
        if (this.isParentAttribute()) {
            fullAttrName = SchemasCallback.addSchemaToPathIfNotExist(attributeName, this.valuePathValidator.getCoreSchemaId());
        } else if (this.isSubAttrBelongToParentSchema(attributeName, this.valuePathValidator.getCoreSchemaId())) {
            fullAttrName = this.createMultivaluedFullSubAttributeNotation(attributeName);
        } else {
            throw new PatchValidationException(SCIMException.Type.INVALID_PATH, String.format("Attribute with name '%s' does not exist", attributeName));
        }
        this.validateAttributeByFullAttributeNotation(fullAttrName);
    }

    protected void validateAttributeByFullAttributeNotation(String fullAttrNotation) {
        ArrayList<Validator<PatchOperation>> syntaxValidators = new ArrayList<Validator<PatchOperation>>();
        SchemasCallback schemaAPI = this.valuePathValidator.getSchemaAPI();
        syntaxValidators.add(new PathSchemaExistenceValidator(this.valuePathValidator.getRequiredSchemas()));
        syntaxValidators.add(new PathAttributeExistenceValidator(schemaAPI));
        if (schemaAPI.getSchema(this.currentAttributePath) != null) {
            syntaxValidators.add(new PathMutabilityValidator(schemaAPI));
        }
        PatchOperation newPatchOperation = new PatchOperation.Builder(this.operation).setPath(fullAttrNotation).build();
        syntaxValidators.forEach(validator -> validator.validate(newPatchOperation));
    }

    private String createMultivaluedFullSubAttributeNotation(String subAttributeName) {
        SchemasCallback schemaAPI = this.valuePathValidator.getSchemaAPI();
        if (SchemasCallback.isAttributeNotationContainsSchema(subAttributeName)) {
            return subAttributeName;
        }
        return schemaAPI.appendSubAttributeToPath(this.currentAttributePath, subAttributeName);
    }

    private boolean isParentAttribute() {
        return this.valuePathValidator.getCoreSchemaId().equals(this.currentAttributePath);
    }

    private boolean isSubAttrBelongToParentSchema(String targetAttr, String parentAttr) {
        if (!SchemasCallback.isAttributeNotationContainsSchema(targetAttr)) {
            return true;
        }
        SchemasCallback schemaAPI = this.valuePathValidator.getSchemaAPI();
        String targetAttrSchema = schemaAPI.getSchemaIdFromAttributeNotation(targetAttr);
        return parentAttr.startsWith(targetAttrSchema);
    }

    @Override
    public Void getParsedFilter() {
        return null;
    }

    private static class ValuePathExpressionVisitor
    extends ValuePathAttributesValidationVisitor {
        private ValuePathExpressionVisitor(ValuePathAttributesValidator valuePathValidator, PatchOperation operation, String currentAttributePath) {
            super(valuePathValidator, operation, currentAttributePath);
        }

        @Override
        public Void visitValuePath(SCIMFilterParser.ValuePathContext ctx) {
            SCIMFilterParser.AttrPathContext pathContext = ctx.attrPath();
            pathContext.accept(new AttrPathVisitor(this.valuePathValidator, this.operation, this.currentAttributePath));
            String attributeName = pathContext.getText();
            SchemasCallback schemaAPI = this.valuePathValidator.getSchemaAPI();
            if (SchemasCallback.isAttributeNotationContainsSchema(attributeName)) {
                attributeName = schemaAPI.removeSchemaFromAttributeNotation(attributeName, this.valuePathValidator.getCoreSchemaId());
            }
            String newCurrentAttributePath = schemaAPI.appendSubAttributeToPath(this.currentAttributePath, attributeName);
            return (Void)ctx.valFilter().accept(new ValuePathAttributesValidationVisitor(this.valuePathValidator, this.operation, newCurrentAttributePath));
        }
    }

    private static class AttrPathVisitor
    extends ValuePathAttributesValidationVisitor {
        private AttrPathVisitor(ValuePathAttributesValidator valuePathValidator, PatchOperation operation, String currentAttributePath) {
            super(valuePathValidator, operation, currentAttributePath);
        }

        @Override
        public Void visitAttrPath(SCIMFilterParser.AttrPathContext ctx) {
            String attributeName = ctx.getText();
            this.validateAttribute(attributeName);
            return null;
        }
    }
}

