/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.definition;

import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.definition.NotExistingScimAttributeException;
import com.sap.scimono.entity.definition.ScimAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

class ScimAttributeImpl<T extends ScimAttribute<T>>
implements ScimAttribute<T> {
    private String attributeName;
    private String schemaId;
    private T parent;
    private Supplier<T[]> allSchemaAttributes;

    ScimAttributeImpl(String attributeName, String schemaId, T parent, Supplier<T[]> allSchemaAttributes) {
        this.attributeName = attributeName;
        this.schemaId = schemaId;
        this.parent = parent;
        this.allSchemaAttributes = allSchemaAttributes;
    }

    @Override
    public boolean isTopLevelAttribute() {
        return this.parent == null;
    }

    @Override
    public String scimName() {
        return this.attributeName;
    }

    @Override
    public T subAttributeFrom(String childAttributeName) {
        return (T)Stream.of(this.allSchemaAttributes.get()).filter(scimAttribute -> !scimAttribute.isTopLevelAttribute()).filter(scimAttribute -> this.equals(scimAttribute.getParent())).filter(scimAttribute -> childAttributeName.equalsIgnoreCase(scimAttribute.scimName())).findFirst().orElseThrow(() -> new NotExistingScimAttributeException(childAttributeName));
    }

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public String getSchemaId() {
        return this.schemaId;
    }

    @Override
    public String fullAttributePath() {
        if (this.parent == null) {
            return SchemasCallback.addSchemaToPathIfNotExist(this.attributeName, this.schemaId);
        }
        return String.join((CharSequence)".", this.parent.fullAttributePath(), this.attributeName);
    }

    @Override
    public String relativePath() {
        if (this.parent == null) {
            return this.attributeName;
        }
        return String.join((CharSequence)".", this.parent.relativePath(), this.attributeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        ScimAttribute that = (ScimAttribute)o;
        return Objects.equals(this.scimName(), that.scimName()) && Objects.equals(this.getSchemaId(), that.getSchemaId()) && Objects.equals(this.getParent(), that.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.schemaId, this.parent, this.allSchemaAttributes);
    }
}

