/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.EnterpriseExtension;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.base.Extension;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.exception.SCIMException;
import com.sap.scimono.helper.Objects;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public abstract class Resource<T>
implements Serializable {
    public static final String CORE_SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:";
    private static final long serialVersionUID = 1726103518645055449L;
    private static final Predicate<Map.Entry<String, Extension>> CUSTOM_EXTENSION_FILTER = extension -> ((String)extension.getKey()).startsWith("urn:sap:cloud:scim:schemas:extension:custom:2.0:");
    private final String id;
    private final String externalId;
    private final Meta meta;
    @JsonProperty(required=true)
    private final Set<String> schemas;
    private final Map<String, Extension> extensions;

    protected Resource(@JsonProperty(value="id") String id, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas", required=true) Set<String> schemas) {
        this.id = id;
        this.externalId = externalId;
        this.meta = meta;
        if (schemas == null || schemas.isEmpty()) {
            throw new InvalidInputException("Schemas cannot be null or empty!");
        }
        this.schemas = schemas;
        this.extensions = new HashMap<String, Extension>();
    }

    protected Resource(Builder<T> builder) {
        this.id = ((Builder)builder).id;
        this.externalId = builder.externalId;
        this.meta = ((Builder)builder).meta;
        this.schemas = ((Builder)builder).schemas;
        this.extensions = ((Builder)builder).extensions;
    }

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Meta getMeta() {
        return this.meta;
    }

    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) Set<String> getSchemas() {
        return new HashSet<String>(this.schemas);
    }

    @JsonAnyGetter
    public Map<String, Extension> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    public Extension getExtension(String urn) {
        if (urn == null || urn.isEmpty()) {
            throw new IllegalArgumentException("urn must be neither null nor empty");
        }
        if (!this.extensions.containsKey(urn)) {
            throw new NoSuchElementException("extension " + urn + " is not available");
        }
        return this.extensions.get(urn);
    }

    public boolean isExtensionPresent(String urn) {
        return this.extensions.containsKey(urn);
    }

    public boolean hasExtensions() {
        return !this.extensions.isEmpty();
    }

    public boolean hasCustomExtensions() {
        return this.extensions.entrySet().stream().anyMatch(CUSTOM_EXTENSION_FILTER);
    }

    @JsonIgnore
    public Map<String, Extension> getCustomExtensions() {
        return this.extensions.entrySet().stream().filter(CUSTOM_EXTENSION_FILTER).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonAnySetter
    public void handleExtensionSchema(String schemaId, Object value) {
        if (!this.isExtensionAllowed(schemaId) || !(value instanceof Map)) {
            throw new SCIMException(null, "Invalid user attribute: " + schemaId);
        }
        Map extensionAttributes = (Map)value;
        Extension ext = "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User".equals(schemaId) ? new EnterpriseExtension.Builder(extensionAttributes).build() : new Extension.Builder(schemaId).setAttributes(extensionAttributes).build();
        this.extensions.put(schemaId, ext);
    }

    private boolean isExtensionAllowed(String schemaId) {
        return ("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User".equals(schemaId) || SchemasCallback.isCustomSchema(schemaId)) && this.schemas.contains(schemaId);
    }

    public abstract Builder<T> builder();

    public int hashCode() {
        int prime = 31;
        int result = java.util.Objects.hash(this.extensions);
        result = 31 * result + java.util.Objects.hash(this.id);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.id != null && other.id != null && !java.util.Objects.equals(this.id, other.id)) {
            return false;
        }
        return java.util.Objects.equals(this.extensions, other.extensions);
    }

    public static abstract class Builder<T> {
        String externalId;
        private String id;
        private Meta meta;
        private Set<String> schemas = new HashSet<String>();
        private Map<String, Extension> extensions = new HashMap<String, Extension>();

        public Builder(Resource<T> resource) {
            if (resource != null) {
                this.id = ((Resource)resource).id;
                this.externalId = ((Resource)resource).externalId;
                this.meta = ((Resource)resource).meta;
                this.schemas = ((Resource)resource).schemas;
                this.extensions = new HashMap<String, Extension>(Objects.firstNonNull(((Resource)resource).extensions, this.extensions));
            }
        }

        protected void addSchema(String schema) {
            this.schemas.add(schema);
        }

        public Builder<T> setId(String id) {
            this.id = id;
            return this;
        }

        public Builder<T> setExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder<T> setMeta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public Builder<T> addExtensions(Collection<Extension> extensions) {
            if (extensions != null) {
                extensions.forEach(this::addExtension);
            }
            return this;
        }

        public Builder<T> addExtension(Extension extension) {
            if (extension != null) {
                this.extensions.put(extension.getUrn(), extension);
                this.addSchema(extension.getUrn());
            }
            return this;
        }

        public Builder<T> removeExtensions() {
            this.extensions.clear();
            return this;
        }

        public Builder<T> removeExtension(String urn) {
            this.extensions.remove(urn);
            return this;
        }

        public abstract T build();

        protected <V extends MultiValuedAttribute> boolean isMultivaluedAttributeExistInCollection(V targetAttribute, Collection<V> collection) {
            for (MultiValuedAttribute currentAttribute : collection) {
                if (currentAttribute.getValue() == null || !currentAttribute.equals(targetAttribute)) continue;
                return true;
            }
            return false;
        }
    }
}

