/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.entity.base.MultiValuedAttributeType;
import com.sap.scimono.entity.data.ImageDataURI;
import com.sap.scimono.entity.data.PhotoValueType;
import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public final class Photo
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = -3801047382575408796L;
    private final Type type;

    @JsonCreator
    public Photo(@JsonProperty(value="operation") String operation, @JsonProperty(value="value") String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private Photo(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    public URI getValueAsURI() {
        URI uri;
        try {
            uri = new URI(super.getValue());
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException(e.getMessage());
        }
        return uri;
    }

    @JsonIgnore
    private ImageDataURI getValueAsImageDataURI() {
        return new ImageDataURI(super.getValue());
    }

    @JsonIgnore
    public PhotoValueType getValueType() {
        PhotoValueType photoType;
        if (super.getValue().startsWith("data:image/") && super.getValue().contains(";base64,")) {
            this.getValueAsImageDataURI();
            photoType = PhotoValueType.IMAGE_DATA_URI;
        } else {
            this.getValueAsURI();
            photoType = PhotoValueType.URI;
        }
        return photoType;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Photo)) {
            return false;
        }
        Photo other = (Photo)obj;
        return Objects.equals(this.type, other.type);
    }

    @Override
    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("value", this.getValue());
        valuesToDisplay.put("type", this.type);
        valuesToDisplay.put("primary", this.isPrimary());
        valuesToDisplay.put("operation", this.getOperation());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    public static class Type
    extends MultiValuedAttributeType {
        private static final long serialVersionUID = 5676963413757504786L;
        public static final Type PHOTO = new Type("photo");
        public static final Type THUMBNAIL = new Type("thumbnail");

        Type(String typeName) {
            super(typeName);
        }

        public static Type of(String typeName) {
            if (Strings.isNullOrEmpty(typeName)) {
                return null;
            }
            return new Type(typeName);
        }
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        private Type type;

        public Builder() {
        }

        public Builder(Photo photo) {
            super(photo);
            this.type = photo.type;
        }

        @Override
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        public Builder setValue(URI uri) {
            super.setValue(uri.toString());
            return this;
        }

        public Builder removeValue() {
            super.setValue(null);
            return this;
        }

        public Builder setValue(ImageDataURI image) {
            super.setValue(image.toString());
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setPrimary(Boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        @Override
        public Photo build() {
            return new Photo(this);
        }
    }
}

