/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.definition.EnterpriseUserAttributes;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Manager
implements Serializable {
    private static final long serialVersionUID = -1341197800095918850L;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="$ref")
    private final String reference;
    @JsonProperty
    private final String displayName;

    @JsonCreator
    public Manager(@JsonProperty(value="value") String value, @JsonProperty(value="$ref") String reference, @JsonProperty(value="displayName") String displayName) {
        this.value = value;
        this.reference = reference;
        this.displayName = displayName;
    }

    private Manager(Builder builder) {
        this.value = builder.value;
        this.reference = builder.reference;
        this.displayName = builder.displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getReference() {
        return this.reference;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return Strings.isNullOrEmpty(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.displayName);
        result = 31 * result + Objects.hash(this.reference);
        result = 31 * result + Objects.hash(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Manager)) {
            return false;
        }
        Manager other = (Manager)obj;
        if (!Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        if (!Objects.equals(this.reference, other.reference)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    public static class Builder {
        private String value;
        private String reference;
        private String displayName;

        public Builder() {
        }

        public Builder(Manager manager) {
            this.value = manager.value;
            this.reference = manager.reference;
            this.displayName = manager.displayName;
        }

        public Builder(Map<String, String> managerValues) {
            if (managerValues != null) {
                this.value = managerValues.get(EnterpriseUserAttributes.MANAGER_VALUE.scimName());
                this.reference = managerValues.get(EnterpriseUserAttributes.MANAGER_REF.scimName());
                this.displayName = managerValues.get(EnterpriseUserAttributes.MANAGER_DISPLAY_NAME.scimName());
            }
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setReference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Manager build() {
            return new Manager(this);
        }
    }
}

