/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface Strings {
    public static String join(String ... strings) {
        return Arrays.stream(strings).collect(Collectors.joining());
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(char[] string) {
        return string == null || string.length == 0;
    }

    public static boolean isNotNullOrEmpty(String string) {
        return !Strings.isNullOrEmpty(string);
    }

    public static boolean allNullOrEmpty(String ... strings) {
        return Arrays.stream(strings).allMatch(Strings::isNullOrEmpty);
    }

    public static boolean allNotNullOrEmpty(String ... strings) {
        return Arrays.stream(strings).allMatch(Strings::isNotNullOrEmpty);
    }

    public static boolean containsIgnoreCase(String str1, String str2) {
        return str1.toLowerCase(Locale.ENGLISH).contains(str2.toLowerCase(Locale.ENGLISH));
    }

    public static boolean startsWithIgnoreCase(String str1, String str2) {
        return str1.toLowerCase(Locale.ENGLISH).startsWith(str2.toLowerCase(Locale.ENGLISH));
    }

    public static String lastOccurrence(String lastPartToMatch) {
        String regex = lastPartToMatch + "$";
        if (lastPartToMatch.startsWith("$")) {
            regex = "\\" + regex;
        }
        return regex;
    }

    public static boolean wildcardedMatch(String checkedString, List<String> wildcardedStringCollection) {
        ArrayList<Pattern> wildcardedStringsPatterns = new ArrayList<Pattern>();
        for (String wildcardedString : wildcardedStringCollection) {
            wildcardedStringsPatterns.add(Pattern.compile(wildcardedString.replace("*", ".*")));
        }
        for (Pattern currentPattern : wildcardedStringsPatterns) {
            if (!currentPattern.matcher(checkedString).matches()) continue;
            return true;
        }
        return false;
    }

    public static String stripStart(String str, String strip) {
        int start;
        if (str == null) {
            return null;
        }
        int strLength = str.length();
        if (strip == null) {
            for (start = 0; start != strLength && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            while (start != strLength && strip.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String createPrettyEntityString(Map<String, Object> attributes, Class<?> entityClass) {
        StringBuilder pattern = new StringBuilder("%s [");
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(entityClass.getName());
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            pattern.append("%s=%s, ");
            result.add(attribute.getKey());
            result.add(attribute.getValue());
        }
        pattern.append("]");
        return String.format(pattern.toString(), result.toArray(new Object[0]));
    }
}

