/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.exception;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class SCIMException
extends WebApplicationException {
    private static final long serialVersionUID = 7916443182706462000L;
    private final Type scimType;

    public SCIMException(Type scimType, String message) {
        super(message);
        this.scimType = scimType;
    }

    public SCIMException(Type scimType, String message, Response.Status status) {
        super(message, status);
        this.scimType = scimType;
    }

    public SCIMException(SCIMException scimException) {
        super(scimException.getMessage(), scimException.getResponse().getStatus());
        this.scimType = scimException.scimType;
    }

    public String getScimType() {
        return this.scimType == null ? null : this.scimType.toJson();
    }

    public static enum Type {
        INVALID_FILTER("invalidFilter"),
        TOO_MANY("tooMany"),
        UNIQUENESS("uniqueness"),
        MUTABILITY("mutability"),
        INVALID_SYNTAX("invalidSyntax"),
        INVALID_PATH("invalidPath"),
        NO_TARGET("noTarget"),
        INVALID_VALUE("invalidValue"),
        INVALID_VERSION("invalidVers"),
        SENSITIVE("sensitive");

        private final String jsonRepresentation;

        private Type(String jsonRepresentation) {
            this.jsonRepresentation = jsonRepresentation;
        }

        String toJson() {
            return this.jsonRepresentation;
        }
    }
}

